<?php

/**
 * @copyright	Copyright (C) 2011 Cédric KEIFLIN alias ced1870
 * http://www.joomlack.fr
 * Module Kwickmenu CK
 * @license		GNU/GPL
 * */
// no direct access
defined('_JEXEC') or die('Restricted access');

class modKwickmenuckHelper {

    static function GetMenu(&$params, $module) {
        jimport('joomla.application.module.helper');


        // retrieve parameters from the module
        $minsize = $params->get('minsize', '100');
        $maxsize = $params->get('maxsize', '285');
        $orientation = $params->get('orientation', 'verti');
        $mooduration = $params->get('mooduration', '500');
        $mootransition = $params->get('mootransition', 'Quad');
        $mooease = $params->get('mooease', 'easeOut');
        $keepmenuopened = $params->get('keepmenuopened', '0');
        $activeitemopened = $params->get('activeitemopened', '1');


        $document = JFactory::getDocument();

        // add mootools effects
        JHTML::_("behavior.framework", true);

        $document->addScript(JURI::base() . 'modules/mod_kwickmenuck/assets/kwickmenuck.js');
        //$document->addStyleSheet(JURI::base() . 'modules/mod_kwickmenu_CK/assets/kwickmenu_CK.css');
        // load script
        $js = "window.addEvent('domready', function() {
                new KwickMenu_CK({
                modid : " . $module->id . ",
                orientation : '" . $orientation . "',
                mooease : '" . $mooease . "',
                mooduration : " . $mooduration . ",
                mootransition : '" . $mootransition . "',
                keepmenuopened : '" . $keepmenuopened . "',
                activeitemopened : '" . $activeitemopened . "',
                min : " . $minsize . ",
                max : " . $maxsize . "
                });
            });";

        $document->addScriptDeclaration($js);

        $app = JFactory::getApplication();
        $menu = $app->getMenu();
        $items = $menu->getItems('menutype', $params->get('menutype'));
        
        // If no active menu, use default
        $active = ($menu->getActive()) ? $menu->getActive() : $menu->getDefault();
        $path = isset($active) ? $active->tree : array();
        
        foreach ($items as $i => $item) {
            $item->active = false;
            $item->flink = $item->link;
            
            // add itemid class
            $item->classe = 'item' . $item->id;
            // add active class
            if ($item->type == 'alias' && is_array($path) &&
                            (is_array($path) &&
                            in_array($item->params->get('aliasoptions'),$path))
                    ||	(is_array($path) &&
                            in_array($item->id, $path))) {
                    $item->classe .= ' active';
                    $item->active = true;
            }

            // test if it is the default opened item
            if ($item->id == $params->get('defaultitemopened', '0')) $item->classe .= ' stayopen';

            switch ($item->type) {
                case 'separator':
                    // No further action needed.
                    continue;

                case 'url':
                    if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false)) {
                        // If this is an internal Joomla link, ensure the Itemid is set.
                        $item->flink = $item->link . '&Itemid=' . $item->id;
                    }
                    $item->flink = JFilterOutput::ampReplace(htmlspecialchars($item->flink));
                    break;

                case 'alias':
                    // If this is an alias use the item id stored in the parameters to make the link.
                    $item->flink = 'index.php?Itemid=' . $item->params->get('aliasoptions');
                    break;

                default:
                    $router = JSite::getRouter();
                    if ($router->getMode() == JROUTER_MODE_SEF) {
                        $item->flink = 'index.php?Itemid=' . $item->id;
                    } else {
                        $item->flink .= '&Itemid=' . $item->id;
                    }
                    break;
            }

            if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false)) {
                $item->flink = JRoute::_($item->flink, true, $item->params->get('secure'));
            } else {
                $item->flink = JRoute::_($item->flink);
            }



            $item->title = htmlspecialchars($item->title);
            $item->anchor_css = htmlspecialchars($item->params->get('menu-anchor_css', ''));
            $item->anchor_title = htmlspecialchars($item->params->get('menu-anchor_title', ''));
            $item->menu_image = htmlspecialchars($item->params->get('menu_image', 'modules/mod_kwickmenuck/assets/joomlack_kwick.png'));
        }
        return $items;
    }

}

?>