/**
 * @copyright	Copyright (C) 2011 Cédric KEIFLIN alias ced1870
 * http://www.ck-web-creation-alsace.com
 * http://www.joomlack.fr
 * Module Kwickmenu_CK for Joomla! 1.6
 * @license		GNU/GPL
 * Original script from David Walsh : http://davidwalsh.name/get-slick-mootools-kwicks
**/

var KwickMenu_CK = new Class({
    Implements: Options,
    options: {    //options par défaut si aucune option utilisateur n'est renseign�e
        modid : 1,	
        orientation : 'horiz',
        mooduration : 500,
        mootransition : 'Quad',
        mooease : 'easeOut',
        min : 100,
        keepmenuopened : '1',
        activeitemopened : '1',
        max : 285
    },
			
    initialize: function(options) {
        this.setOptions(options); //enregistre les options utilisateur
        //alert(options.largeurmax);
        var squeeze_to = this.options.min;
        var max_width = this.options.max;
        var maduree = this.options.mooduration;
        var matransition = this.options.mootransition;
        var monease = this.options.mooease;
        var kwickmenu = 'kwick'+this.options.modid;
        var activeitemopened = this.options.activeitemopened;


        //get original widths
        var start_dims = new Array();
        var kwicks = $$('#kwick'+this.options.modid+' .kwick');
        var orientation = this.options.orientation;
        //var kwicks = element;
        var myTransition = new Fx.Transition(Fx.Transitions[matransition][monease]);
        var fx = new Fx.Elements(kwicks, {
            link: 'cancel', 
            duration: maduree, 
            transition:myTransition
        });
        kwicks.each(function(kwick, i){
            if (orientation == 'horiz') {
                start_dims[i] = kwick.getStyle('width').toInt();
            } else {
                start_dims[i] = kwick.getStyle('height').toInt();
            }
        
            // set the active item ON
            if (activeitemopened == 1) {
                if (kwick.getParent().hasClass('active')
                    || (kwick.getParent().hasClass('stayopen') && !$(kwickmenu).getElement('.active')) )
                    kwick.setStyle('width', max_width);
            }

            //mouse is in, squeeze and expand
            kwick.addEvent('mouseenter', function(e){

                var obj = {};
				
                if (orientation == 'horiz') {
                    obj[i] = {
                        'width': [kwick.getStyle('width').toInt(), max_width]
                        };
                } else {
                    obj[i] = {
                        'height': [kwick.getStyle('height').toInt(), max_width]
                        };
                }
				

                var counter = 0;

                kwicks.each(function(other, j){
                    
                    if (other != kwick){
                        if (orientation == 'horiz') {
                            var w = other.getStyle('width').toInt();
                            if (w != squeeze_to) obj[j] = {
                                'width': [w,squeeze_to]
                            };
                        } else {
                            var w = other.getStyle('height').toInt();
                            if (w != squeeze_to) obj[j] = {
                                'height': [w,squeeze_to]
                            };
                        }
                    }
                });
                fx.start(obj);
            }
            );
        });

        //mouse is out, squeeze back
        if (this.options.keepmenuopened != '1') {
            $('kwick'+this.options.modid).addEvent('mouseleave', function(e){
                var obj = {};
                kwicks.each(function(other, j){
                    if (orientation == 'horiz') {
                        obj[j] = {
                            'width': [other.getStyle('width').toInt(), start_dims[j]]
                            };
                    } else {
                        obj[j] = {
                            'height': [other.getStyle('height').toInt(), start_dims[j]]
                            };
                    }
                });
                fx.start(obj);
            });
        }
    }
});

KwickMenu_CK.implement(new Options);

//lock and load!
//window.addEvent('domready',Kwix.start);
/*window.addEvent('domready', function() {
			new KwickMenu_CK({id:1,min:100,max:285});
		});*/