<?php

/*
 * @version		$Id: view.html.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies PVT Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import libraries
require_once( JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_yendifvideoshare'.DS.'libraries'.DS.'player.php' );

class YendifVideoShareViewVideo extends YendifVideoShareView {

    function display( $tpl = null ) {
	    $app = JFactory::getApplication();
		
		$model = $this->getModel();
		
		$this->config = YendifVideoShareUtils::getConfig();
		$this->params = $app->getParams();		
		$this->rows   = $this->params->get('no_of_rows', $this->config->no_of_rows);
		$this->cols   = $this->params->get('no_of_cols', $this->config->no_of_cols);
		
		$this->show_views = $this->params->get('show_views', $this->config->show_views);
		if( $this->show_views == 'global' ) {
			$this->show_views = $this->config->show_views;
		}
		
		$this->show_rating = $this->params->get('show_rating', $this->config->show_rating);
		if( $this->show_rating == 'global' ) {
			$this->show_rating = $this->config->show_rating;
		}
		
		$this->enable_popup = $this->params->get('enable_popup', $this->config->enable_popup);
		if( $this->enable_popup == 'global' ) {
			$this->enable_popup = $this->config->enable_popup;	
		}
		
		$this->show_likes_dislikes = $this->params->get('show_likes_dislikes', $this->config->show_likes);
		if( $this->show_likes_dislikes == 'global' ) {
			$this->show_likes_dislikes = $this->config->show_likes;						
		}
		
		$this->ratio = $this->params->get('ratio', $this->config->ratio);
		
		$this->item = $model->getItem( $this->config->schedule_video_publishing );
		
		if( empty( $this->item ) ) {
			JError::raiseNotice( 21, JText::_('YENDIF_VIDEO_SHARE_ITEM_NOT_FOUND') );
			return true;
		}
		
		$playerObj = YendifVideoSharePlayer::getInstance( $this->config );		
		$player_params = (array) json_decode( $this->params );
		$player_params['videoid'] = JRequest::getInt('id');		
		if( JRequest::getCmd('tmpl') == 'component' ) {
			echo $playerObj->embedPlayer( $player_params );
			exit();
		} else {
			$this->player = $playerObj->singlePlayer( $player_params );
		}
		
		$filterby = $this->params->get('filterby', 'none');
		$orderby  = $this->params->get('orderby');
		
		$this->videos = $model->getVideos( $this->rows * $this->cols, $this->item->catid, $filterby, $orderby, $this->config->schedule_video_publishing );
		
		$this->pagination = $model->getPagination( $this->item->catid, $filterby, $this->config->schedule_video_publishing );
		
		$this->access = YendifVideoShareUtils::hasPermission( $this->item->access );
		
		if( $this->access && $this->show_rating ) {
			$total_rated_users = $model->getTotalRatedUsers();			
			$this->rating_widget = YendifVideoShareUtils::RatingWidget( $this->item->rating, $this->item->id, $total_rated_users );
		};				
		
		$this->setHeader();
		$this->addBreadcrumbs();
				
        parent::display( $tpl );
    }
	
	function setHeader() {
		JHtml::_('jquery.framework');
		
		$document = JFactory::getDocument();
		
		$document->setTitle( $document->getTitle() . ' - ' . $this->item->title );

		if( $this->params->get('menu-meta_description') ) $document->setDescription( $this->params->get('menu-meta_description') );
		if( ! empty( $this->item->meta_description ) ) $document->setDescription( $this->item->meta_description );
		
		if( $this->item->meta_keywords == '' && $this->params->get('menu-meta_keywords') ) $document->setMetadata( 'keywords', $this->params->get('menu-meta_keywords') );
		if( ! empty( $this->item->meta_keywords ) ) $document->setMetaData( 'keywords' , $this->item->meta_keywords );
		
		if( $this->params->get('robots') ) $document->setMetadata( 'robots', $this->params->get('robots') );
		if( ! empty( $this->config->responsive ) ) $document->addStyleDeclaration( $this->config->responsive_css );	

		if( $this->config->bootstrap_version == 3 ) $document->addStyleSheet( JURI::root()."media/yendifvideoshare/assets/site/css/bootstrap.css?v=1.2.5", 'text/css', "screen" );
		if( $this->enable_popup ) $document->addStyleSheet( JURI::root().'media/yendifvideoshare/assets/site/css/magnific-popup.css?v=1.2.5', 'text/css', "screen" );
		$document->addStyleSheet( JURI::root()."media/yendifvideoshare/assets/site/css/yendifvideoshare.css?v=1.2.5", 'text/css', "screen" );
		if( ! empty( $this->config->responsive_css ) ) $document->addStyleDeclaration( $this->config->responsive_css );
		
		if( $this->enable_popup ) $document->addScript( JURI::root().'media/yendifvideoshare/assets/site/js/jquery.magnific-popup.min.js?v=1.2.5' );
		$document->addScript( JURI::root()."media/yendifvideoshare/assets/site/js/yendifvideoshare.js?v=1.2.5" );
		if( $this->config->comments == 'facebook' ) {
			$document->addCustomTag("
				<script type='text/javascript'>
					(function(d, s, id) {
	  					var js, fjs = d.getElementsByTagName(s)[0];
	  					if (d.getElementById(id)) return;
	  					js = d.createElement(s); js.id = id;
	  					js.src = '//connect.facebook.net/".JText::_('YENDIF_VIDEO_SHARE_FACEBOOK_LANGUAGE')."/all.js#appId=".$this->config->fb_app_id."&xfbml=1';
	 					fjs.parentNode.insertBefore(js, fjs);
					}(document, 'script', 'facebook-jssdk')); 
				</script> 
			");
			
			if( $this->config->fb_app_id ) $document->addCustomTag( '<meta property="fb:app_id" content="'.$this->config->fb_app_id.'">' );
		};
	}
	
	function addBreadcrumbs() {
		jimport( 'joomla.application.pathway' );
		
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();

		$breadcrumbs = $app->getPathway();
		$crumbs = array();
		$Itemid =  JRequest::getInt('Itemid');
		$index = 0;	

		$query = 'SELECT * FROM #__yendifvideoshare_categories WHERE id='. $db->quote( $this->item->catid );
		$db->setquery( $query );
		$item = $db->loadObject();		
		
		if( $item && ! $item->parent == 0 ) {
			$query = 'SELECT * FROM #__yendifvideoshare_categories WHERE id = '.$item->parent;
			$db->setquery( $query );
			$parent_category = $db->loadObject();			
					
			if( $parent_category->parent != 0 ) {
				$query = 'SELECT * FROM #__yendifvideoshare_categories WHERE id = '.$parent_category->parent;
				$db->setquery($query);
				$top_category = $db->loadObject();
				
				$crumbs[$index][0] = $top_category->name;
				$crumbs[$index][1] = JRoute::_('index.php?option=com_yendifvideoshare&Itemid='.$Itemid.'&view=category&id='.$top_category->id);
				$index++;	
			}
			$crumbs[$index][0] = $parent_category->name;
			$crumbs[$index][1] = JRoute::_('index.php?option=com_yendifvideoshare&Itemid='.$Itemid.'&view=category&id='.$parent_category->id);
			$index++;
		}
		
		if( $item ) {
        	$crumbs[$index][0] = $item->name;		
			$crumbs[$index][1] = JRoute::_('index.php?option=com_yendifvideoshare&Itemid='.$Itemid.'&view=category&id='.$item->id);
			$index++;
		}
		
		$crumbs[$index][0] = $this->item->title;
		$crumbs[$index][1] = JRoute::_('index.php?option=com_yendifvideoshare&Itemid='.$Itemid.'&view=video&id='.$this->item->id);		

		for( $i = 0, $n = count( $crumbs ); $i < $n; $i++ ) {
			$breadcrumbs->addItem( $crumbs[$i][0], $crumbs[$i][1] );
		}
    }
	
}