<?php

/*
 * @version		$Id: default.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies PVT Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.formvalidation');
JHtml::_('jquery.framework');

$document = JFactory::getDocument();
$document->addScriptDeclaration("
	if( typeof( yendif ) === 'undefined' ) {
    	var yendif = {};
	};

	yendif.base = '".JURI::root()."';
	yendif.userid = ".JFactory::getUser()->get('id').";
	yendif.allow_guest_like = ".$this->config->allow_guest_like.";
	yendif.allow_guest_rating = ".$this->config->allow_guest_rating.";
	yendif.alert_message = '".JText::_('YENDIF_VIDEO_SHARE_PLEASE_LOGIN')."';
");

$itemId = JRequest::getInt('Itemid') ? '&Itemid=' . JRequest::getInt('Itemid') : '';
?>

<div class="yendif-video-share video <?php echo $this->escape( $this->params->get('pageclass_sfx') ); ?>">
	<?php if( $this->config->show_title ) : ?>
		<div class="page-header">
			<h1> <?php echo $this->escape( $this->item->title ); ?> </h1>
    	</div>
    <?php endif; ?>
    
    <div class="row-fluid">
    	<?php if( $this->config->show_category ) : ?>
        	<div class="pull-left muted">
            	<?php
					$meta = array();
					
					$meta[] = sprintf( '<i class="icon-folder"></i>&nbsp;<a href="%s">%s</a>', JRoute::_( 'index.php?option=com_yendifvideoshare&view=category&id='.$this->item->catid.':'.$this->item->cat_alias.$itemId ), $this->item->category );
										
					if( $this->config->show_user ) {
						$meta[] = '<span><i class="icon-user"></i>&nbsp;'.JFactory::getUser( $this->item->userid )->username.'</span>';
					}
					
					if( $this->config->show_date ) {
						$meta[] = '<span><i class="icon-calendar"></i>&nbsp;'.JHtml::_( 'date', $this->item->created_date, JText::_('DATE_FORMAT_LC3') );
					}
					
					if( $this->show_views ) {
						$meta[] = '<span><i class="icon-eye"></i>&nbsp;'.$this->item->views.' '.JText::_('YENDIF_VIDEO_SHARE_VIEWS').'</span>';
					}
					
					echo implode( ' / ',  $meta );
				?>
            </div>
        <?php endif; ?>
        
        <?php if( $this->config->show_search ) : ?>
        	<div class="pull-right">
            	<form action="<?php echo JRoute::_( 'index.php?option=com_yendifvideoshare&view=search'.$itemId ); ?>" class="form-validate" method="post">
                    <input type="hidden" name="option" value="com_yendifvideoshare" />
                    <input type="hidden" name="view" value="search" />
                    <input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
                    <div class="input-append">
                    	<input type="text" name="search" class="required" />
                    	<button type="submit" class="btn btn-default"><?php echo JText::_('YENDIF_VIDEO_SHARE_GO'); ?></button>
                    </div>
                </form>
            </div>
        <?php endif; ?>
        
        <div class="clearfix"></div>
    </div>
    
    <?php echo $this->player; ?>
    
    <?php if( $this->access && ( $this->show_rating || $this->show_likes_dislikes ) ) : ?>
    	<ul class="breadcrumb">
    		<?php if( $this->show_rating ) : ?>
   				<li id="yendif-ratings-widget">
                	<?php echo $this->rating_widget; ?> 
                </li>
        	<?php endif; ?>
            
            <?php if( $this->show_likes_dislikes ) : ?>
        		<li id="yendif-likes-dislikes-widget" class="pull-right">
                	<?php echo YendifVideoShareUtils::VotingWidget( $this->item->id, $this->config->allow_guest_like ); ?>
                </li>
        	<?php endif; ?>
    	</ul>
    <?php endif; ?>
    
    <?php
    	if( $this->config->show_description && ! empty( $this->item->description ) ) {
			echo $this->item->description;
		}		
		
		if( $this->config->share_script ) {
    		echo $this->config->share_script;
    	}
		
    	if( $this->access && $this->config->comments != 'none' ) {
			echo $this->loadTemplate('comments');
		}
		
  		if( count( $this->videos ) && $this->config->show_related ) {
			echo $this->loadTemplate('related');
		}
  	?>    
</div>