<?php 

/*
 * @version		$Id: edit.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.formvalidation');

$document = JFactory::getDocument();
$document->addScriptDeclaration("
	if( typeof( yendif ) === 'undefined' ) {
    	var yendif = {};
	};

	yendif.base = '".JURI::root()."';
	yendif.msg = [];
	yendif.msg['cancel'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_CANCEL')."';
	yendif.msg['success'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_SUCCCESS')."';	
	yendif.msg['invalid_file_type'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_ERROR_INVALID_FILE_TYPE')."';
	yendif.msg['invalid_file_size'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_ERROR_INVALID_FILE_SIZE')."';
	yendif.msg['invalid_mime_type'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_ERROR_INVALID_MIME_TYPE')."';
	yendif.msg['error_moving_file'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_ERROR_MOVING_FILE')."';
	yendif.msg['unknown_error'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_ERROR_UNKNOWN_ERROR')."';	
	yendif.msg['retry'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_RETRY')."';	
	yendif.msg['reset'] = '".JText::_('YENDIF_VIDEO_SHARE_UPLOAD_RESET')."';
	
	jQuery(document).ready(function() {
		var f = document.yendif_form;			
		var type = f.type.value;
			
		document.formvalidator.setHandler('list', function( value ) {
        	return (value != -1);
		});
			
		document.formvalidator.setHandler('mp4', function( value ) {
			if( type == 'video' ) {
				var url = value.split('.').pop();
				return /mp4|m4v|mov|flv/.test( url );
			};
				
			return true;
		});
		
		document.formvalidator.setHandler('hd', function( value ) {
			if( type == 'video' && value != '' ) {
				var url = value.split('.').pop();
				return /mp4|m4v|mov|/.test( url );
			};
				
			return true;
		});
			
		document.formvalidator.setHandler('webm', function( value ) {
			if( type == 'video' && value != '' ) {
				var url = value.split('.').pop();
				return /webm/.test( url );
			};
				
			return true;
		});	
			
		document.formvalidator.setHandler('ogg', function( value ) {
			if( type == 'video' && value != '' ) {
				var url = value.split('.').pop();
				return /ogg|ogv/.test( url );
			};
				
			return true;
		});		
			
		document.formvalidator.setHandler('youtube', function( value ) {
			if( type == 'youtube' ) {
				return (value != '');
			}
				
			return true;
		});
			
		document.formvalidator.setHandler('rtmp', function( value ) {
			if( type == 'rtmp' ) {
				return (value != '');
			}
			
			return true;
		});	
			
		document.formvalidator.setHandler('flash', function( value ) {
			if( type == 'rtmp' ) {
				return (value != '');
			}
				
			return true;
		});
			
		document.formvalidator.setHandler('mobile', function( value ) {
			if( type == 'rtmp' && value != '' ) {
				var url = value.split('.').pop();
				return /mp4|m4v|mov|m3u8|rtsp/.test( url );
			};
			
			return true;
		});
			
		document.formvalidator.setHandler('thirdparty', function( value ) {
			if( type == 'thirdparty' ) {
				return (value != '');
			}
			
			return true;
		});		
			
		document.formvalidator.setHandler('image', function( value ) {
			if( value != '' ) {
				var url = value.split('.').pop();
				return /jpg|jpeg|png|gif/.test( url );
			};
				
			return true;
		});	
			
		document.formvalidator.setHandler('captions', function( value ) {
			if( value != '' ) {
				var url = value.split('.').pop();
				return /vtt|srt/.test( url );
			};
				
			return true;
		});		
			
        jQuery( '#yendif_form' ).on( 'submit', function() {
			if( yendif.files > 0 ) {
        		alert('" . JText::_("YENDIF_VIDEO_SHARE_ERROR_UPLOAD_IN_PROGRESS") . "');
				return;
        	};
		});
	});
");

$itemId = JRequest::getInt('Itemid')  ? '&Itemid=' . JRequest::getInt('Itemid') : '';
?>

<div class="yendif-video-share videos edit <?php echo $this->escape( $this->params->get('pageclass_sfx') ); ?>">
	<div class="page-header">
  		<h1><?php echo JText::_('YENDIF_VIDEO_SHARE_EDIT_THIS_VIDEO'); ?></h1>
    </div>
    
    <form action="index.php" method="post" name="yendif_form" id="yendif_form" class="form-validate">
    	<div class="row-fluid form-horizontal">
			<div class="control-group">
            	<label class="control-label" for="title"><?php echo JText::_('YENDIF_VIDEO_SHARE_TITLE'); ?><span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<input type="text" name="title" id="title" class="required" value="<?php echo $this->item->title; ?>" />
            	</div>
        	</div>
            
            <div class="control-group">
            	<label class="control-label" for="catid"><?php echo JText::_('YENDIF_VIDEO_SHARE_SELECT_CATEGORY'); ?><span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<?php echo YendifVideoShareFields::ListCategories('catid', $this->catids, $this->item->catid, 'class="required validate-list"'); ?>
            	</div>
        	</div>
            
            <div class="control-group">
            	<label class="control-label" for="type"><?php echo JText::_('YENDIF_VIDEO_SHARE_TYPE'); ?></label>
                <div class="controls yendif-media-types">
                	<?php
						$types = array( 'video' => JText::_('YENDIF_VIDEO_SHARE_GENERAL_VIDEO') );
						if( $this->config->allow_youtube_upload ) $types['youtube'] = JText::_('YENDIF_VIDEO_SHARE_YOUTUBE');
						if( $this->config->allow_rtmp_upload ) $types['rtmp'] = JText::_('YENDIF_VIDEO_SHARE_RTMP');
						
                    	echo YendifVideoShareFields::MediaTypes( 'type', $types, $this->item->type );
					?>
            	</div>
        	</div>
            
            <div class="control-group yendif-media-fields yendif-type-video">
            	<label class="control-label" for="mp4">MP4 | M4V | FLV<span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<?php echo YendifVideoShareFields::FileUploader('mp4', $this->item->mp4, $this->config->allow_upload); ?>
                    <a id="yendif-more-formats" class="btn btn-link">
						<span id="yendif-more-text">[+] <?php echo JText::_('YENDIF_VIDEO_SHARE_MORE_OPTIONS'); ?></span>
                    	<span id="yendif-less-text" class="hide">[-] <?php echo JText::_('YENDIF_VIDEO_SHARE_LESS_OPTIONS'); ?></span>
                    </a>
                </div>
        	</div>
            
            <div id="yendif-more-formats-container" class="hide">
            	<div class="control-group yendif-media-fields yendif-type-video">
                	<label class="control-label" for="webm">WEBM <?php echo JText::_('YENDIF_VIDEO_SHARE_OPTIONAL'); ?></label>
                	<div class="controls">
                		<?php echo YendifVideoShareFields::FileUploader('webm', $this->item->webm, $this->config->allow_upload); ?>
                	</div>
                </div>
                    
                <div class="control-group yendif-media-fields yendif-type-video">
                	<label class="control-label" for="ogg">OGG <?php echo JText::_('YENDIF_VIDEO_SHARE_OPTIONAL'); ?></label>
                	<div class="controls">
                		<?php echo YendifVideoShareFields::FileUploader('ogg', $this->item->ogg, $this->config->allow_upload); ?>
                	</div>
                </div>
        	</div>
            
            <div class="control-group yendif-media-fields yendif-type-youtube">
            	<label class="control-label" for="youtube"><?php echo JText::_('YENDIF_VIDEO_SHARE_YOUTUBE_URL'); ?><span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<input type="text" name="youtube" id="youtube" class="yendif-media-required" value="<?php echo $this->item->youtube; ?>" />
                </div>
        	</div>
            
            <div class="control-group yendif-media-fields yendif-type-rtmp">
            	<label class="control-label" for="rtmp"><?php echo JText::_('YENDIF_VIDEO_SHARE_RTMP_SERVER'); ?><span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<input type="text" name="rtmp" id="rtmp" class="yendif-media-required" value="<?php echo $this->item->rtmp; ?>" />
                </div>
        	</div>
            
            <div class="control-group yendif-media-fields yendif-type-rtmp">
            	<label class="control-label" for="flash"><?php echo JText::_('YENDIF_VIDEO_SHARE_STREAM_NAME'); ?><span class="star">&nbsp;*</span></label>
                <div class="controls">
                	<input type="text" name="flash" id="flash" class="yendif-media-required" value="<?php echo $this->item->flash; ?>" />
                </div>
        	</div>
            
            <div class="control-group yendif-media-fields yendif-type-rtmp">
            	<label class="control-label" for="mobile">
					<?php echo JText::_('YENDIF_VIDEO_SHARE_MOBILE_FALLBACK').' '.JText::_('YENDIF_VIDEO_SHARE_OPTIONAL'); ?>
                </label>
                <div class="controls">
                	<?php echo YendifVideoShareFields::FileUploader('mobile', $this->item->mp4); ?>
                </div>
        	</div>
            
            <div class="control-group">
            	<label class="control-label" for="image"><?php echo JText::_('YENDIF_VIDEO_SHARE_IMAGE'); ?></label>
                <div class="controls">
                	<?php echo YendifVideoShareFields::FileUploader('image', $this->item->image, $this->config->allow_upload); ?>
                </div>
        	</div>
            
            <?php if( $this->config->allow_subtitle ) :  ?>
            	<div class="control-group yendif-media-fields yendif-type-video yendif-type-youtube yendif-type-rtmp">
            		<label class="control-label" for="captions">
						<?php echo JText::_('YENDIF_VIDEO_SHARE_SUBTITLE').' '.JText::_('YENDIF_VIDEO_SHARE_OPTIONAL'); ?>
                	</label>
               		<div class="controls">
                		<?php echo YendifVideoShareFields::FileUploader('captions', $this->item->captions, $this->config->allow_upload); ?>
               		</div>
        		</div>
            <?php endif; ?>
            
            <div class="control-group">
            	<label class="control-label" for="duration">
					<?php echo JText::_('YENDIF_VIDEO_SHARE_DURATION').' '.JText::_('YENDIF_VIDEO_SHARE_OPTIONAL'); ?>
                </label>
               	<div class="controls">
                	<input type="text" name="duration" id="duration" class="input-mini center" placeholder="00:00" value="<?php echo $this->item->duration; ?>" />
       				<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_DURATION_DESCRIPTION'); ?></span>
               	</div>
        	</div>

			<div class="control-group">
            	<label class="control-label" for="description"><?php echo JText::_('YENDIF_VIDEO_SHARE_DESCRIPTION'); ?></label>
               	<div class="controls">
           			<?php echo JFactory::getEditor()->display('description', $this->item->description, '100%', '400', '20', '20'); ?>
                </div>
            </div>
            
            <?php if( $this->config->schedule_video_publishing ) : ?>
            	<div class="control-group">
            		<label class="control-label" for="published_up"><?php echo JText::_('YENDIF_VIDEO_SHARE_START_PUBLISHING'); ?></label>
                	<div class="controls">
                		<?php echo JHTML::calendar($this->item->published_up, 'published_up', 'published_up', "%Y-%m-%d %H:%M:%S", ''); ?>
                    	<p class="help-block"><?php echo JText::_('YENDIF_VIDEO_SHARE_START_PUBLISHING_DESC'); ?></p>
                	</div>
            	</div>
                    
            	<div class="control-group">
            		<label class="control-label" for="published_down"><?php echo JText::_('YENDIF_VIDEO_SHARE_FINISH_PUBLISHING'); ?></label>
            		<div class="controls">
            			<?php echo JHTML::calendar($this->item->published_down, 'published_down', 'published_down', "%Y-%m-%d %H:%M:%S", ''); ?>
                    	<p class="help-block"><?php echo JText::_('YENDIF_VIDEO_SHARE_FINISH_PUBLISHING_DESC'); ?></p>
            		</div>
            	</div>
            <?php endif; ?>
            
            <div class="control-group">
            	<label class="control-label" for="meta_keywords"><?php echo JText::_('YENDIF_VIDEO_SHARE_META_KEYWORDS'); ?></label>
                <div class="controls">
                	<textarea name="meta_keywords" id="meta_keywords" placeholder="<?php echo JText::_('YENDIF_VIDEO_SHARE_META_KEYWORDS_DESCRIPTION'); ?>"><?php echo $this->item->meta_keywords; ?></textarea>
                </div>
            </div>
                    
            <div class="control-group">
            	<label class="control-label" for="meta_description"><?php echo JText::_('YENDIF_VIDEO_SHARE_META_DESCRIPTION'); ?></label>
            	<div class="controls">
               		<textarea name="meta_description" id="meta_description"><?php echo $this->item->meta_description; ?></textarea>
            	</div>
            </div>
        </div>
        
        <div class="form-actions text-center muted">
      		<button type="submit" class="btn btn-primary validate"><?php echo JText::_('YENDIF_VIDEO_SHARE_UPDATE'); ?></button>
      		<a class="btn" href="<?php echo JRoute::_( 'index.php?option=com_yendifvideoshare&view=user'.$itemId ); ?>"><?php echo JText::_('YENDIF_VIDEO_SHARE_CANCEL'); ?></a>
    	</div>
    
    	<input type="hidden" name="option" value="com_yendifvideoshare" />
    	<input type="hidden" name="view" value="user" />
    	<input type="hidden" name="task" value="save" /> 
        <input type="hidden" name="id" id="yendif-insert-id" value="<?php echo $this->item->id; ?>"> 
        <input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>   
    </form>
</div>

<div id="yendif-media-uploader" class="hide"></div>