<?php

/*
 * @version		$Id: view.html.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class YendifVideoShareViewCategory extends YendifVideoShareView {

	function display( $tpl = null ) {	
		jimport( 'joomla.application.pathway' );
		
		$app = JFactory::getApplication();	
		$db = JFactory::getDBO();
		$document = JFactory::getDocument();		
			
		$document->editor = $app->getCfg('fromname');
		$document->editorEmail = $app->getCfg('mailfrom');	
		
		$model = $this->getModel();
		
		$config = YendifVideoShareUtils::getConfig();	
		$params = $app->getParams();
		
		$items = $model->getVideos( $config->feed_limit, $params->get('filterby', 'none'), $params->get('orderby'), $config->schedule_video_publishing );	
		
		foreach( $items as $item ){
			$title = $this->escape( $item->title );
			$title = html_entity_decode( $title, ENT_COMPAT, 'UTF-8' );
			
			$itemId = JRequest::getInt('Itemid')  ? '&Itemid=' . JRequest::getInt('Itemid') : '';
			$target_url = JRoute::_( "index.php?option=com_yendifvideoshare&view=video&id=".$item->id.':'.$item->alias.$itemId );	
			
			$description  = $item->description;				
			$description .= '<img src="'.$item->image.'" />';
			
			$date = $item->created_date ? date( 'r', strtotime( $item->created_date ) ) : '';
							
			// load individual item creator class
			$feeditem = new JFeedItem();
			
			$feeditem->title	   = $title;
			$feeditem->link		   = $link;				
			$feeditem->description = $description;
			$feeditem->date		   = $date;
			$feeditem->category	   = $item->category;								
			
			// loads item info into rss array
			$document->addItem( $feeditem );
		}
    }
	
}