<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Statistik");
DEFINE('_EW_MENU_GOALS', "Mål");
DEFINE('_EW_MENU_SETTINGS', "Inställningar");
DEFINE('_EW_MENU_CREDITS', "Erkännande");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Dokumentation");
DEFINE('_EW_MENU_LICENSE', "Reklamfri Licens");
DEFINE('_EW_MENU_DONATORS', "Donatorer");
DEFINE('_EW_MENU_SUPPORT', "Support ExtraWatch för att få bort reklamen i backend.");

// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Senaste Besökare");
DEFINE('_EW_VISITS_BOTS', "Bottar");
DEFINE('_EW_VISITS_CAME_FROM', "Kom från");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Din ExtraWatch modul är inte publicerad! Ingen statistik kommer att registreras. Publicera modulen på alla sidor.");
DEFINE('_EW_VISITS_PANE_LOADING', "Laddar besökare...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Besökstatistiken för vecka");
DEFINE('_EW_STATS_WEEK', "Vecka");
DEFINE('_EW_STATS_THIS_WEEK', "denna vecka");
DEFINE('_EW_STATS_UNIQUE', "unika");
DEFINE('_EW_STATS_LOADS', "laddningar");
DEFINE('_EW_STATS_HITS', "träffar");
DEFINE('_EW_STATS_TODAY', "idag");
DEFINE('_EW_STATS_FOR', "för");
DEFINE('_EW_STATS_ALL_TIME', "Alltid");
DEFINE('_EW_STATS_EXPAND', "expandera");
DEFINE('_EW_STATS_COLLAPSE', "kollapsa");
DEFINE('_EW_STATS_URI', "Sidor");
DEFINE('_EW_STATS_COUNTRY', "Länder");
DEFINE('_EW_STATS_USERS', "Användare");
DEFINE('_EW_STATS_REFERERS', "Refererar");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "Webbläsare");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "Nyckelord");
DEFINE('_EW_STATS_GOALS', "Mål");
DEFINE('_EW_STATS_TOTAL', "Totalt");
DEFINE('_EW_STATS_DAILY', "Dagligen");
DEFINE('_EW_STATS_DAILY_TITLE', "Daglig statistik");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Statistik totalt");
DEFINE('_EW_STATS_LOADING', "laddar...");
DEFINE('_EW_STATS_LOADING_WAIT', "laddar... vänligen vänta");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "Blockerat IP");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Välj IP manuellt");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Skriv in IP-nummer som du vill blockera. (eg. 217.242.11.54 or 217.* or 217.242.* för att blockera alla IP som matchar wildcard)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Riktig toggle blockering av ");
DEFINE('_EW_STATS_PANE_LOADING', "Laddar statistik...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Inställningar");
DEFINE('_EW_SETTINGS_DEFAULT', "Default");
DEFINE('_EW_SETTINGS_SAVE', "Spara");
DEFINE('_EW_SETTINGS_APPEARANCE', "Utseende");
DEFINE('_EW_SETTINGS_FRONTEND', "Frontend");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Historik &amp; Presentation");
DEFINE('_EW_SETTINGS_ADVANCED', "Avancerad");
DEFINE('_EW_SETTINGS_IGNORE', "Ignorera");
DEFINE('_EW_SETTINGS_BLOCKING', "Blockera");
DEFINE('_EW_SETTINGS_EXPERT', "Expert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Vill du verkligen återställa all statistik och besöksdata?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Återställ allt");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Återställ all statistik &amp; besöks data");
DEFINE('_EW_SETTINGS_LANGUAGE', "Språk");
DEFINE('_EW_SETTINGS_SAVED', "Inställningarna sparades");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Lägg till ditt IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "till listan.");

// Other / mostly general.
DEFINE('_EW_TITLE', "En real-tid AJAX Joomla övervakare");
DEFINE('_EW_BACK', "Tillbaka");
DEFINE('_EW_ACCESS_DENIED', "Du har inga privillegier för att se detta!");
DEFINE('_EW_LICENSE_AGREE', "Jag godkänner licensens &amp; villkor ovan");
DEFINE('_EW_LICENSE_CONTINUE', "Fortsätta");
DEFINE('_EW_SUCCESS', "Operationen lyckades");
DEFINE('_EW_RESET_SUCCESS', "All statistik och besöksdata raderades");
DEFINE('_EW_RESET_ERROR', "Datan raderades INTE, någonting gick fel");
DEFINE('_EW_CREDITS_TITLE', "Erkännande");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Daglig och veckovis statistik av");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX rättighetern nekades: Vänligen se statistiken från din domän specifierad i configuration.php i din Joomla installation - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Kanske glömde du www. framför ditt domännamn. Ditt javascript försööker få access ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "från");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "varför försöker den tro att det är en annan domän.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Få den senaste koden för tillägg från");
DEFINE('_EW_HEADER_CAST_YOUR', "Ge din");
DEFINE('_EW_HEADER_VOTE', "Röst");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Klicka för att visa tooltip");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Hovra musen över tooltip");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "gårdagens&apos;s ökar");
DEFINE('_EW_TOOLTIP_HELP', "Öppnar extern online hjälp för");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Stäng detta fönster");
DEFINE('_EW_TOOLTIP_PRINT', "SKriv ut");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Lägg till ett nytt mål");
DEFINE('_EW_GOALS_UPDATE', "Updatera ett målsnummer.");
DEFINE('_EW_GOALS_ACTION', "Aktivitet");
DEFINE('_EW_GOALS_TITLE', "Nytt mål");
DEFINE('_EW_GOALS_NEW', "Nytt mål");
DEFINE('_EW_GOALS_RELOAD', "Uppdatera");
DEFINE('_EW_GOALS_ADVANCED', "Avancerad");
DEFINE('_EW_GOALS_NAME', "Namn");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "URI tillstånd");
DEFINE('_EW_GOALS_GET_VAR', "FÅ var");
DEFINE('_EW_GOALS_GET_CONDITION', "Få tillstånd");
DEFINE('_EW_GOALS_POST_VAR', "POSTA Var");
DEFINE('_EW_GOALS_POST_CONDITION', "POSTA Tillstånd");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Titel tillstånd");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Användarnamn tillstånd");
DEFINE('_EW_GOALS_IP_CONDITION', "IP Tillstånd");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Kom från tillstånd");
DEFINE('_EW_GOALS_BLOCK', "Blockera");
DEFINE('_EW_GOALS_REDIRECT', "Omdirigera till URL");
DEFINE('_EW_GOALS_HITS', "Träffar");
DEFINE('_EW_GOALS_ENABLED', "Tillåt");
DEFINE('_EW_GOALS_EDIT', "Ändra");
DEFINE('_EW_GOALS_DELETE', "Radera");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Du kommer förlora den senaste statistiken för detta mål. Villd u verkligen radera mål nr.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Länder");
DEFINE('_EW_FRONTEND_VISITORS', "Besökare");
DEFINE('_EW_FRONTEND_TODAY', "Idag");
DEFINE('_EW_FRONTEND_YESTERDAY', "Igår");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Denna vecka");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Senaste veckan");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Denna månad");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Senaste månad");
DEFINE('_EW_FRONTEND_TOTAL', "Totalt");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch är i debug mode. På detta sätt kan du upptäcka fel. För att ändra, vänligen ändra värdet EXTRAWATCH_DEBUG in /components/com_extrawatch/config.php från 1 till 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Max rader som visas när statistiken är i expanderbart läge.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Alla IP addresser som har färre träffar än detta värde kommer raderas från IP-historiken.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Alla URLs som har färre träffar än detta värde kommer raderas från IP-historiken.");
DEFINE('_EW_DESC_IGNORE_IP', "Exkludera specifikt IP från statistiken. Separera med ny rad. Du kan välja wildcards här. <br/>Eg. 192.* will ignore 192.168.51.31, 192.168.16.2, etc..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Besökarstatistik uppdateras i tid (milisekunder), default är 2000, var försiktig med detta. Uppdatera sedan ExtraWatch i back-end.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Besökarstatistik uppdateras i tid (milisekunder), default är 4000, var försiktig med detta. Uppdatera sedan ExtraWatch i back-end..");
DEFINE('_EW_DESC_MAXID_BOTS', "Hur många bottarbesök som lagras i databasen.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Hur många besökare som lagras i databasen.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Hur många bottar som du vill se i back-end.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Hur många besökare som du vill se i back-end.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Maximalt antal tecken som visas i långa titlar och uris.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Maximalt antal tecken som visas i den högra statistikspanelen.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Dagar som statistiken lagras i databasen, 0 = oändligt.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "När du är i en annan tidszon än din hostserver. (positivt eller negativt värde i timmar)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Inställning vecka, inställningen/(3600*24*7) ger veckonummer från 1.1.1970, denna inställning är en rättning för att få veckan att starta med en måndag ");
DEFINE('_EW_DESC_DAY_OFFSET', "Inställning dag, inställningen/(3600*24) ger dagnummmer från 1.1.1970, denna inställning är en rättning för att få start från 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "För att använda en tom 1x1px icon i front-end");
DEFINE('_EW_DESC_IP_STATS', "För att tillåta statstik för IP-adresser. I vissa länder är det förbjudet att lagra IP-adresser i en databas. Använd på egen risk.");
DEFINE('_EW_DESC_HIDE_ADS', "Denna inställning gömmer reklamen i backend, om den verkligen stör dig. Om du har kvar den, hjälper du oss att forsätta utvecklingen av denna komponent. Tack");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Uncheck, om du vill visa tooltip med att 'hovra', iställer för att klicka.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Default är 'REDIRECT_URL', vilket är standard om du använder url rewriting, kan ändras till 'SCRIPT_URL' om den bara loggar index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Meddelandet som visas för användare som är blockerade på sidan.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Tooltip bredd");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Tooltip höjd");
DEFINE('_EW_DESC_TOOLTIP_URL', "Du kan lägga till länk här, för att visa besökarnas IP. {ip} kommer visa besökarens IP. Eg. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Du kan skriva in URI som du inte vill ta med i statistiken. Du kan använda wildcards (* and ?) här. Eg.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Specifiera namnet på målet här. Detta namn kommer att visas i statistiken.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Allt som är efter ditt domännamn. För http://www.codegravity.com/projects/ URI är: /projects/ (Example to use: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET variabeln är en variabel som du kanse URL vanligtvis efter a ? or &amp; sign. Eg. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Du kan också se <u>*</u> i detta fält för scanna alla värden. (Example to use: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Här måste du specifiera en match för värdet från förra fältet. (Example to use: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Liknande, men kontrollerar värdet från skickades formulär. Så när du har formulär på din sida, så har detta ett fält &lt;input type='text' name='<u>experiences</u>' /&gt;. (Exempel för att använda: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "En matchning från värdet från detta POST fält. Eg. vi vill se om användaren har erfarenhet av java. (Example to use: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "En titel på en sida som måste matchas. (Exempel för att använda: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Ett namn för inloggade användare. (Exempel för att använda: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP som användaren kommer från: (Exempel för att använda: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "En URL som besökaren kommer från. (Exempel för att använda: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "Användaren är redirected till en URL specifierad av dig. Har en högre prioritet än 'blocking': (Exempel för att använda: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Hur många tecken som kapas av i måltabellen");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "Tillbaka länk till codegravity.com, du kan frångå, men vi uppskattar om du behåller länken. Tack");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Visar länders totalstatistik i modulen i frontend. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Om du vill ändra ordningen för Besökare/Länder i frontend. Uncheck , och Besökare kommer visas först.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Antal länder som visas i frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Visa länders besökare i modulen i frontend. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Tid i sekunder för cache Totalt länder i frontend");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Tid i sekunder för cache Totalt besökare i frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "För att visa besökare i frontend för: idag. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "För att visa besökare i för: igår. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "För att visa besökare i frontend för: denna vecka. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "För att visa besökare i frontend för: senaste veckan. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "För att visa besökare i frontend för: denna månad. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "För att visa besökaren i frontend för: senaste månad. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "För att visa totalt antal besökare sedan installationen av ExtraWatch. Om ändrat, denna inställning kommer att fungera först efter tiden är satt i CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Språkfil som ska användas. De placeras i /components/com_extrawatch/lang/. Om du vill skapa en ny språkfil, besök först extraWatchs hemsida, och om du inte finner den språkfil du söker, kopiera bara default english.php till eg. german.php och placera den i mappen /lang. Sedan, översätt värdena till höger.");
DEFINE('_EW_DESC_GOALS', "Mål tillåter dig specifiera speciella parameterar. När dessa paramterar matchas, ökar måltalet. På detta sätt kan du övervaka om användarna har besökt en specifik URL, postat ett specifikt värde, har ett specifikt användarnamn eller kom från en specifik adress. Du kan också blockera eller redirect sådana användare till en viss URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "I alla fält, förutom namn, kan du använda * och ? som wildcards. Exempel för att använda: ?ear (will match: near, tear, ..),  p*r (will match: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Sätt till 1, om du vill blockera besökaren. Besökaren kommer inte se resten av innehållet, bara meddelandet om att han var blockerad - utan någon redirect och hans IP läggs till 'blockerad' statistiken (Exempel för att använda: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Länder villkor");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2-tecken kod för länder med stora tecken (Eg: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "Inkommande");
DEFINE('_EW_STATS_FROM', "Från");
DEFINE('_EW_STATS_TO', "Till");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Lägg till i Mål");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Lägg till Mål för detta land");
DEFINE('_EW_MENU_REPORT_BUG', "Rapportera bugg eller fel");
DEFINE('_EW_GOALS_COUNTRY', "Land");

/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Om du vill se ländernas namn med versaler i frontend (Eg: TYSKLAND, StorBritannien istället för Tyskland, Storbritannien)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Tid i sekunder för cache att fånga upp användare i frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Ursprungsvärde för Totalt: i frontend. Detta är användningsbart om du exempelvis migrerar från ett annat statistikverktyg. (Eg.:20000). Välj 0 om du inte vill använda denna funktion.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignorera användare i denna lista. En för varje rad. (Eg.: mig själv {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Mest aktiva användare för idag från Totalt");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Aktivera blockerade användare baserat på orden i Spam-ordslistan ?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Vanligaste spam-orden från spam bottar.Du kan använda wildcards, (Eg.: ph?rmac*). Om inställningarna ovan är aktiverade kommer ExtraWatch kontrollera om attackerna skickade ett formulär innehållande dessa ord (HTTP POST förfrågan). (Detta är tillämpningsbart när processerna använder Joomla - forum, kommentarer, men alla attacker kan undvikas för alla försök att skicka formulär via spam bottar)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "En länk i användarmodulen i frontend - möjliggör att specifiera en 'klickbar URL' via användarnamnet. Stringen måste bestå av {user}, vilken kommer ersättas av användarnamnet. (Eg. index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Nyckelfraser");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Max värden i historik fliken (Exampel: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "I besök, visa senaste besök, inte alla");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "I besök, dölj upprepade sidnamn ibesökt sidrubriker");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Max antal besökare som ska lagrad i databasen för Besökshistorik. Var försiktig, denna inställning, om du har mycket trafik, denna data kan växa snabbt. Kontrollera alltid hur mycket data historik tabellen innehåller i Status");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Spara databas tabeller vid avinstallarion. Välj detta alternativ innan avinstallation om du vill uppgradera och spara din data.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Du kommer få e-postrapporter under natten, som du kan läsa på morgonen");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "E-postadressen där du kommer att ta emot dessa rapporter");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Inkludera endast rader i e-postrapporter där procent är högre än {value}. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Inkludera endast <b>positiv en dag</b> ändra värden i e-postrapporter högre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Inkludera endast <b>negativ en dag</b> ändra värden i e-postrapporter lägre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Inkludera endast <b>positiv sju dagar</b> ändra värden i e-postrapporter högre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Inkludera endast <b>negativv sju dagar</b> ändra värden i e-postrapporter lägre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Inkludera endast <b>positiv trettio dagar</b> ändra värden i e-postrapporter högre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Inkludera endast <b>negativ trettio dagar</b> ändra värden i e-postrapporter lägre än {value} procent. Sätt till 0 om du inte vill använda denna funktion <i>(exempel: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(för PRO version)</b> Aktivera denna inställningar om du vill använda logon med attributet rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Max antal tecken för namn i e-post rad. Ändra detta om ditt e-postklient fönster är för liten");

DEFINE('_EW_MENU_HISTORY', "Historik");
DEFINE('_EW_MENU_EMAILS', "E-post");
DEFINE('_EW_MENU_STATUS', "Status");
DEFINE('_EW_DESC_BLOCKED', "Dessa IPn blockerade med anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Historik besökare");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Visa endast %d senaste poster.
                för att ändra detta värde, gå till Inställningar -&gt; Historik &amp; Prestanda -&gt; HISTORY_MAX_DB_RECORDS . Var försiktig, denna inställning påverkar laddningstider av nedanstående data.  ");
DEFINE('_EW_MENU_BUG', "Rapportera bug");
DEFINE('_EW_MENU_FEATURE', "Efterfråga funktion");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Nyckelord");

DEFINE('_EW_BLOCKING_UNBLOCK', "avblockera");
DEFINE('_EW_STATS_KEYPHRASE ', "Nyckelfras");
DEFINE('_EW_STATUS_DATABASE', "Databas status");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "tabellnamn");
DEFINE('_EW_STATUS_DATABASE_ROWS', "rader");
DEFINE('_EW_STATUS_DATABASE_DATA', "data");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "totalt");

DEFINE('_EW_EMAIL_REPORTS', "E-postrapporter");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Genererade filtrerade e-postrapporter från igår");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Filter e-postvärde");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "värde");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "procent");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "1-dags förändring");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "7-dags förändring");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "28-dagars förändring");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch har blockerat %d spammare idag, totalt: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Blockerade IP-adresser");
DEFINE('_EW_ANTISPAM_SETTINGS', "Anti-Spam inställningar");
DEFINE('_EW_TRAFFIC_AJAX', "Trafik AJAX uppdateringar");


DEFINE('_EW_HISTORY_PREVIOUS', "föregående");
DEFINE('_EW_HISTORY_NEXT', "nästa");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Antal kolumner av länder");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Antal rader av länder");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Visa eller visa inte namn på länder");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Visa flaggor först, sedan procent");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "GET inverterat villkor");
DEFINE('_EW_GOALS_POST_INVERSED', "POST inverterat villkor");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Rubrik inverterat villkor");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Användarnamn inverterat villkor");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Kom från inverterat villkor");

DEFINE('_EW_STATS_MAP', "Karta senaste besök");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Ange <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> nyckel för att visa karta över senaste besök:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "store key");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Ange giltig ipinfodb key som du fick från: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "Felaktig begäran: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Fält för inlämningar via formulär:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URL parametrar:");
DEFINE('_EW_VISIT_ADD_PAGE', " Lägg till sidan som mål");
DEFINE('_EW_VISIT_BLOCK_IP', " Blockera denna IP-adress");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Lägg till detta inlämnade formulär variabel som ett mål");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Lägg till denna URL parameter som ett mål");

DEFINE('_EW_TREND_EMPTY', "Tom");

DEFINE('_EW_NOT_NUMBER', " VARNING: Värdet du angav är inte ett nummer. ExtraWatch kommer inte fungera på rätt sätt!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Detta är ett 15-dagars utvärderingsversion. Dagar kvar: <b>%d</b>. Köpa gärna livstid <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch licensen för din domän</a> för denna och framtida versioner.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Din testversion har gått ut. Vänligen köp ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Licensen aktiverades. Tack");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>FEL: licensnyckeln och din domän stämmer inte.</b><br/>Har du angett samma domännamn i aktivering formuläret som du ser nedan? Kontakta: info@codegravity.com");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Om du ser meddelandet ovan för länge, kanske den aktiva webbplatsen är fel.
                    Öppna components/com_extrawatch/config.php
                    av-kommentera, och sätt din aktuella live site. Eg.:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Varning: site i din webbläsare och live site i konfiguration: %s och %s matchar inte.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Sätt live site till: %s och fortsätt...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Ta bort tillbaka länk");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Kunskapsbas");
DEFINE('_EW_ADMINHEADER_FLOW', "Flöde");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Graf");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Komponenter");
DEFINE('_EW_ADMINHEADER_REVIEW', "Omdöme");
DEFINE('_EW_ADMINHEADER_WRITE', "Skriv ");

DEFINE('_EW_FLOW_TRAFFIC', "Traffikflöde");
DEFINE('_EW_FLOW_SELECT_PAGE', "Välj sida:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Root antal utgående länkar:");
DEFINE('_EW_FLOW_NESTING', "Nästlad nivå:");
DEFINE('_EW_FLOW_SCALE', "Skala:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Reklam-fri version");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Tack för donation!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Din registreringsnyckel för din domän %s är: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Nu kan du dölja tillbaka länkar eller gömma ExtraWatch logo i front-end i Inställningar ");


DEFINE('_EW_SIZES_LAST_CHECK', "Senaste kontroll genomfördes den:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Storlek på komponent/modul i /administrator katalogen");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Komponent");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Totalt:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Storlek");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Uppdatera alla");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabell");
DEFINE('_EW_SIZEDATABASE_SIZE', "Storlek");
DEFINE('_EW_SIZEDATABASE_1DAY', "1-dags förändring");
DEFINE('_EW_SIZEDATABASE_7DAY', "7-dagars förändring");
DEFINE('_EW_SIZEDATABASE_28DAY', "28-dagars förändring");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "ingen data");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Totalt:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Uppdatera alla");
DEFINE('_EW_SIZEMODULES_TOTAL', "Totalt:");
DEFINE('_EW_SIZEMODULES_MODULE', "Modul");
DEFINE('_EW_SIZEMODULES_SIZE', "Storlek");

DEFINE('_EW_SIZES_FILES', "File &amp; Kataloger");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Uppdatera");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");

DEFINE('_EW_DESC_IPINFODB_KEY', "Karta senaste besök ipinfodb.com key från: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Tvinga tidszon Förskjutning");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Uppdatera");
DEFINE('_EW_MENU_UPDATE_TITLE', "Backup & Uppgradera");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Inte möjligt i gratis versionen, se licens fliken");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Spam ord ban aktivera");
DEFINE('_EW_SPAMWORD_LIST', "Spam ord lista");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Dölj upprepade rubriker");
DEFINE('_EW_TRUNCATE_VISITS', "Förkorta besök");
DEFINE('_EW_TRUNCATE_STATS', "Förkorta statistik");
DEFINE('_EW_TRUNCATE_GOALS', "Förkorta mål");
DEFINE('_EW_LIMIT_BOTS', "Gräns bottar");
DEFINE('_EW_LIMIT_VISITORS', "Gräns besökare");
DEFINE('_EW_TOOLTIP_WIDTH', "Tooltip bredd");
DEFINE('_EW_TOOLTIP_HEIGHT', "Tooltip höjd");
DEFINE('_EW_TOOLTIP_URL', "Tooltip URL");
DEFINE('_EW_TOOLTIP_ONCLICK', "Tooltip OnClick");
DEFINE('_EW_IP_STATS', "IP statistik");
DEFINE('_EW_IPINFODB_KEY', "IP Info DB nyckel ");
DEFINE('_EW_ONLY_LAST_URI', "Endast senaste URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Front-end dölj logo ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "Front-end No Follow");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Front-end inga tillbaka länkar");
DEFINE('_EW_FRONTEND_USER_LINK', "Front användare länkar");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Front-end länder först");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Front-end landsnamn");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Front-end länder versaler");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Front-end landsflaggor först ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Front-end länder num");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Front-end länder max kolumner");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Front-end länder max rader");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Besökare i front-end idag ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Besökare i front-end igår ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Besökare i front-end denna vecka ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Besökare i front-end senaste veckan ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Besökare i front-end denna månad ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Besökare i front-end senaste månaden");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Göm totalt antal besökare i front-end");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Total inledande front-end");
DEFINE('_EW_HISTORY_MAX_VALUES', "Historik max värden");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Historik max poster");
DEFINE('_EW_UPDATE_TIME_VISITS', "Uppdatera tid för besök");
DEFINE('_EW_UPDATE_TIME_STATS', "Uppdatera tid för statistik");
DEFINE('_EW_STATS_MAX_ROWS', "Statistik max rader");
DEFINE('_EW_STATS_IP_HITS', "Statistik IP träffar");
DEFINE('_EW_MAXID_BOTS', "Max ID bottar");
DEFINE('_EW_MAXID_VISITORS', "Maxid besökare");
DEFINE('_EW_STATS_KEEP_DAYS', "Statistik spara dagar ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Cache front-end länder ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Cache front-end besökare ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Avinstallera spara data ");
DEFINE('_EW_IGNORE_IP', "Ignorera IP");
DEFINE('_EW_IGNORE_URI', "Ignorera URI");
DEFINE('_EW_IGNORE_USER', "Ignorera användare");
DEFINE('_EW_BLOCKING_MESSAGE', "Meddelande vid blockering");
DEFINE('_EW_SERVER_URI_KEY', "Server URI nyckel");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Total inledande besökare front-end");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Poster");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " För att använda blockering på ett effektivt sätt, måste du publicera ExtraWatch agent INNAN innehåll och formulär. Eg. på vänster sida i din mall.
                    <br/>
                    Gå till Tillägg moduler -> ExtraWatch agent -> välj position vänster");
DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO Rapporter");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO Nightly e-postrapporter aktiverat");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Visa installation demo");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
