<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Estadísticas");
DEFINE('_EW_MENU_GOALS', "Metas");
DEFINE('_EW_MENU_SETTINGS', "Configuración");
DEFINE('_EW_MENU_CREDITS', "Créditos");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Documentación");
DEFINE('_EW_MENU_LICENSE', "Licencia Ad-free");
DEFINE('_EW_MENU_DONATORS', "Donantes");
DEFINE('_EW_MENU_SUPPORT', "Apoye ExtraWatch y olvídese de los avisos publicitarios en la consola de administración.");

// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Últimos visitantes");
DEFINE('_EW_VISITS_BOTS', "Bots");
DEFINE('_EW_VISITS_CAME_FROM', "Viene de");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Su módulo ExtraWatch no está publicado! Las estadísticas no se están capturando. Para publicarlos, vaya a la sección de Módulos y publíquelo en todas las páginas de su sitio.");
DEFINE('_EW_VISITS_PANE_LOADING', "Cargando visitas...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Estadísticas de visitas por semana");
DEFINE('_EW_STATS_WEEK', "Semana");
DEFINE('_EW_STATS_THIS_WEEK', "esta semana");
DEFINE('_EW_STATS_UNIQUE', "única");
DEFINE('_EW_STATS_LOADS', "cargas");
DEFINE('_EW_STATS_HITS', "hits");
DEFINE('_EW_STATS_TODAY', "hoy");
DEFINE('_EW_STATS_FOR', "para");
DEFINE('_EW_STATS_ALL_TIME', "Tiempo-completo");
DEFINE('_EW_STATS_EXPAND', "expandir");
DEFINE('_EW_STATS_COLLAPSE', "contraer");
DEFINE('_EW_STATS_URI', "Páginas");
DEFINE('_EW_STATS_COUNTRY', "Países");
DEFINE('_EW_STATS_USERS', "Usuarios");
DEFINE('_EW_STATS_REFERERS', "Referencias");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "Navegadores");
DEFINE('_EW_STATS_OS', "SO");
DEFINE('_EW_STATS_KEYWORDS', "Palabras clave");
DEFINE('_EW_STATS_GOALS', "Metas");
DEFINE('_EW_STATS_TOTAL', "Total");
DEFINE('_EW_STATS_DAILY', "Diario");
DEFINE('_EW_STATS_DAILY_TITLE', "Estadísticas diarias");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Estadísticas a tiempo-completo");
DEFINE('_EW_STATS_LOADING', "cargando...");
DEFINE('_EW_STATS_LOADING_WAIT', "cargando... por favor espere");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "Bloqueo IP");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Ingrese IP manualmente");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Ingrese una dirección IP que desee bloquear. (ej. 217.242.11.54 or 217.* or 217.242.* para bloquear todas las IPs que correspondan con el comodín)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Realmente desea alternar el bloqueo para ");
DEFINE('_EW_STATS_PANE_LOADING', "cargando estadísticas...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Configuraciones");
DEFINE('_EW_SETTINGS_DEFAULT', "Por defecto");
DEFINE('_EW_SETTINGS_SAVE', "Guardar");
DEFINE('_EW_SETTINGS_APPEARANCE', "Apariencia");
DEFINE('_EW_SETTINGS_FRONTEND', "Fachada");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Historial &amp; Desempeño");
DEFINE('_EW_SETTINGS_ADVANCED', "Avanzado");
DEFINE('_EW_SETTINGS_IGNORE', "Ignorar");
DEFINE('_EW_SETTINGS_BLOCKING', "Bloquear");
DEFINE('_EW_SETTINGS_EXPERT', "Experto");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Realmente desea limpiar todas las estadísticas y datos de visitantes?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Limpiar todo");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Limpiar todas las estadísticas y datos de visitantes");
DEFINE('_EW_SETTINGS_LANGUAGE', "Idioma");
DEFINE('_EW_SETTINGS_SAVED', "Las configuraciones fueron guardadas");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Añada su IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "a la lista.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Un monitor AJAX para joomla en tiempo real");
DEFINE('_EW_BACK', "Atrás");
DEFINE('_EW_ACCESS_DENIED', "No tiene permisos para ver esto !");
DEFINE('_EW_LICENSE_AGREE', "Acepto los términos &amp; condiciones de arriba");
DEFINE('_EW_LICENSE_CONTINUE', "Continuar");
DEFINE('_EW_SUCCESS', "Operación exitosa");
DEFINE('_EW_RESET_SUCCESS', "Todas las estadísticas y datos de visitantes han sido eliminados exitosamente");
DEFINE('_EW_RESET_ERROR', "Los datos NO fueron eliminados exitosamente, algo salió mal.");
DEFINE('_EW_CREDITS_TITLE', "Créditos");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Estadísticas diarias y semanales de");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "Permiso AJAX denegado: Por favor vea estas estadísticas desde el dominio que especificó en el archivo configuration.php de joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Talvés solo haya olvidado poner www. antes del nombre de su dominio. Su javascript está tratando de accesar ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "desde");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "lo que lo hace pensar que es un dominio diferente.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Obtenga el código más reciente de esta extensión en");
DEFINE('_EW_HEADER_CAST_YOUR', "Haga su");
DEFINE('_EW_HEADER_VOTE', "Voto");

// ToolTips.
DEFINE('_EW_TOOLTIP_CLICK', "Haga clic para mostrar un mensaje de ayuda");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Ponga el cursor encima para mostrar un mensaje de ayuda");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "incremento de ayer");
DEFINE('_EW_TOOLTIP_HELP', "Abre ayuda externa online para");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Cerrar esta ventana");
DEFINE('_EW_TOOLTIP_PRINT', "Imprimir");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Insertar una nueva meta");
DEFINE('_EW_GOALS_UPDATE', "Actualice un no. de meta");
DEFINE('_EW_GOALS_ACTION', "Acción");
DEFINE('_EW_GOALS_TITLE', "Nueva meta");
DEFINE('_EW_GOALS_NEW', "Nueva meta");
DEFINE('_EW_GOALS_RELOAD', "Recargar");
DEFINE('_EW_GOALS_ADVANCED', "Avanzado");
DEFINE('_EW_GOALS_NAME', "Nombre");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "Condición URI");
DEFINE('_EW_GOALS_GET_VAR', "var GET");
DEFINE('_EW_GOALS_GET_CONDITION', "Condición GET");
DEFINE('_EW_GOALS_POST_VAR', "POST Var");
DEFINE('_EW_GOALS_POST_CONDITION', "Condición POST");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Condición de título");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Condición de nombre de usuario");
DEFINE('_EW_GOALS_IP_CONDITION', "Condición IP");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Viene de condición");
DEFINE('_EW_GOALS_BLOCK', "Bloquear");
DEFINE('_EW_GOALS_REDIRECT', "Redireccionar a URL");
DEFINE('_EW_GOALS_HITS', "Hits");
DEFINE('_EW_GOALS_ENABLED', "Activo");
DEFINE('_EW_GOALS_EDIT', "Editar");
DEFINE('_EW_GOALS_DELETE', "Borrar");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Va a perder toda las estadísticas recientes para esta meta. Realmente desea eliminar un no. de meta.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Países");
DEFINE('_EW_FRONTEND_VISITORS', "Visitantes");
DEFINE('_EW_FRONTEND_TODAY', "Hoy");
DEFINE('_EW_FRONTEND_YESTERDAY', "Ayer");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Esta semana");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Semana pasada");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Este mes");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Mes pasado");
DEFINE('_EW_FRONTEND_TOTAL', "Total");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch está en modo de depuración. De esta manera puede descubrir las causas de error. Para salir del modo, por favor cambie el valor de EXTRAWATCH_DEBUG en /components/com_extrawatch/config.php de 1 a 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Máximo de filas a mostrar cuando las estadísticas están en modo expandido.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Todas las direcciones IP que tengan menos hits en días anteriores que en este su valor será eliminado del historial IP.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Todas las URL que tengan menos hits en días anteriores que en este su valor será eliminado del historial IP");
DEFINE('_EW_DESC_IGNORE_IP', "Excluye ciertas IP de las estadísticas. Separe con salto de línea. Puede usar comodínes aqui. <br/>Ej. 192.* ignorara 192.168.51.31, 192.168.16.2, etc..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Actualización de visitantes en milisegundos, 2000 por defecto, sea cauteloso con esto. Luego recargue la consola de administración de ExtraWatch.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Actualización de estadísticas en milisegundos, 4000 por defecto, sea cauteloso con esto. Luego recargue la consola de administración de ExtraWatch.");
DEFINE('_EW_DESC_MAXID_BOTS', "Cuántas visitas de bots mantener en la base de datos.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Cuántos visitantes reales mantener en la base de datos.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Cuántos bots se verán en la consola de administración.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Cuántos visitantes reales se verán en la consola de administración.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Máximo número de caracteres que se mostrarán en títulos y URIs largos.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Máximo número de caracteres que se mostrarán en el panel de estadísticas derecho.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Días que se mantendrán las estadísticas en la base de datos, 0 = infinito.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Cuándo esté en una zona horaria distinta a su servidor de hosting. (valor positivo o negativo en horas)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Compensación de semana, timestamp/(3600*24*7) da el número de la semana desde el 1.1.1970, esta compensación es para hacerlo comenzar en lunes ");
DEFINE('_EW_DESC_DAY_OFFSET', "Compensación de día, timestamp/(3600*24) da el número de dias desde el 1.1.1970, esta compensación es para hacerlo comenzar a las 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "Para usar un ícono de 1x1px en el front-end");
DEFINE('_EW_DESC_IP_STATS', "Para activar las estadísticas de direcciones IP. En algunos países mantener una dirección IP en una base de datos por tiempo prolongado es prohibido por la ley. Úselo bajo su propio riesgo.");
DEFINE('_EW_DESC_HIDE_ADS', "Esta configuración esconde todos los ads en la consola de administración, si estos le incomodan. Dejándolos, usted ayuda al desarrollo de nuevas mejoras para esta herramienta. Gracias");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Desmarque, si desea mostrar el mensaje de ayuda al pasar el puntero, en vez de al hacer clic.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Por defecto es 'REDIRECT_URL', lo cual es normal si se utiliza la reescritura de URL, puede cambiarse a 'SCRIPT_URL' si solo registra index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Mensaje que se mostrará a un usuario bloqueado, o una información de por qué ha sido bloqueado.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Ancho del mensaje de ayuda");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Altura del mensaje de ayuda");
DEFINE('_EW_DESC_TOOLTIP_URL', "Puede poner cualquier URL aquí, para ver la ip del visitante. La {ip} será reemplazada por la ip del visitante. Ej. http://unsitio.com/query?verip={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Puede escribir cualquier URI que desee que sea ignorada por las estadísticas. Puede usar comodínes (* y ?) aquí. Ej.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Especifíque una meta aquí. Este nombre lo verá en las estadísticas.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Todo lo que esta después del nombre de su dominio. Para http://www.codegravity.com/projects/ la URI es: /projects/ (Ejemplo de uso: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "Variable GET es una variable que puede ver en la URL usualmente después de un signo de ? o &amp;. Ej. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Puede usar también <u>*</u> en este campo para abarcar todos los valores GET. (Ejemplo de uso: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Aquí debe especificar una coincidencia con un valor del campo anterior. (Ejemplo de uso: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Bastante similar, pero esta vez revisamos los valores obtenidos por formularios enviados. Asi que, cuando tenga un formulario en su sitio web, que tenga un campo &lt;input type='text' name='<u>experiences</u>' /&gt;. (Ejemplo de uso: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Una coincidencia con el valor de este campo del POST. Ej. queremos verificar si el usuario tiene experiencia en java. (Ejemplo de uso: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Un título de pagina que debe coincidir. (Ejemplo de uso: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "El nombre de un usuario que haya iniciado sesión. (Ejemplo de uso: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP de procedencia del usuario: (Ejemplo de uso: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "Una URL de donde vino el usuario. (Ejemplo de uso: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "El usuario es redirigido a una URL especificada por usted. Tiene una prioridad mayor que 'bloqueo': (Ejemplo de uso: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Cuántos caracteres cortar en la tabla de metas");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "Link de retorno a codegravity.com, puede desactivarlo, pero apreciamos que lo deje. Gracias");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Muestra el total de estadísticas de países en el módulo de la Fachada del Sitio. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Si desea cambiar el orden de Visitantes/Países en la Fachada del Sitio. Desmárquelo, y los visitantes aparecerán primero.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Número de países a mostrar en la Fachada del Sitio.");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Mostrar visitantes de países en el módulo de la Fachada del Sitio. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Tiempo en segundos para buscar caché total de los países en la Fachada del Sitio");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Tiempo en segundos para buscar cache de visitantes en la Fachada del Sitio");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Para mostrar en la Fachada del Sitio los visitantes de: hoy. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Para mostrar en la Fachada del Sitio los visitantes de: ayer. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Para mostrar en la Fachada del Sitio los visitantes de: esta semana. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Para mostrar en la Fachada del Sitio los visitantes de: la semana pasada. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Para mostrar en la Fachada del Sitio los visitantes de: este mes. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Para mostrar en la Fachada del Sitio los visitantes de: el mes pasado. Si es cambiada, esta configuración será efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Para mostrar el número total de visitantes desde la instalación de ExtraWatch. Si es cambiada, esta configuración sera efectiva después del tiempo asignado en CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Archivo de idioma a usar. Los archivos están almacenados en /components/com_extrawatch/lang/. Si desea crear un nuevo idioma, primero revise la página web del proyecto, y si el archivo de idioma no está allí, entonces copie el archivo por defecto english.php a, por ej. italian.php y póngalo en el mismo directorio. Luego, traduzca todos los valores a la derecha referencias (o claves).");
DEFINE('_EW_DESC_GOALS', "Las metas le permiten especificar parámetros especiales. Cuando estos parámetros coinciden, el contador de metas se incrementa. De esta manera puede monitorear si el usuario ha visitado una URL en específico, enviado un valor en específico, tiene un nombre de usuario específico o vino de una dirección específica. También puede bloquear o redireccionar estos usuarios a alguna otra URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "En todos los campos, excepto el nombre se puede usar los comodínes * y ?. Por ejemplo: ?arro (va a coincidir con: tarro, carro, barro..),  l*r (va a coincidir con: leer, lamer, lugar..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Asignada en 1, si desea bloquear al visitante. El no verá el resto del contenido, solo el mensaje que dice que fue bloqueado - sin ninguna redirección y su IP es añadida a las estadísticas de bloqueo (Ejemplo de uso: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Condición de país");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "Código de país en mayúsculas, 2 letras (Ej: <b>ES</b>)");
DEFINE('_EW_STATS_INTERNAL', "Flujo de entrada");
DEFINE('_EW_STATS_FROM', "Desde");
DEFINE('_EW_STATS_TO', "Hasta");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Añadir a metas");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Añadir meta para este país");
DEFINE('_EW_MENU_REPORT_BUG', "Reportar falla o sugerir mejora");
DEFINE('_EW_GOALS_COUNTRY', "País");

/* traducciones 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Para presentar en mayúsculas los nombres de los países en la Fachada del Sitio (p Ej: ALEMANIA, REINO UNIDO en vez de Alemania, Reino Unido)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Tiempo en segundos para obtener el caché de usuarios en la Fachada del Sitio.");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Valor inicial del conteo de visitas en la Fachada del Sitio. Útil cuando se ha migrado desde otra herramienta de estadísticas. (p Ej.: 20000). Si no desea usar esta característica, déjela en 0.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignorar usuarios enlistados aquí. Uno por línea. (P Ej.: yo {salto de linea} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Usuarios más activos hoy de un total de");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "¿Activar los bloqueos basados en las palabras de la lista negra a continuación?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Palabras más comúnmente usadas por los bots de spam. Puede utilizar comodines aquí, (p Ej.: f?rmac*). Si la opción de arriba es activada, ExtraWatch revisará si el atacante envío un formulario (en un request HTTP POST) en su sitio web con algunas de estas palabras spam (lista negra). (Se aplica solo si el formulario se envia al sitio administrado con Joomla - foros, comentarios, pero es bastante efectivo para bloquear bots spam que intenten enviar spam desde cualquier form posible)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Un enlace en el módulo de Usuarios de la Fachada del Sitio - le permite especificar una URL, la cual se abre cuando se hace clic en algún nombre de usuario. Debe contener el string {user}, que sera reemplazado por el verdadero nombre de usuario. (p Ej. index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Frases de seguridad");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Máximo número de entradas desplegadas en la pestaña de historial. (Ejemplo de uso: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "En visitas, solo mostrar la última página visitada, no todas");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "En visitas, ocultar los nombres de sitios repetidos en el título de página");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Máximo número de visitantes a mantener en la base de datos del Historial de Visitas. Sea cuidadoso con esta configuración, si posee un alto tráfico, puede crecer muy rapidamente. Revise con regularidad el tamaño de la tabla de historial en Estado");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Mantener las Tablas de la Base de Datos al desinstalar. Seleccione esta opción antes de desinstalar si va a actualizar a una versión mas reciente y desea conservar los datos.");

/* email reports */

DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Recibirá correos electrónicos cada noche con los reportes del día, los cuales podrá leer en la mañana.");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Dirección de correo electrónico a donde serán enviados los reportes");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "En los reportes por correo, incluir únicamente las filas cuyos porcentages sean mayores que {value}. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "En los reportes por correo, incluir únicamente los cambios <b>positivos en un día</b> mayores a {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "En los reportes por correo, incluir únicamente los cambios <b>negativos en un día</b> menores a un {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "En los reportes por correo, incluir únicamente los cambios <b>positivos en siete días</b> mayores a un {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "En los reportes por correo, incluir únicamente los cambios <b>negativos en siete días</b> menores a un {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "En los reportes por correo, incluir únicamente los cambios <b>positivos en treinta días</b> mayores a un {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "En los reportes por correo, incluir únicamente los cambios <b>negativos en treinta días</b> menores a un {value} por ciento. Cambiar a 0 si no desea utilizar esta opción.  <i>(Ejemplo de uso: -13)</i");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(sólo en la versión PRO)</b> Activar esta configuración si desea que el hipervínculo del logo se genere con el atributo rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Máximo número de caracteres a mostrar en la fila de nombre de correo. Cambie esta configuración si la ventana de mensaje de su cliente de correo electrónico es muy pequeña");

DEFINE('_EW_MENU_HISTORY', "Historial");
DEFINE('_EW_MENU_EMAILS', "Correos Electrónicos");
DEFINE('_EW_MENU_STATUS', "Estado");
DEFINE('_EW_DESC_BLOCKED', "Estas IPs han sido bloqueadas por el anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Historial de Visitantes");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Mostrando sólo los últimos %d registros.
                Para cambiar este valor, vaya a Configuraciones -&gt; Historial &amp; Desempeño -&gt; HISTORY_MAX_DB_RECORDS . Sea cuidadoso, esta configuración afecta el tiempo de carga de los datos visualizados.  ");
DEFINE('_EW_MENU_BUG', "Reportar Defecto");
DEFINE('_EW_MENU_FEATURE', "Solicitar Nueva Funcionalidad");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Palabras Clave");

DEFINE('_EW_BLOCKING_UNBLOCK', "desbloquear");
DEFINE('_EW_STATS_KEYPHRASE ', "Frase Clave");

DEFINE('_EW_STATUS_DATABASE', "Estado de la Base de Datos");
DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "nombre de tabla");
DEFINE('_EW_STATUS_DATABASE_ROWS', "filas");
DEFINE('_EW_STATUS_DATABASE_DATA', "datos");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "total");

DEFINE('_EW_EMAIL_REPORTS', "Reportes por correo");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Reporte de filtrado generado de ayer");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Filtros por Valor");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "valor");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "por ciento");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "cambio de 1 día");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "cambio de 7 días");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "cambio de 28 días");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch ha bloqueado %d hits de spamers durante el dia, total: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Direcciones IP Bloqueadas");
DEFINE('_EW_ANTISPAM_SETTINGS', "Configuraciones Anti-Spam");
DEFINE('_EW_TRAFFIC_AJAX', "Tráfico de actualizaciones AJAX");


DEFINE('_EW_HISTORY_PREVIOUS', "anterior");
DEFINE('_EW_HISTORY_NEXT', "siguiente");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Número de columnas de países");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Número de filas de países");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Mostrar/Ocultar nombres de países");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Mostrar las banderas primero, luego los porcentages");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "Condición invertida GET");
DEFINE('_EW_GOALS_POST_INVERSED', "Condición invertida POST");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Condición invertida de Título");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Condición invertida de nombre de usuario");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Vino de una condición invertida");


DEFINE('_EW_STATS_MAP', "Mapa de la Última Visita");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Por favor ingrese a clave <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> para mostrar el mapa de la última visita:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "guardar clave");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Por favor ingrese una clave ipinfodb válida obtenida de: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "SOLICITUD ERRÓNEA: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Campos de formulario enviados:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "Parametros de URL:");
DEFINE('_EW_VISIT_ADD_PAGE', " Añadir página como meta");
DEFINE('_EW_VISIT_BLOCK_IP', " Bloquear esta dirección IP");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Añadir esta variable de formulario enviada como meta");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Añadir este parámetro URL como meta");

DEFINE('_EW_TREND_EMPTY', "Vacío");

DEFINE('_EW_NOT_NUMBER', " ADVERTENCIA: El valor ingresado no es un número. ¡ExtraWatch no funcionará apropiadamente!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Esta es una Versión de Evaluación de 15 días. Días Restantes: <b>%d</b>. Por favor compre la licencia de por vida de <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch para su dominio</a>, para esta versión y las siguientes.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Su versión de prueba ha expirado. Por favor compre ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Licencia activada exitosamente. Gracias");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Error: la clave de licencia y su dominio no concuerdan.</b><br/>¿Ha ingresado el nombre de dominio en el formulario de activación tal como se muestra abajo? Por favor contacte: info@codegravity.com");
DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Si lleva viendo el mensaje de arriba por largo tiempo, su dirección del sitio en vivo puede estar incorrecta.
                    Abra el archivo components/com_extrawatch/config.php
                    descomente, y ponga su sitio actual. Ej.:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Advertencia: el sitio en su navegador y el sitio en vivo en la configuracion: %s y %s no se corresponden.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Cambia el sitio en vivo a: %s y continúa...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Remover Link de Retorno");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Base de Conocimiento");
DEFINE('_EW_ADMINHEADER_FLOW', "Flujo");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Gráficos");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Componentes");
DEFINE('_EW_ADMINHEADER_REVIEW', "Valoración");
DEFINE('_EW_ADMINHEADER_WRITE', "Escriba una ");

DEFINE('_EW_FLOW_TRAFFIC', "Flujo de Tráfico");
DEFINE('_EW_FLOW_SELECT_PAGE', "Seleccionar página:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Conteo general de links salientes:");
DEFINE('_EW_FLOW_NESTING', "Nivel de anidamiento:");
DEFINE('_EW_FLOW_SCALE', "Escala:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Versión libre de publicidad");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "¡Muchas gracias por su donación!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "La clave de registro para su dominio %s es: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Ahora puede remover el enlace de retorno o esconder el logo de JoonlaWatch en la Fachada del Sitio desde Configuración ");

DEFINE('_EW_SIZES_LAST_CHECK', "La última revisión fue hecha el:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "AZUL = Tamaño de component/module en el directorio /administrator");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Componente");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Total:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Tamaño");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Refrescar Todo");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabla");
DEFINE('_EW_SIZEDATABASE_SIZE', "Tamaño");
DEFINE('_EW_SIZEDATABASE_1DAY', "Cambio de 1 Día");
DEFINE('_EW_SIZEDATABASE_7DAY', "Cambio de 7 Días");
DEFINE('_EW_SIZEDATABASE_28DAY', "Cambio de 28 Días");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "sin datos");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Total:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Refrescar Todo");
DEFINE('_EW_SIZEMODULES_TOTAL', "Total:");
DEFINE('_EW_SIZEMODULES_MODULE', "Módulo");
DEFINE('_EW_SIZEMODULES_SIZE', "Tamaño");

DEFINE('_EW_SIZES_FILES', "Archivos &amp; Directorios");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");

DEFINE('_EW_SIZES_REFRESH', "Refrescar");
DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");
DEFINE('_EW_STATUS_MB', "MB");

DEFINE('_EW_DESC_IPINFODB_KEY', "Última clave ipinfodb.com de mapa de visita de: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Forzar Ajuste de Zona Horaria");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Actualizar");
DEFINE('_EW_MENU_UPDATE_TITLE', "Respaldar & Actualizar a Nueva Versión");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "No disponible en esta versión, por favor revise la pestaña de lincencia");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Bloqueo por Palabras Spam Activado");
DEFINE('_EW_SPAMWORD_LIST', "Lista de Palabras Spam");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Ocultar Título Repetitivo");
DEFINE('_EW_TRUNCATE_VISITS', "Borrar Visitas");
DEFINE('_EW_TRUNCATE_STATS', "Borrar Estadísticas");
DEFINE('_EW_TRUNCATE_GOALS', "Borar Metas");
DEFINE('_EW_LIMIT_BOTS', "Limitar Bots");
DEFINE('_EW_LIMIT_VISITORS', "Limitar Visitantes");
DEFINE('_EW_TOOLTIP_WIDTH', "Ancho del Globo de Ayuda");
DEFINE('_EW_TOOLTIP_HEIGHT', "Alto del Globo de Ayuda");
DEFINE('_EW_TOOLTIP_URL', "URL del Globo de Ayuda");
DEFINE('_EW_TOOLTIP_ONCLICK', "Acción OnClick del Globo de Ayuda");
DEFINE('_EW_IP_STATS', "Estadísticas de IP");
DEFINE('_EW_IPINFODB_KEY', "Clave de la Base de Datos para la información IP ");
DEFINE('_EW_ONLY_LAST_URI', "Sólo Última URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Logo Oculto en la Fachada del Sitio ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "'No Follow' en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Sin Enlace de Retorno en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_USER_LINK', "Link de Usuario en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Mostrar primero el país en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Nombres de Países en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Países en mayúscula en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Mostrar primero la bandera del país en la Fachada del Sitio ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Número de Países en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Máximo Número de Columnas de Países en la Fachada del Sitio ");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Máximo Número de Filas de Países en la Fachada del Sitio");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Visitantes Externos Hoy ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Visitantes Externos Ayer ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Visitantes Externos Esta Aemana ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Visitantes Externos Semana Pasada ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Visitantes Externos Este Mes ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Visitantes Externos Mes Pasado");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Total de Visitantes Externos");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Total de Inicial de Visitantes Externos");
DEFINE('_EW_HISTORY_MAX_VALUES', "Máximos Valores del Historial");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Máximo Número de Registros del Historial");
DEFINE('_EW_UPDATE_TIME_VISITS', "Tiempo de Actualización de Visitas");
DEFINE('_EW_UPDATE_TIME_STATS', "Tiempo de Actualización de Estadísticas");
DEFINE('_EW_STATS_MAX_ROWS', "Máximo número de filas en Estadísticas");
DEFINE('_EW_STATS_IP_HITS', "Estadístiacs de hits de IP");
DEFINE('_EW_MAXID_BOTS', "Máximo número de bots ID");
DEFINE('_EW_MAXID_VISITORS', "Máximo número de visitantes ID");
DEFINE('_EW_STATS_KEEP_DAYS', "Días para mantener estadísticas ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Almacenar en caché los Países mostrados en la fachada ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Almacenar en caché los Visitantes mostrados en la fachada ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Mantener Datos al Desinstalar ");
DEFINE('_EW_IGNORE_IP', "Ignorar IP");
DEFINE('_EW_IGNORE_URI', "Ignorar URI");
DEFINE('_EW_IGNORE_USER', "Ignorar Usuario");
DEFINE('_EW_BLOCKING_MESSAGE', "Bloquear Mensaje");
DEFINE('_EW_SERVER_URI_KEY', "Clave URI del servidor");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Total Inicial de Visitantes en la fachada");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Registros");
/***********EDITs*****************/

DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Para que el bloqueo sea efectivo, debe publicar el 'ExtraWatch agent' ANTES que cualquier contenido o formulario. Ej. en la parte izquierda de su plantilla.
                    <br/>
                    Vaya a Gestor de Módulos -> ExtraWatch agent -> elija posición izquierda (left)");
DEFINE('_EW_EMAIL_SEO_REPORTS', "Reportes SEO");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "Reportes nocturnos de SEO activados");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Vea el demo de instalación");


/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
