<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu
DEFINE('_EW_MENU_STATS', "Statistik Live");
DEFINE('_EW_MENU_GOALS', "Sasaran");
DEFINE('_EW_MENU_SETTINGS', "Pengaturan");
DEFINE('_EW_MENU_CREDITS', "Kredit");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Dokumentasi");
DEFINE('_EW_MENU_LICENSE', "Lisensi");
DEFINE('_EW_MENU_DONATORS', "Pendukung");
DEFINE('_EW_MENU_SUPPORT', "Dukung ExtraWatch untuk menghilangkan iklan di halaman admin.");


// Left visitors real-time window
DEFINE('_EW_VISITS_VISITORS', "Pengunjung Terakhir");
DEFINE('_EW_VISITS_BOTS', "Bots");
DEFINE('_EW_VISITS_CAME_FROM', "Datang dari");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Modul ExtraWatch anda tidak diterbitkan! Tidak ada statistik baru yang akan tercatat. Agar terbit, masuk ke bagian Modules dan publish it on all pages");
DEFINE('_EW_VISITS_PANE_LOADING', "Memuat kunjungan...");

// Right stats window
DEFINE('_EW_STATS_TITLE', "Statistik kunjungan pada minggu");
DEFINE('_EW_STATS_WEEK', "Minggu");
DEFINE('_EW_STATS_THIS_WEEK', "minggu ini");
DEFINE('_EW_STATS_UNIQUE', "unik");
DEFINE('_EW_STATS_LOADS', "muatan");
DEFINE('_EW_STATS_HITS', "hits");
DEFINE('_EW_STATS_TODAY', "hari ini");
DEFINE('_EW_STATS_FOR', "pada");
DEFINE('_EW_STATS_ALL_TIME', "Sepanjang waktu");
DEFINE('_EW_STATS_EXPAND', "luaskan");
DEFINE('_EW_STATS_COLLAPSE', "sempitkan");
DEFINE('_EW_STATS_URI', "Halaman");
DEFINE('_EW_STATS_COUNTRY', "Negara");
DEFINE('_EW_STATS_USERS', "Pengguna");
DEFINE('_EW_STATS_REFERERS', "Pengarah");
DEFINE('_EW_STATS_IP', "IP");
DEFINE('_EW_STATS_BROWSER', "Browser");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "Kata kunci");
DEFINE('_EW_STATS_GOALS', "Sasaran");
DEFINE('_EW_STATS_TOTAL', "Total");
DEFINE('_EW_STATS_DAILY', "Harian");
DEFINE('_EW_STATS_DAILY_TITLE', "Statistik harian");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Statistik sepanjang waktu");
DEFINE('_EW_STATS_LOADING', "memuat...");
DEFINE('_EW_STATS_LOADING_WAIT', "memuat... silakan tunggu");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "Blokir IP");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Masukkan IP");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Masukkan alamat IP yang akan diblokir. (Contoh. 217.242.11.54 atau 217.* atau 217.242.* untuk memblokir semua IP yang cocok dengan wildcard.)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Yakin mengubah blokir dari ");
DEFINE('_EW_STATS_PANE_LOADING', "Memuat statistik...");

// Settings
DEFINE('_EW_SETTINGS_TITLE', "Pengaturan");
DEFINE('_EW_SETTINGS_DEFAULT', "Standar");
DEFINE('_EW_SETTINGS_SAVE', "Simpan");
DEFINE('_EW_SETTINGS_APPEARANCE', "Penampilan");
DEFINE('_EW_SETTINGS_FRONTEND', "Halaman Depan");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Sejarah &amp; Kinerja");
DEFINE('_EW_SETTINGS_ADVANCED', "Lebih Lanjut");
DEFINE('_EW_SETTINGS_IGNORE', "Abaikan");
DEFINE('_EW_SETTINGS_BLOCKING', "Blokir");
DEFINE('_EW_SETTINGS_EXPERT', "Ahli");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Anda yakin untuk mengatur ulang semua data statistik dan pengunjung?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Atur ulang semua");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Atur ulang semua data statistik &amp; pengunjung");
DEFINE('_EW_SETTINGS_LANGUAGE', "Bahasa");
DEFINE('_EW_SETTINGS_SAVED', "Pengaturan telah disimpan");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Tambahkan IP anda");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "ke daftar.");

// Other / mostly general
DEFINE('_EW_TITLE', "Monitor joomla AJAX real-time");
DEFINE('_EW_BACK', "Kembali");
DEFINE('_EW_ACCESS_DENIED', "Anda tidak memiliki izin untuk melihat ini !");
DEFINE('_EW_LICENSE_AGREE', "Saya menyetujui syarat &amp; kondisi diatas");
DEFINE('_EW_LICENSE_CONTINUE', "Lanjutkan");
DEFINE('_EW_SUCCESS', "Operasi sukses");
DEFINE('_EW_RESET_SUCCESS', "Semua data statistik dan pengunjung sukses dihapus");
DEFINE('_EW_RESET_ERROR', "Data TIDAK sukses dihapus");
DEFINE('_EW_CREDITS_TITLE', "Kredit");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Statistik harian dan mingguan");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "Izin AJAX ditolak: Silakan tampilkan statistik dari domain yang anda tentukan di configuration.php joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Mungkin anda lupa meletakkan www. di depan domain. Javascript mencoba untuk mengakses ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "dari");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "sehingga mengira domain tersebut berbeda.");

// Header
DEFINE('_EW_HEADER_DOWNLOAD', "Dapatkan kode ekstensi terbaru dari");
DEFINE('_EW_HEADER_CAST_YOUR', "Silakan berikan");
DEFINE('_EW_HEADER_VOTE', "vote");

// Tooltips
DEFINE('_EW_TOOLTIP_CLICK', "Klik untuk menampilkan tooltip");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Arahkan tetikus untuk menampilkan tooltip");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "peningkatan kemarin");
DEFINE('_EW_TOOLTIP_HELP', "Buka bantuan eksternal online untuk");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Tutup jendela ini");
DEFINE('_EW_TOOLTIP_PRINT', "Cetak");

// Goals
DEFINE('_EW_GOALS_INSERT', "Masukkan sasaran baru");
DEFINE('_EW_GOALS_UPDATE', "Perbarui sasaran no.");
DEFINE('_EW_GOALS_ACTION', "Aksi");
DEFINE('_EW_GOALS_TITLE', "Sasaran baru");
DEFINE('_EW_GOALS_NEW', "Sasaran baru");
DEFINE('_EW_GOALS_RELOAD', "Muat ulang");
DEFINE('_EW_GOALS_ADVANCED', "Lebih lanjut");
DEFINE('_EW_GOALS_NAME', "Nama");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "Kondisi URI");
DEFINE('_EW_GOALS_URI_INVERSED', "Kondisi inversi URI");
DEFINE('_EW_GOALS_GET_VAR', "Variabel GET");
DEFINE('_EW_GOALS_GET_CONDITION', "Kondisi GET");
DEFINE('_EW_GOALS_POST_VAR', "Variabel POST");
DEFINE('_EW_GOALS_POST_CONDITION', "Kondisi POST");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Kondisi judul");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Kondisi nama pengguna");
DEFINE('_EW_GOALS_IP_CONDITION', "Kondisi IP");
DEFINE('_EW_GOALS_IP_INVERSED', "Kondisi inversi IP");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Datang dari kondisi");
DEFINE('_EW_GOALS_BLOCK', "Blokir");
DEFINE('_EW_GOALS_REDIRECT', "Alihkan ke URL");
DEFINE('_EW_GOALS_HITS', "Hits");
DEFINE('_EW_GOALS_ENABLED', "Aktifkan");
DEFINE('_EW_GOALS_EDIT', "Edit");
DEFINE('_EW_GOALS_DELETE', "Hapus");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Semua data statistik terbaru akan hilang untuk sasaran ini. Anda yakin ingin menghapus sasaran no.");

// Frontend
DEFINE('_EW_FRONTEND_COUNTRIES', "Negara");
DEFINE('_EW_FRONTEND_VISITORS', "Pengunjung");
DEFINE('_EW_FRONTEND_TODAY', "Hari ini");
DEFINE('_EW_FRONTEND_YESTERDAY', "Kemarin");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Minggu Ini");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Minggu Lalu");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Bulan Ini");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Bulan Kemarin");
DEFINE('_EW_FRONTEND_TOTAL', "Total");

// Settings description - quite long
DEFINE('_EW_DESC_DEBUG', "ExtraWatch dalam modus debug untuk mendeteksi penyebab error. Untuk mematikannya, silakan ubah nilai EXTRAWATCH_DEBUG di /components/com_extrawatch/config.php dari 1 ke 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Maks baris yang ditampilkan ketika statistik dalam modus diluaskan.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Semua alamat IP yang hitsnya beberapa hari ini lebih sedikit dari nilai ini akan dihapus dari sejarah IP.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Semua URL yang hitsnya beberapa hari ini lebih sedikit dari nilai ini akan dihapus dari sejarah IP.");
DEFINE('_EW_DESC_IGNORE_IP', "Kecualikan beberapa IP dari statistik. Pisahkan dengan baris. Anda bisa menggunakan wildcard disini <br/>Contoh. 192.* berarti mengabaikan 192.168.51.31, 192.168.16.2, dsb..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Pengunjung merefresh waktu dalam milidetik, standarnya yaitu 2000. Kemudian memuat ulang halaman admin ExtraWatch.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Pengunjung merefresh waktu dalam milidetik, standarnya yaitu 4000. Kemudian memuat ulang halaman admin ExtraWatch.");
DEFINE('_EW_DESC_MAXID_BOTS', "Berapa banyak kunjungan bot untuk disimpan di database.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Berapa banyak kunjungan sebenarnya untuk disimpan di database.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Berapa banyak bot yang akan anda lihat di halaman admin.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Berapa banyak kunjungan nyata yang akan anda lihat di halaman admin.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Karakter maksimum untuk ditampilkan pada judul dan URI panjang.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Karakter maksimum untuk ditampilkan pada panel statistik kanan.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Jumlah hari untuk menyimpan statistik di database, 0 = selamanya.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Bila anda berada di zona waktu yang berbeda dari server. (nilai jam positif atau negatif)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Week offset, catatan waktu/(3600*24*7) menghasilkan nomoran minggu mulai dari 1.1.1970, offset ini merupakan koreksi untuk mulai dari senin ");
DEFINE('_EW_DESC_DAY_OFFSET', "Day offset, catatan waktu/(3600*24) menghasilkan nomoran hari mulai dari 1.1.1970, offset ini merupakan koreksi untuk mulai dari 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(berfungsi pada versi PRO)</b> Untuk menggunakan icon 1x1px kosong pada halaman depan");
DEFINE('_EW_DESC_IP_STATS', "Untuk mengaktifkan statistik alamat IP. Menyimpan alamat IP di database pada waktu yang lama di beberapa negara dilarang oleh hukum. Gunakan pilihan ini dengan risiko anda sendiri.");
DEFINE('_EW_DESC_HIDE_ADS', "Pengaturan ini menyembunyikan iklan pada halaman admin, jika tampilannya tidak anda sukai. Namun dengan tetap menampilkan iklan berarti anda mendukung pengembangan lebih lanjut sarana ini. Terima kasih");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Hilangkan tanda cek bila anda ingin menampilkan tooltip sewaktu mouse-over, ketimbang ketika mouse diklik.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Standarnya yaitu 'REDIRECT_URL', yaitu standar untuk penulisan ulang url, dapat ditetapkan menjadi 'SCRIPT_URL' jika yang disimpan hanya index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Pesan yang ditampilkan untuk memblokir pengguna atau informasi lanjutan mengapa anda memblokir pengguna ini.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Lebar tooltip");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Tinggi tooltip");
DEFINE('_EW_DESC_TOOLTIP_URL', "Anda bisa menaruh URL apa saja disini, untuk menggambarkan IP pengunjung. Alamat {ip} akan diganti dengan IP pengunjung. Contoh http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Anda dapat mengetik URI apa saja untuk diabaikan dari statistik. Anda bisa menggunakan (* dan ?) disini. Contoh: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Terapkan nama sasaran disini. Nama ini akan anda lihat pada statistik.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Semuanya setelah nama domain. Untuk http://www.codegravity.com/projects/ maka URI nya yaitu: /projects/ (Contoh penggunaan : <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "Variabel GET merupakan variabel yang bisa dilihat pada URL setelah tanda ? atau &amp;. Contoh http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Anda dapat menggunakan <u>*</u> di field ini untuk memindai semua nilai yang ada. (Contoh penggunaan: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Disini anda harus menetapkan nilai yang cocok dari field sebelumnya. (Contoh penggunaan: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Hampir serupa, namun kita mengecek nilai yang diberikan oleh form. Jadi bila website anda memiliki form, akan ada field &lt;input type='text' name='<u>experiences</u>' /&gt;. (Contoh penggunaan: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Pencocokan nilai dari field POST. Contoh: kita ingin mengecek apakah pengguna memiliki pengalaman java. (Contoh penggunaan: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Judul halaman yang harus cocok. (Contoh penggunaan: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Nama dari pengunjung yang login. (Contoh penggunaan: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP dari mana pengunjung datang: (Contoh penggunaan: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "URL dari mana pengunjung datang. (Contoh penggunaan: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "Pengguna dialihkan ke URL yang diterapkan. Memiliki prioritas lebih tinggi daripada 'blokir': (Contoh penggunaan: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Berapa karakter dipotong pada tabel sasaran");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(berfungsi pada versi PRO)</b> Backlink ke codegravity.com, anda bisa menonaktifkan, namun kami menghargai bila tetap ada disana. Terima kasih");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Menampilkan statistik total negara pada modul halaman depan. Jika diubah, pengaturan ini akan efektif pada halaman depan setelah waktu diset pada CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Jika anda ingin menukar urutan Pengunjung/Negara di halaman depan. Hilangkan tanda cek agar pengunjung tampil lebih dulu.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Jumlah negara yang ditampilkan di halaman depan");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Jumlah pengunjung yang ditampilkan di modul halaman depan. Jika diubah, pengaturan ini akan efektif pada halaman depan setelah waktu diset pada CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Waktu dalam detik untuk menampung pengambilan total negara di halaman depan");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Waktu dalam detik untuk menampung pengambilan total pengunjung di halaman depan");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Untuk menampilkan pengunjung di halaman depan untuk: hari ini. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Untuk menampilkan pengunjung di halaman depan untuk: kemarin. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Untuk menampilkan pengunjung di halaman depan untuk: minggu ini. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Untuk menampilkan pengunjung di halaman depan untuk: minggu lalu. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Untuk menampilkan pengunjung di halaman depan untuk: bulan ini. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Untuk menampilkan pengunjung di halaman depan untuk: bulan lalu. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Untuk menampilkan pengunjung di halaman depan sejak instalasi ExtraWatch. Jika diubah, pengaturan ini akan efektif halaman depan setelah waktu diset pada CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "File bahasa yang digunakan. Letaknya ada di /components/com_extrawatch/lang/. Untuk file bahasa yang baru, cek terlebih dahulu pada situs proyek ini. Jika ternyata bahasa yang diinginkan tidak ada disana, salin file english.php menjadi german.php misalnya, lalu taruh di folder ini. Lalu terjemahkan semua nilai kunci yang ada disebelah kanan.");
DEFINE('_EW_DESC_GOALS', "Sasaran digunakan untuk menetapkan parameter khusus. Bila parameter ini cocok, penghitung sasaran menjadi bertambah. Dengan cara ini anda bisa memonitor apakah pengunjung telah mengunjungi URL khusus, atau memasang nilai khusus, atau memiliki nama pengguna khusus atau datang dari alamat atau khusus. Anda juga dapat memblokir atau mengalihkan pengguna ke URL tertentu.");
DEFINE('_EW_DESC_GOALS_INSERT', "Pada semua field kecuali nama anda bisa menggunakan tanda * dan ? sebagai wildcard. Contoh: ?ear (akan cocok dengan: near, tear, ..),  p*r (akan cocok dengan: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Beri nilai 1, jika anda ingin pengunjung diblokir. Pengunjung tidak akan melihat sisa konten, hanya pesan bahwa ia diblokir - tanpa pengalihan apapun dan IP nya akan ditambahkan kedalam statistik 'diblokir' (Contoh penggunaan: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Kondisi negara");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "Kondisi inversi negara");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2-huruf kode negara dengan huruf kapital (Contoh: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "Internal");
DEFINE('_EW_STATS_FROM', "Dari");
DEFINE('_EW_STATS_TO', "Ke");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Tambahkan ke Sasaran");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Tambahkan sasaran untuk negara ini");
DEFINE('_EW_MENU_REPORT_BUG', "Laporkan bug atau fitur");
DEFINE('_EW_GOALS_COUNTRY', "Negara");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Jika anda ingin nama negara dalam huruf kapital pada halaman depan (contoh: GERMANY, UNITED KINGDOM dan bukan Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Waktu dalam detik untuk menampung pengambilan pengguna di halaman depan");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Nilai inisial ditunjukkan pada Total: di halaman depan. Berguna ketika anda bermigrasi dari sarana statistik lain. (contoh: 20000). Beri nilai 0 jika anda tidak ingin menggunakan fitur ini.");
DEFINE('_EW_DESC_IGNORE_USER', "Pengguna yang diabaikan ada di kotak teks ini. Satu pengguna per baris. (Contoh: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Pengguna paling aktif hari ini total dari");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Mengaktifkan pencegahan berdasarkan kata-kata dari daftar kata spam dibawah ?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Kata-kata spam paling umum oleh bots spam. Anda bisa menggunakan wildcard disini, (Contoh: ph?rmac*). Jika pengaturan diatas diaktifkan, ExtraWatch akan mengecek apakah penyerang menyerahkan form (permintaan HTTP POST) pada website anda dengan kata-kata spam. (Berlaku jika form memuat website berbasis Joomla - forum, komentar, namun juga efektif untuk memblokir bots spam yang mencoba menyerahkan form apapun)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Tautan pada modul halaman depan pengguna - memungkinkan untuk menetapkan suatu URL, yang akan terbuka ketika pengguna mengklik nama user. Harus berisi string {user}, yang akan digantikan dengan nama pengguna sebenarnya. (Contoh index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Frasakunci");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Nilai maksimum pada tab Sejarah (Contoh: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "Pada kunjungan tampilkan hanya halaman terakhir yang dikunjungi, bukan semua");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "Pada kunjungan sembunyikan nama website repetitif pada judul halaman yang dikunjungi");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Jumlah maksimum pengunjung untuk disimpan di database untuk Sejarah Kunjungan. Waspadai pengaturan ini, bila anda memiliki lalulintas tinggi maka pengaturan ini akan tumbuh dengan cepat. Selalu periksa berapa banyak data di tabel sejarah pada Status");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Tetap simpan tabel database sewaktu menghapus instalasi. Pilih pilihan ini sebelum menghapus instalasi jika anda melakukan upgrade dan ingin menjaga data tetap ada.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Anda akan menerima email setiap malam berisi laporan tentang hari sebelumnya, yang dapat anda baca di pagi hari");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Alamat email tempat menerima laporan-laporan ini");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Masukkan baris pada laporan email jika persentase lebih tinggi daripada {value}. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Masukkan nilai perubahan <b>positif satu hari</b> pada laporan email yang lebih tinggi daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Masukkan nilai perubahan <b>negatif satu hari</b> pada laporan email yang lebih rendah daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Masukkan nilai perubahan <b>positif tujuh hari</b> pada laporan email yang lebih tinggi daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Masukkan nilai perubahan <b>negatif tujuh hari</b> pada laporan email yang lebih rendah daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Masukkan nilai perubahan <b>positif dua puluh delapan hari</b> pada laporan email yang lebih tinggi daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Masukkan nilai perubahan <b>negatif dua puluh delapan hari</b> pada laporan email yang lebih rendah daripada {value} persen. Beri nilai 0 jika anda tidak ingin menggunakan fitur ini <i>(contoh: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(berfungsi pada versi PRO)</b> Aktifkan pengaturan ini jika anda ingin untuk membuat tautan logo dengan atribut rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Karakter maksimal pada nama baris email. Ubah ini jika jendela pesan klien email anda terlalu kecil");

DEFINE('_EW_MENU_HISTORY', "Sejarah");
DEFINE('_EW_MENU_EMAILS', "Email");
DEFINE('_EW_MENU_STATUS', "Status DB");
DEFINE('_EW_DESC_BLOCKED', "IP ini diblokir oleh anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Sejarah Pengunjung");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Hanya menampilkan %d catatan terakhir.
                Untuk mengubahnya, pergi ke menu Pengaturan -&gt; Sejarah &amp; Kinerja -&gt; HISTORY_MAX_DB_RECORDS . Hati-hati, pengaturan ini mempengaruhi waktu memuat data dibawah ini.  ");
DEFINE('_EW_MENU_BUG', "Laporkan Bug");
DEFINE('_EW_MENU_FEATURE', "Pengajuan Fitur");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Kata Kunci");

DEFINE('_EW_BLOCKING_UNBLOCK', "buka blokir");
DEFINE('_EW_STATS_KEYPHRASE ', "Frasakunci");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "nama tabel");
DEFINE('_EW_STATUS_DATABASE_ROWS', "baris");
DEFINE('_EW_STATUS_DATABASE_DATA', "data");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "total");

DEFINE('_EW_EMAIL_REPORTS', "Laporan Email");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Laporan email tersaring yang dihasilkan kemarin");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Penyaring Nilai Email");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "nilai");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "persen");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "perubahan 1-hari");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "perubahan 7-hari");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "perubahan 28-hari");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch telah memblokir %d spammer hari ini, total: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Alamat IP Diblokir");
DEFINE('_EW_ANTISPAM_SETTINGS', "Pengaturan Anti-Spam");
DEFINE('_EW_TRAFFIC_AJAX', "Lalulintas update AJAX (kecuali peta)");


DEFINE('_EW_HISTORY_PREVIOUS', "sebelumnya");
DEFINE('_EW_HISTORY_NEXT', "selanjutnya");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Jumlah kolom negara");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Jumlah baris negara");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Tampilkan nama negara atau tidak");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Tampilkan bendera dulu, kemudian persen");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "Kondisi inversi GET");
DEFINE('_EW_GOALS_POST_INVERSED', "Kondisi inversi POST");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Kondisi inversi judul");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Kondisi inversi nama pengguna");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Kondisi inversi datang dari");

DEFINE('_EW_STATS_MAP', "Peta Kunjungan Terakhir");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Silakan masukkan kunci <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> untuk menampilkan peta kunjungan terakhir:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "simpan kunci");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Harap masukkan kunci ipinfodb yang valid berasal dari: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "BAD REQUEST: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Field form diserahkan:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "Parameter URL:");
DEFINE('_EW_VISIT_ADD_PAGE', " tambahkan halaman sebagai sasaran");
DEFINE('_EW_VISIT_BLOCK_IP', " Blokir alamat IP ini");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Tambahkan variabel form diserahkan sebagai sasaran");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Tambahkan parameter URL sebagai sasaran");

DEFINE('_EW_TREND_EMPTY', "Empty");

DEFINE('_EW_NOT_NUMBER', " PERINGATAN: nilai yang anda masukkan bukan angka. ExtraWatch tidak akan berfungsi dengan baik!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Ini adalah Versi Evaluasi 15-hari. Sisa Hari: <b>%d</b>. Silakan beli <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>lisensi ExtraWatch untuk domain anda</a> seumur hidup untuk versi ini dan selanjutnya.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Versi ujicoba anda telah berakhir. Silakan beli ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Lisensi sukses diaktifkan. Terima kasih");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Kesalahan: Kunci lisensi dan domain anda tidak cocok</b><br/>Apakah anda memasukkan nama domain yang sama pada formulir dibawah ini? <br/>Klik '<b>pengajuan kunci aktivasi</b>' dibawah, atau kontak: info@codegravity.com<br/>");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Jika anda melihat pesan diatas terlalu panjang, situs anda mungkin salah.
                    Buka file components/com_extrawatch/config.php
                    Hilangkan tanda komentar, lalu atur situs aktual anda. Contoh:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Peringatan: situs pada browser dan situs di konfigurasi: %s and %s tidak cocok.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Atur situs pada: %s dan lanjutkan...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Hapus Backlink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Dasar Pengetahuan");
DEFINE('_EW_ADMINHEADER_FLOW', "Aliran");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Grafik");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Komponen");
DEFINE('_EW_ADMINHEADER_REVIEW', "Ulasan");
DEFINE('_EW_ADMINHEADER_WRITE', "Tulis ");

DEFINE('_EW_FLOW_TRAFFIC', "Aliran Lalulintas");
DEFINE('_EW_FLOW_SELECT_PAGE', "Pilih halaman:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Hitungan tautan keluar root:");
DEFINE('_EW_FLOW_NESTING', "Level bersarang :");
DEFINE('_EW_FLOW_SCALE', "Skala:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Versi bebas-iklan");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Terima kasih banyak atas donasi anda!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Kunci registrasi untuk domain anda adalah %s: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Sekarang anda bisa menghapus backlink atau menyembunyikan logo ExtraWatch pada halaman depan dari Pengaturan");


DEFINE('_EW_SIZES_LAST_CHECK', "Pengecekan terakhir dilakukan pada:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Ukuran komponen/module pada direktori administrator");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Komponen");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Total:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Ukuran");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Refresh Semua");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabel");
DEFINE('_EW_SIZEDATABASE_SIZE', "Ukuran");
DEFINE('_EW_SIZEDATABASE_1DAY', "Perubahan 1-Hari");
DEFINE('_EW_SIZEDATABASE_7DAY', "Perubahan 7-Hari");
DEFINE('_EW_SIZEDATABASE_28DAY', "Perubahan 28-Hari");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "tidak ada data");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Total:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Refresh Semua");
DEFINE('_EW_SIZEMODULES_TOTAL', "Total:");
DEFINE('_EW_SIZEMODULES_MODULE', "Modul");
DEFINE('_EW_SIZEMODULES_SIZE', "ukuran");

DEFINE('_EW_SIZES_FILES', "File &amp; Direktori");
DEFINE('_EW_SIZES_BYTES', "byte");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Refresh");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ oleh CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "Ukuran Tabel Database");


DEFINE('_EW_DESC_IPINFODB_KEY', "Kunjungan terakhir kunci peta ipinfodb.com dari: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Force Timezone Offset");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Perbarui");
DEFINE('_EW_MENU_UPDATE_TITLE', "Cadangan & Upgrade");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Tidak tersedia di versi gratis, silakan periksa tab lisensi");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Aktifkan Penolakan Kata-kata Spam");
DEFINE('_EW_SPAMWORD_LIST', "Daftar Kata-kata Spam");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Sembunyikan Judul Repetitif");
DEFINE('_EW_TRUNCATE_VISITS', "Potong Kunjugan");
DEFINE('_EW_TRUNCATE_STATS', "Potong Statistik");
DEFINE('_EW_TRUNCATE_GOALS', "Potong Sasaran");
DEFINE('_EW_LIMIT_BOTS', "Batas Bots");
DEFINE('_EW_LIMIT_VISITORS', "Batas Pengunjung");
DEFINE('_EW_TOOLTIP_WIDTH', "Lebar Tooltip");
DEFINE('_EW_TOOLTIP_HEIGHT', "Tinggi Tooltip");
DEFINE('_EW_TOOLTIP_URL', "URL Tooltip");
DEFINE('_EW_TOOLTIP_ONCLICK', "OnClick Tooltip");
DEFINE('_EW_IP_STATS', "Statistik IP");
DEFINE('_EW_IPINFODB_KEY', "Kunci IP Info DB");
DEFINE('_EW_ONLY_LAST_URI', "Hanya URI Terakhir");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Sembunyikan Logo Halaman Depan ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "No Follow Halaman Depan ");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Tidak ada Back Link Halaman Depan");
DEFINE('_EW_FRONTEND_USER_LINK', "Tautan User Depan");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Negara Halaman Depan pertama");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Nama Negara Halaman Depan");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Negara Kapital Halaman Depan");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Bendera Negara Halaman Depan Pertama ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Jumlah Negara Halaman Depan");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Maks Kolom Negara Halaman Depan");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Maks Baris Negara Halaman Depan");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Pengunjung Halaman Depan Hari Ini ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Pengunjung Halaman Depan Kemarin ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Pengunjung Halaman Depan Minggu Ini ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Pengunjung Halaman Depan Minggu Lalu ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Pengunjung Halaman Depan Bulan Ini ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Pengunjung Halaman Depan Bulan Lalu");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Sembunyikan Total Pengunjung Halaman Depan");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Inisial Total Halaman Depan");
DEFINE('_EW_HISTORY_MAX_VALUES', "Nilai Maks Sejarah");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Catatan Maks Sejarah");
DEFINE('_EW_UPDATE_TIME_VISITS', "Perbarui Waktu Kunjungan");
DEFINE('_EW_UPDATE_TIME_STATS', "Perbarui Waktu Statistik");
DEFINE('_EW_STATS_MAX_ROWS', "Baris Maks Statistik");
DEFINE('_EW_STATS_IP_HITS', "Hits IP Statistik");
DEFINE('_EW_MAXID_BOTS', "Maks ID Bots ");
DEFINE('_EW_MAXID_VISITORS', "Maks ID Pengunjung");
DEFINE('_EW_STATS_KEEP_DAYS', "Hari Menyimpan Statistik");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Cache Negara Halaman Depan ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Cache Pengunjung Halaman Depan ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Simpan Data Sewaktu Penghapusan Instalasi");
DEFINE('_EW_IGNORE_IP', "Abaikan IP");
DEFINE('_EW_IGNORE_URI', "Abaikan URI");
DEFINE('_EW_IGNORE_USER', "Abaikan User");
DEFINE('_EW_BLOCKING_MESSAGE', "Blokir Pesan");
DEFINE('_EW_SERVER_URI_KEY', "Kunci URI Serveer");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Inisial Total Pengunjung Halaman Depan");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Record");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Agar pemblokiran efektif, anda harus menerbitkan agen ExtraWatch SEBELUM konten atau form apapun. Contoh: pada sebelah kiri template anda.
                    <br/>
                    Pergi ke Module Manager -> ExtraWatch agent -> select position as left");

DEFINE('_EW_EMAIL_SEO_REPORTS', "Laporan SEO");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "Laporan email SEO setiap malam diaktifkan");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Lihat demo instalasi");


/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
