<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Live Stats");
DEFINE('_EW_MENU_GOALS', "Goals");
DEFINE('_EW_MENU_SETTINGS', "Settings");
DEFINE('_EW_MENU_CREDITS', "Credits");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Documentation");
DEFINE('_EW_MENU_LICENSE', "License");
DEFINE('_EW_MENU_DONATORS', "Supporters");
DEFINE('_EW_MENU_SUPPORT', "Support ExtraWatch and get your ads removed from backend.");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Latest Visitors");
DEFINE('_EW_VISITS_BOTS', "Bots");
DEFINE('_EW_VISITS_CAME_FROM', "Came from");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Your ExtraWatch module is not published! No new stats are being recorded. To publish it, go to Modules section and publish it on all pages");
DEFINE('_EW_VISITS_PANE_LOADING', "Loading visits...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Visit stats for week");
DEFINE('_EW_STATS_WEEK', "Week");
DEFINE('_EW_STATS_THIS_WEEK', "this week");
DEFINE('_EW_STATS_UNIQUE', "unique");
DEFINE('_EW_STATS_LOADS', "loads");
DEFINE('_EW_STATS_HITS', "hits");
DEFINE('_EW_STATS_TODAY', "today");
DEFINE('_EW_STATS_FOR', "for");
DEFINE('_EW_STATS_ALL_TIME', "All-time");
DEFINE('_EW_STATS_EXPAND', "expand");
DEFINE('_EW_STATS_COLLAPSE', "collapse");
DEFINE('_EW_STATS_URI', "Pages");
DEFINE('_EW_STATS_COUNTRY', "Countries");
DEFINE('_EW_STATS_USERS', "Users");
DEFINE('_EW_STATS_REFERERS', "Referers");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "Browsers");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "Keywords");
DEFINE('_EW_STATS_GOALS', "Goals");
DEFINE('_EW_STATS_TOTAL', "Total");
DEFINE('_EW_STATS_DAILY', "Daily");
DEFINE('_EW_STATS_DAILY_TITLE', "Daily stats");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "All-time stats");
DEFINE('_EW_STATS_LOADING', "loading...");
DEFINE('_EW_STATS_LOADING_WAIT', "loading... please wait");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "IP Blocking");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Enter IP manually");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Enter IP an address you want to block. (eg. 217.242.11.54 or 217.* or 217.242.* to block all IPs matching the wildcard)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Really toggle blocking of ");
DEFINE('_EW_STATS_PANE_LOADING', "Loading stats...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Settings");
DEFINE('_EW_SETTINGS_DEFAULT', "Default");
DEFINE('_EW_SETTINGS_SAVE', "Save");
DEFINE('_EW_SETTINGS_APPEARANCE', "Appearance");
DEFINE('_EW_SETTINGS_FRONTEND', "Frontend");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "History &amp; Performance");
DEFINE('_EW_SETTINGS_ADVANCED', "Advanced");
DEFINE('_EW_SETTINGS_IGNORE', "Ignore");
DEFINE('_EW_SETTINGS_BLOCKING', "Blocking");
DEFINE('_EW_SETTINGS_EXPERT', "Expert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Do you really want to reset all the statistic and visitor data?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Reset all");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Reset all statistic &amp; visitor data");
DEFINE('_EW_SETTINGS_LANGUAGE', "Language");
DEFINE('_EW_SETTINGS_SAVED', "Settings were saved");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Add your IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "to the list.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Real time visitor monitor and live stats ");
DEFINE('_EW_BACK', "Back");
DEFINE('_EW_ACCESS_DENIED', "You don't have any permissions to view this !");
DEFINE('_EW_LICENSE_AGREE', "I Agree to the terms &amp; conditions above");
DEFINE('_EW_LICENSE_CONTINUE', "Continue");
DEFINE('_EW_SUCCESS', "Operation successful");
DEFINE('_EW_RESET_SUCCESS', "All statistic and visitor data erased succesfully");
DEFINE('_EW_RESET_ERROR', "Data NOT erased succesfully, something went wrong");
DEFINE('_EW_CREDITS_TITLE', "Credits");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Daily and weekly stats of");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX permission denied: Please view this statistics from domain you specified in configuration.php of joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Maybe you just forgotten www. in front of your domain name. Your javascript is trying to access ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "from");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "what makes it to think it's a different domain.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Get the latest extension's code from");
DEFINE('_EW_HEADER_CAST_YOUR', "Please cast your");
DEFINE('_EW_HEADER_VOTE', "vote");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Click to show tooltip");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Hover a mouse over to show tooltip");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "yesterday&apos;s increase");
DEFINE('_EW_TOOLTIP_HELP', "Opens online external help for");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Close this window");
DEFINE('_EW_TOOLTIP_PRINT', "Print");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Insert a new goal");
DEFINE('_EW_GOALS_UPDATE', "Update a goal no.");
DEFINE('_EW_GOALS_ACTION', "Action");
DEFINE('_EW_GOALS_TITLE', "New goal");
DEFINE('_EW_GOALS_NEW', "New goal");
DEFINE('_EW_GOALS_RELOAD', "Reload");
DEFINE('_EW_GOALS_ADVANCED', "Advanced");
DEFINE('_EW_GOALS_NAME', "Name");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "URI condition");
DEFINE('_EW_GOALS_URI_INVERSED', "URI inversed condition");
DEFINE('_EW_GOALS_GET_VAR', "GET var");
DEFINE('_EW_GOALS_GET_CONDITION', "GET condition");
DEFINE('_EW_GOALS_POST_VAR', "POST Var");
DEFINE('_EW_GOALS_POST_CONDITION', "POST Condition");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Title condition");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Username condition");
DEFINE('_EW_GOALS_IP_CONDITION', "IP Condition");
DEFINE('_EW_GOALS_IP_INVERSED', "IP inversed Condition");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Came from condition");
DEFINE('_EW_GOALS_BLOCK', "Block");
DEFINE('_EW_GOALS_REDIRECT', "Redirect to URL");
DEFINE('_EW_GOALS_HITS', "Hits");
DEFINE('_EW_GOALS_ENABLED', "Enabled");
DEFINE('_EW_GOALS_EDIT', "Edit");
DEFINE('_EW_GOALS_DELETE', "Delete");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "You will loose all recent statistics data for this goal. Do you really want do delete a goal no.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Countries");
DEFINE('_EW_FRONTEND_VISITORS', "Visitors");
DEFINE('_EW_FRONTEND_TODAY', "Today");
DEFINE('_EW_FRONTEND_YESTERDAY', "Yesterday");
DEFINE('_EW_FRONTEND_THIS_WEEK', "This Week");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Last Week");
DEFINE('_EW_FRONTEND_THIS_MONTH', "This Month");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Last Month");
DEFINE('_EW_FRONTEND_TOTAL', "Total");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch is in debug mode. This way you can discover error causes. To turn it off, please change the value EXTRAWATCH_DEBUG in /components/com_extrawatch/config.php from 1 to 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Max rows to show when stats are in expanded mode.");
DEFINE('_EW_DESC_STATS_IP_HITS', "All IP addresses that have less hits in previous days than this value will be deleted from IP history.");
DEFINE('_EW_DESC_STATS_URL_HITS', "All URLs that have less hits in previous days than this value will be deleted from IP history.");
DEFINE('_EW_DESC_IGNORE_IP', "Exclude certain IP from stats. Separate with a new line. You can use wildcards here. <br/>Eg. 192.* will ignore 192.168.51.31, 192.168.16.2, etc..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Visitors refresh time in miliseconds, default is 2000, be careful with this. Then reload the ExtraWatch back-end.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Stats refresh time in miliseconds, default is 4000, be careful with this. Then reload the ExtraWatch back-end.");
DEFINE('_EW_DESC_MAXID_BOTS', "How many bot visits to keep in a database.");
DEFINE('_EW_DESC_MAXID_VISITORS', "How many real visits to keep in a database.");
DEFINE('_EW_DESC_LIMIT_BOTS', "How many bots you'll see in back-end.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "How many real visitors you'll see in back-end.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Maximum characters to be shown in long titles and uris.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Maximum characters to be shown in right statistics panel.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Days to keep statistics in database, 0 = infinite.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "When you are in a different timezone than your hosting server. (positive or negative value in hours)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Week offset, the timestamp/(3600*24*7) gives the week number from 1.1.1970, this offset is a correction to make it start with monday ");
DEFINE('_EW_DESC_DAY_OFFSET', "Day offset, the timestamp/(3600*24) gives the day number from 1.1.1970, this offset is a correction to make it start at 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(functional in PRO version)</b> To use a blank 1x1px icon in front-end");
DEFINE('_EW_DESC_IP_STATS', "To enable the IP address statistics. In some countries to keep the IP in a database for a longer time is prohibited by a law. Use at your own risk.");
DEFINE('_EW_DESC_HIDE_ADS', "This setting hides the ads in the backend, if they really annoy you. By keeping them, you support the further development of this tool. Thank you");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Uncheck, if you want to display tooltip on mouse-over, instead of mouse click.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Default is 'REDIRECT_URL', which is standard if you use url rewriting, can be set to 'SCRIPT_URL' if it logs only index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Message that's shown to blocked user or further information why you are blocking these users.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Tooltip width");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Tooltip height");
DEFINE('_EW_DESC_TOOLTIP_URL', "You can put any URL here, to visualize the visitor's ip. The {ip} will be replaced by the visitor's ip. Eg. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "You can type any URI you want to be ignored from stats. You can use wildcards (* and ?) here. Eg.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Specify a goal name here. This name you will see in stats.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Everything that is after your domain name. For http://www.codegravity.com/projects/ the URI is: /projects/ (Example to use: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET variable is a variable which you can see in the URL usually after a ? or &amp; sign. Eg. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. You can use also <u>*</u> in this field to scan all the get values. (Example to use: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Here you have to specify a match for a value from the previous field. (Example to use: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Quite similar, but we're checking for the values submitted from forms. So when you have a form on your website, that has a field &lt;input type='text' name='<u>experiences</u>' /&gt;. (Example to use: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "A match for the value from this POST field. Eg. we want to check, whether the user has java experiences. (Example to use: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "A title of a page that has to match. (Example to use: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "A name of a logged-in user. (Example to use: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP that a user comes from: (Example to use: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "An URL that the user came from. (Example to use: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "User is redirected to an URL specified by you. Has a higher priority than 'blocking': (Example to use: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "How many chars to truncate in goals table");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(functional in PRO version)</b> Backlink to codegravity.com, you can disable it, but we'll appreciate you will keep it there. Thank you");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Display countries total stats in the frontend module. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "If you want to swap the order of Visitors/Countries in frontend. Uncheck it, and Visitors will appear first.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Number of countries to show in frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Display countries visitors in the frontend module. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Time in seconds to cache fetching of countries total in frontend");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Time in seconds to cache fetching of visitors in frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "To show visitors in frontend for: today. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "To show visitors in frontend for: yesterday. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "To show visitors in frontend for: this week. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "To show visitors in frontend for: last week. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "To show visitors in frontend for: this month. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "To show visitors in frontend for: last month. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "To show total number visitors since ExtraWatch installation. If changed, this setting will be effective in frontend after time set in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Language file to use. They are placed in /components/com_extrawatch/lang/. If you want to create a brand new language file, first check the project's homepage, and if the language file is still not there, just copy the default english.php to eg. german.php and place it in this directory. Then, translate all the key values on the right.");
DEFINE('_EW_DESC_GOALS', "Goals allow you to specify special parameters. When these parameters match, the goal counter is increased. This way you can monitor whether the user has visited a specific URL, posted a specific value, has a specific username or came from a specific address. You can also block or redirect such users to some other URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "In all of the fields except the name you can use the * and ? as wildcards. For example: ?ear (will match: near, tear, ..),  p*r (will match: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Set to 1, if you want the visitor to be blocked. He won't see the rest of the content, just the message that he was blocked - without any redirection and his IP is added to 'blocked' stats (Example to use: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Country condition");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "Country inversed condition");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2-letter country code in upper case (Eg: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "Internal");
DEFINE('_EW_STATS_FROM', "From");
DEFINE('_EW_STATS_TO', "To");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Add to goals");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Add goal for this country");
DEFINE('_EW_MENU_REPORT_BUG', "Report bug or feature");
DEFINE('_EW_GOALS_COUNTRY', "Country");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "If you want the names of the countries in the uppercase in frontend (Eg: GERMANY, UNITED KINGDOM instead of Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Time in seconds to cache fetching of users in frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Initial value shown in Total: in frontend. Useful when you migrated from other stat tool. (Eg.: 20000). Set back to 0 if you don't want to use this feature.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignore users listed in this textbox. One per line. (Eg.: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Most active users today from total of");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Enable the bans based on the words from the spamword list below ?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Most common spam words used by spam bots. You can use the wildcards here, (Eg.: ph?rmac*). If the setting above is enabled, ExtraWatch will check whether the attacker submitted a form (the HTTP POST request) on your website with some of these spam words. (Applies if the form loads the Joomla-based website only - forum, comments, but is quite effective to block spam bots which try to submit every possible form)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "A link in the frontend Users module - allows you to specify an URL, which is open when the user clicks the user name. Must contain the string {user}, which will be replaced by the actual user name. (Eg. index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Keyphrases");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Maximum values in history tab (Example: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "In visits show only last page visited, not all");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "In visits hide repetitive sitename in visited page title");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Maximum number of visitors to keep in database for Visit History. Be careful with this setting, if you have high traffic, it can grow really fast. Always check how much data the history table contains in Status");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Keep Database Tables on uninstall. Check this option before uninstall if you are doing an upgrade and want to keep your data.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "You'll receive nightly emails with reports for previous day, which you can read in the morning");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Email address to which you'll receive these reports");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Only include rows in email reports where percentage is higher than {value}. Set to 0 if you don't want to use this feature <i>(example: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Only include <b>positive one day</b> change values in email reports higher than {value} percent. Set to 0 if you don't want to use this feature <i>(example: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Only include <b>negative one day</b> change values in email reports lower than {value} percent. Set to 0 if you don't want to use this feature <i>(example: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Only include <b>positive seven day</b> change values in email reports higher than {value} percent. Set to 0 if you don't want to use this feature <i>(example: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Only include <b>negative seven day</b> change values in email reports lower than {value} percent. Set to 0 if you don't want to use this feature <i>(example: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Only include <b>positive twenty eight day</b> change values in email reports higher than {value} percent. Set to 0 if you don't want to use this feature <i>(example: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Only include <b>negative twenty eight day</b> change values in email reports lower than {value} percent. Set to 0 if you don't want to use this feature <i>(example: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(functional in PRO version)</b> Enable this setting if you want to make the logo link rendered with attribute rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Maximum characters of email row name. Change this if your email client message window is too small");

DEFINE('_EW_MENU_HISTORY', "History");
DEFINE('_EW_MENU_EMAILS', "Emails");
DEFINE('_EW_MENU_STATUS', "DB Status");
DEFINE('_EW_DESC_BLOCKED', "These IPs were blocked by anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Visitors History");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Showing only %d last records.
                To change this value, go to Settings -&gt; History &amp; Performance -&gt; HISTORY_MAX_DB_RECORDS . Be careful, this setting affects load times of the data below.  ");
DEFINE('_EW_MENU_BUG', "Report Bug");
DEFINE('_EW_MENU_FEATURE', "Request Feature");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Keywords");

DEFINE('_EW_BLOCKING_UNBLOCK', "unblock");
DEFINE('_EW_STATS_KEYPHRASE ', "Keyphrase");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "table name");
DEFINE('_EW_STATUS_DATABASE_ROWS', "rows");
DEFINE('_EW_STATUS_DATABASE_DATA', "data");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "total");

DEFINE('_EW_EMAIL_REPORTS', "Email Reports");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Generated filtered email report from yesterday");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Email Value Filters");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "value");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "percent");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "1-day change");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "7-day change");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "28-day change");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch has blocked %d spammer hits today, total: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Blocked IP Adresses");
DEFINE('_EW_ANTISPAM_SETTINGS', "Anti-Spam Settings");
DEFINE('_EW_TRAFFIC_AJAX', "AJAX updates traffic (except maps)");


DEFINE('_EW_HISTORY_PREVIOUS', "previous");
DEFINE('_EW_HISTORY_NEXT', "next");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Number of columns of countries");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Number of rows of countries");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Display country names or not");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Display flags first, then percents");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "GET inversed condition");
DEFINE('_EW_GOALS_POST_INVERSED', "POST inversed condition");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Title inversed condition");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Username inversed condition");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Came from inversed condition");

DEFINE('_EW_STATS_MAP', "Last Visit Map");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Please enter <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> key to display last visit map:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "store key");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Please enter valid ipinfodb key you obtained from: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "BAD REQUEST: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Submitted form fields:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URL parameters:");
DEFINE('_EW_VISIT_ADD_PAGE', " Add page as goal");
DEFINE('_EW_VISIT_BLOCK_IP', " Block this IP Address");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Add this submitted form variable as goal");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Add this URL parameter as goal");

DEFINE('_EW_TREND_EMPTY', "Empty");

DEFINE('_EW_NOT_NUMBER', " WARNING: The value you entered is not a number. ExtraWatch will not work properly!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; This is 15-day Evaluation Version. Days Left: <b>%d</b>. Please purchase the lifetime <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch license for your domain</a> for this and upcoming versions.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Your trial version has expired. Please purchase ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "License activated successfully. Thank you");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Error: the license key and your domain don't match.</b><br/>Did you enter the same domain name into donation form as one you see below? <br/>Click '<b>request the correct activation key</b>' below, or contact: info@codegravity.com<br/>");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "If you are seeing the message above for too long, your live site may be wrong.
                    Open the components/com_extrawatch/config.php
                    uncomment, and set your actual live site. Eg.:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Warning: site in your browser and live site in configuration: %s and %s don't match.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Set live site to: %s and continue...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Remove Backlink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Knowledge Base");
DEFINE('_EW_ADMINHEADER_FLOW', "Flow");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Graphs");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Sizes");
DEFINE('_EW_ADMINHEADER_REVIEW', "Review");
DEFINE('_EW_ADMINHEADER_WRITE', "Write a ");

DEFINE('_EW_FLOW_TRAFFIC', "Traffic Flow");
DEFINE('_EW_FLOW_SELECT_PAGE', "Select page:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Root outgoing links count:");
DEFINE('_EW_FLOW_NESTING', "Nesting level:");
DEFINE('_EW_FLOW_SCALE', "Scale:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Ad-free version");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Thank you very much for your purchase!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "License key for your domain %s is: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Now you can remove backlink or hide ExtraWatch logo in frontend from Settings ");


DEFINE('_EW_SIZES_LAST_CHECK', "Last check was performed on:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Size of component/module in /administrator directory");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Component");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Total:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Size");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Refresh All");

DEFINE('_EW_SIZEDATABASE_TABLE', "Table");
DEFINE('_EW_SIZEDATABASE_SIZE', "Size");
DEFINE('_EW_SIZEDATABASE_1DAY', "1-Day Change");
DEFINE('_EW_SIZEDATABASE_7DAY', "7-Day Change");
DEFINE('_EW_SIZEDATABASE_28DAY', "28-Day Change");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "no data");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Total:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Refresh All");
DEFINE('_EW_SIZEMODULES_TOTAL', "Total:");
DEFINE('_EW_SIZEMODULES_MODULE', "Module");
DEFINE('_EW_SIZEMODULES_SIZE', "Size");

DEFINE('_EW_SIZES_FILES', "Files &amp; Directories");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Refresh");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "Database Table Sizes");


DEFINE('_EW_DESC_IPINFODB_KEY', "Last visit map ipinfodb.com key from: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Force Timezone Offset");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Update");
DEFINE('_EW_MENU_UPDATE_TITLE', "Backup & Upgrade");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Not available in free version, please check the license tab");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Spam Words Ban Enable");
DEFINE('_EW_SPAMWORD_LIST', "Spam Words List");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Hide Repetitive Title");
DEFINE('_EW_TRUNCATE_VISITS', "Truncate Visits");
DEFINE('_EW_TRUNCATE_STATS', "Truncate Stats");
DEFINE('_EW_TRUNCATE_GOALS', "Truncate Goals");
DEFINE('_EW_LIMIT_BOTS', "Limit Bots");
DEFINE('_EW_LIMIT_VISITORS', "Limit Visitors");
DEFINE('_EW_TOOLTIP_WIDTH', "Tooltip Width");
DEFINE('_EW_TOOLTIP_HEIGHT', "Tooltip Height");
DEFINE('_EW_TOOLTIP_URL', "Tooltip URL");
DEFINE('_EW_TOOLTIP_ONCLICK', "Tooltip OnClick");
DEFINE('_EW_IP_STATS', "IP stats");
DEFINE('_EW_IPINFODB_KEY', "IP Info DB key ");
DEFINE('_EW_ONLY_LAST_URI', "Only Last URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Front End Hide Logo ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "Front End No Follow");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Front End no Back Link");
DEFINE('_EW_FRONTEND_USER_LINK', "Front User links");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Front End countries first");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Front End Countries Name");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Front End Countries Upper case");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Front End Countries Flag First ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Front End Countries Num");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Front End Countries Max Colums");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Front End Countries Max Rows");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Front End Visitors Today ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Front End Visitors Yesterday ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Front End Visitors This week ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Front End Visitors Last week ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Front End Visitors This Month ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Front End Visitors Last Month");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Front End Visitors Total");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Front End Total Initial");
DEFINE('_EW_HISTORY_MAX_VALUES', "History Max Values");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "History Max records");
DEFINE('_EW_UPDATE_TIME_VISITS', "Update Time Visits");
DEFINE('_EW_UPDATE_TIME_STATS', "Update Time stats");
DEFINE('_EW_STATS_MAX_ROWS', "Stats Max rows");
DEFINE('_EW_STATS_IP_HITS', "Stats IP hits");
DEFINE('_EW_MAXID_BOTS', "Max ID bots");
DEFINE('_EW_MAXID_VISITORS', "Maxid Visitors");
DEFINE('_EW_STATS_KEEP_DAYS', "Stats Keep days ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Cache Front End Countries ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Cache Front End Visitors ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Uninstall Keep Data ");
DEFINE('_EW_IGNORE_IP', "Ignore IP");
DEFINE('_EW_IGNORE_URI', "Ignore URI");
DEFINE('_EW_IGNORE_USER', "Ignore User");
DEFINE('_EW_BLOCKING_MESSAGE', "Blocking Message");
DEFINE('_EW_SERVER_URI_KEY', "Server URI key");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Front End Visitors Total Initial");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Records");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " To make the blocking effective, you need to publish ExtraWatch agent BEFORE any content or forms. Eg. on left side in your template.
                    <br/>
                    Go to Module Manager -> ExtraWatch agent -> select position as left");

DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO Reports");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO Nightly email reports enabled");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Watch installation demo");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");

/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");

