<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Statistieken");
DEFINE('_EW_MENU_GOALS', "Doelen");
DEFINE('_EW_MENU_SETTINGS', "Instellingen");
DEFINE('_EW_MENU_CREDITS', "Credits");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Documentatie");
DEFINE('_EW_MENU_LICENSE', "Reclame vrije licentie");
DEFINE('_EW_MENU_DONATORS', "Donateuren");
DEFINE('_EW_MENU_SUPPORT', "Steun ExtraWatch en krijg een administratie zonder reclame.");

// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Nieuwste Bezoekers");
DEFINE('_EW_VISITS_BOTS', "Bots");
DEFINE('_EW_VISITS_CAME_FROM', "Herkomst");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Uw ExtraWatch module is niet gepubliceerd! Er worden geen nieuwe statistieken geregistreerd. Om het te publiceren, ga naar de module sectie en activeer de module op alle paginas");
DEFINE('_EW_VISITS_PANE_LOADING', "Laden bezoekers...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Bezoekers statistieken voor week");
DEFINE('_EW_STATS_WEEK', "Week");
DEFINE('_EW_STATS_THIS_WEEK', "deze week");
DEFINE('_EW_STATS_UNIQUE', "uniek");
DEFINE('_EW_STATS_LOADS', "geladen");
DEFINE('_EW_STATS_HITS', "hits");
DEFINE('_EW_STATS_TODAY', "vandaag");
DEFINE('_EW_STATS_FOR', "voor");
DEFINE('_EW_STATS_ALL_TIME', "Totaal");
DEFINE('_EW_STATS_EXPAND', "uitvouwen");
DEFINE('_EW_STATS_COLLAPSE', "dichtvouwen");
DEFINE('_EW_STATS_URI', "Paginas");
DEFINE('_EW_STATS_COUNTRY', "Landen");
DEFINE('_EW_STATS_USERS', "Gebruikers");
DEFINE('_EW_STATS_REFERERS', "Verwijzers");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "Browsers");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "Kernwoorden");
DEFINE('_EW_STATS_GOALS', "Doelen");
DEFINE('_EW_STATS_TOTAL', "Totaal");
DEFINE('_EW_STATS_DAILY', "Dagelijks");
DEFINE('_EW_STATS_DAILY_TITLE', "Dagelijkse statistieken");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Totale statistieken");
DEFINE('_EW_STATS_LOADING', "laden...");
DEFINE('_EW_STATS_LOADING_WAIT', "laden... een ogenblik aub");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "IP blokkering");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "IP met de hand toevoegen");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Geef het IP adres op dat geblokkeerd moet worden. (bv. 217.242.11.54 of 217.* of 217.242.* om alle IPs die hiermee beginnen te blokkeren)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Wilt U werkelijk de blokkering wijzigen van ");
DEFINE('_EW_STATS_PANE_LOADING', "Statistieken laden...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Instellingen");
DEFINE('_EW_SETTINGS_DEFAULT', "Standaard");
DEFINE('_EW_SETTINGS_SAVE', "Opslaan");
DEFINE('_EW_SETTINGS_APPEARANCE', "Uiterlijk");
DEFINE('_EW_SETTINGS_FRONTEND', "Frontend");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Geschiedenis & Prestaties");
DEFINE('_EW_SETTINGS_ADVANCED', "Geavanceerd");
DEFINE('_EW_SETTINGS_IGNORE', "Negeren");
DEFINE('_EW_SETTINGS_BLOCKING', "Geblokkeerd");
DEFINE('_EW_SETTINGS_EXPERT', "Expert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Wilt U werkelijk alle statistieken & bezoeker data terugzetten?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Herstellen");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Alle statistieken & bezoeker data terugzetten");
DEFINE('_EW_SETTINGS_LANGUAGE', "Taal");
DEFINE('_EW_SETTINGS_SAVED', "Instellingen zijn opgeslagen");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Voeg Uw IP toe");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "aan de lijst.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Een realtime AJAX Joomla Monitor");
DEFINE('_EW_BACK', "Terug");
DEFINE('_EW_ACCESS_DENIED', "U heeft geen toestemming deze gegevens te bekijken !");
DEFINE('_EW_LICENSE_AGREE', "Ik accepteer de bovenstaande voorwaarden en condities");
DEFINE('_EW_LICENSE_CONTINUE', "Verder gaan");
DEFINE('_EW_SUCCESS', "Operatie succesvol");
DEFINE('_EW_RESET_SUCCESS', "Alle statistieken en bezoeker data zij succesvol verwijderd");
DEFINE('_EW_RESET_ERROR', "Het verwijderen van de data is niet gelukt, er is iets mis gegaan");
DEFINE('_EW_CREDITS_TITLE', "Credits");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Dagelijkse en wekelijkse statistieken");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX permissie verboden: Bekijk deze statistieken van het domein dat U heeft gespecificeerd in de configuration.php van joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Misschien ben U vergeten www. voor uw domeinnaam te zetten. Het javascript probeert toegang te krijgen tot ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "van");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "wat ervoor zorgt dat het denkt dat het een ander domein is.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Kijk voor de nieuwste extensies op:");
DEFINE('_EW_HEADER_CAST_YOUR', "Geef je");
DEFINE('_EW_HEADER_VOTE', "Stem");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Klik om de tooltip te zien");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Beweeg hier je muis over om de tootip te zien");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "Stijging van gisteren");
DEFINE('_EW_TOOLTIP_HELP', "Open externe online help voor");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Dit venster sluiten");
DEFINE('_EW_TOOLTIP_PRINT', "Print");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Doel toevoegen");
DEFINE('_EW_GOALS_UPDATE', "Bijwerken van doel nr.");
DEFINE('_EW_GOALS_ACTION', "Actie");
DEFINE('_EW_GOALS_TITLE', "Nieuw doel");
DEFINE('_EW_GOALS_NEW', "Nieuw doel");
DEFINE('_EW_GOALS_RELOAD', "Herladen");
DEFINE('_EW_GOALS_ADVANCED', "Geavanceerd");
DEFINE('_EW_GOALS_NAME', "Naam");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "URI voorwaarden");
DEFINE('_EW_GOALS_GET_VAR', "GET variabele");
DEFINE('_EW_GOALS_GET_CONDITION', "GET voorwaarde");
DEFINE('_EW_GOALS_POST_VAR', "POST variabele");
DEFINE('_EW_GOALS_POST_CONDITION', "POST voorwaarde");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Titel voorwaarde");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Username voorwaarde");
DEFINE('_EW_GOALS_IP_CONDITION', "IP voorwaarde");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Herkomst voorwaarde");
DEFINE('_EW_GOALS_BLOCK', "Blok");
DEFINE('_EW_GOALS_REDIRECT', "Verwijzen naar URL");
DEFINE('_EW_GOALS_HITS', "Hits");
DEFINE('_EW_GOALS_ENABLED', "Geactiveerd");
DEFINE('_EW_GOALS_EDIT', "Wijzigen");
DEFINE('_EW_GOALS_DELETE', "Verwijderen");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "U zal alle recente statistieken voor dit doel verliezen. Wilt U werkelijk het doel verwijderen met nr.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Landen");
DEFINE('_EW_FRONTEND_VISITORS', "Bezoekers");
DEFINE('_EW_FRONTEND_TODAY', "Vandaag");
DEFINE('_EW_FRONTEND_YESTERDAY', "Gisteren");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Deze Week");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Vorige Week");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Deze Maand");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Vorige Maand");
DEFINE('_EW_FRONTEND_TOTAL', "Totaal");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch is in debug mode. Op deze manier kunt U fouten ontdekken. Om deze mode te deactiveren verander dan de waarde van EXTRAWATCH_DEBUG in /components/com_extrawatch/config.php van 1 naar 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Maximaal aantal rijen wanneer de statistieken in uitgeklapte vorm getoond worden.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Alle IP adressen, die minder hits hebben dan deze waarde, worden uit de IP geschiedenis verwijderd.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Alle URLs, die minder hits hebben dan deze waarde, worden uit de IP geschiedenis verwijderd.");
DEFINE('_EW_DESC_IGNORE_IP', "Bepaalde IP adressen van de statistiek uitsluiten. Gebruik voor elk adres op een nieuwe regel. <br/>bv. 217.242.11.54 of 217.* of 217.242.* om alle IPs die hiermee beginnen te blokkeren.");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Bezoeker verversings tijd in milliseconden, standard is 2000, wees hier voorzichtig mee. Hierna de ExtraWatch administratie herladen.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Statistiek verversings tijd in milliseconden, standard is 4000, wees hier voorzichtig mee. Hierna de ExtraWatch administratie herladen.");
DEFINE('_EW_DESC_MAXID_BOTS', "Hoeveel bezoeken van bots in de database bewaard moeten worden.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Hoeveel werkelijke bezoeken er in de database bewaard moeten worden.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Hoeveel bots er getoond worden aan de administratie kant.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Hoeveel werkelijke bezoekers er getoond worden aan de administratie kant.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Maximaal aantal letters die bij lange titels en URIs getoond worden.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Maximaal aantal letters die in het rechter statistiek paneel worden getoond.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Aantal dagen dat de statistieken in de database bewaard moeten worden, 0 = oneindig.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Wanneer U zich in een andere tijdzone bevindt dan Uw server. (positieve of negatieve waarde in uren)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Weekverschuiving, het tijdstip/(3600*24*7) geeft het week nummer vanaf 1.1.1970, deze verschuiving is een correctie om de week op mandag te beginnen");
DEFINE('_EW_DESC_DAY_OFFSET', "Dagverschuiving, het tijdstip/(3600*24) geeft het dag nummer vanaf 1.1.1970, deze verschuiving is een correctie om de dag om 00:00 te beginnen");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "Om een transparant icoon van 1x1px op de voorpagina te gebruiken");
DEFINE('_EW_DESC_IP_STATS', "Om de IP adresstatistieken te activeren. In sommige landen is het verboden om IP adressen voor langere tijd te bewaren. Gebruik op eigen risico!");
DEFINE('_EW_DESC_HIDE_ADS', "Deze instelling verbergt de reclame in de administratie, mochten ze irritant zijn. Door ze te laten staan helpt U de ontwikkeling van dit component, Dank U wel.");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Wanneer U de tooltip wil laten zien bij mouse-over, ipv bij mouse klik, vinkje weghalen.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Standard is 'REDIRECT_URL', dat is de standaard wanneer U URL-Rewriting gebruikt, het kan op 'SCRIPT_URL' gezet worden, wanneer alleen de index.php bewaakt wordt");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Het bericht dat de geblokkeerde bezoeker ziet of meer informatie over de reden waarom de bezoeker wordt geblokkeerd.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Tooltip breedte");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Tooltip hoogte");
DEFINE('_EW_DESC_TOOLTIP_URL', "U kan hier elke URL invullen als voorbeeld voor de bezoeker. De {ip} wordt door de IP van de bezoeker vervangen. Bijvoorbeeld: http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "U kunt hier elke URI in voeren die door de statistieken genegeerd moet worden. U kan vervangingstekens gebruiken (* en ?). Bv.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Specificeer de naam van een doel hier. Deze naam vind je terug in de statistieken.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Alles dat achter Uw domeinnaam komt. Voor http://www.codegravity.com/projects/ de URI is: /projects/ (Voorbeeld: <b>/projects*</b>");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET variabele is een variabele die U meestal in de URL ziet na een ? or & sign. Bv. http://www.codegravity.com/index.php?<u>name</u>=peter&<u>surname</u>=smith. U kan ook <u>*</u> in dit veld gebruiken om alle waarden te scannen. (Voorbeeld: <b>n*me</b>");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Vul hier de waarde in die met de de waarde van het vorige veld (GET-varialbele) overeen moet komen. (Voorbeeld: <b>p?t*r</b> ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Ongeveer hetzelfde, maar hier vergelijken we de waarde met die van formulieren. Dus wanneer U een formulier op de website heeft staan, en die heeft een waarde met bv &lt;input type='text' name='<u>experiences</u>' /&gt;, dan kan U het volgende gebruiken: voorbeeld: <b>exper*ces</b>");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Vul hier de waarde in die met de de waarde van het vorige veld (POST-varialbele) overeen moet komen. Bv. we willen weten of de gebruiker java ervaring heeft. (Voorbeeld: <b>*java*</b>");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Een titel van een pagina die overeen moet komen. (Voorbeeld: <b>*freelance programmers*</b>");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Een naam van een ingelogde gebruiker. (Voorbeeld: <b>psmith*</b>");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP waar een gebruiker vandaan komt: (Voorbeeld: <b>201.9?.*.*</b>");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "Een URL waar de gebruiker vandaan komt. (Voorbeeld: <b>*www.google.*</b>");
DEFINE('_EW_DESC_GOALS_REDIRECT', "De gebruiker wordt door gestuurd naar een door U gespecificeerde URL. Heeft een hogere prioriteit dan 'blokkeren': (Voorbeeld: <b>http://www.codegravity.com/goaway.html</b>");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Maximaal aantal letters die getoond worden in de doelen tabel");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "Backlink naar codegravity.com, U kunt deze depubliceren, maar we stellen het op prijs als U het laat staan. Dank U wel");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Laat het totaal aantal landen zien in de frontend module. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Wanneer U de volgorde van Bezoekers/Landen wil wijzigen. Zonder vinkje staan de Bezoekers bovenaan.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Aantal landen dat te zien is in de frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Laat het bezoekers zien in de frontend module. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Tijd in seconden om de cache op te halen voor het totaal aantal landen in de frontend");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Tijd in seconden om de cache op te halen voor het totaal aantal bezoekers in de frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Laat de boezoekrs in de frontend zien voor: vandaag. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Laat de boezoekrs in de frontend zien voor: gisteren. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Laat de boezoekrs in de frontend zien voor: deze week. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Laat de boezoekrs in de frontend zien voor: vorige week. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Laat de boezoekrs in de frontend zien voor: deze maand. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Laat de boezoekrs in de frontend zien voor: vorige maand. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Laat het totaal aantal bezoekers zien na de installatie van ExtraWatch. Deze instelling is effectief nadat de tijd is ingesteld in de CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Te gebruiken taal bestand. Plaats deze in /components/com_extrawatch/lang/. Wanneer U een compleet nieuw taal bestand wil maken, check dan eerst de homepage van het project, en indien het taal bestand ook daar niet aanwezig is, kopieer dan de standaard english.php naar bv. dutch.php en plaats deze dan in deze directory. Vertaal daarna alle waarden aan de rechterkant.");
DEFINE('_EW_DESC_GOALS', "Doelen laten U toe speciale parameters te specificeren. Wanneer deze parameters overeen komen wordt de doelen teller verhoogd. Op deze manier kan U in de gaten houdenof de bezoeker een specifieke URL heeft bezocht, een specifieke waarde heeft gepost, een specifieke gebruikersnaam heeft of vanaf een specifiek adres komt. U kan ook zulke bezoekers blokkeren of door sturen naar een andere URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "U kan in alle velden, behalve de naam, de vervangingstekens * en ? gebruiken. Bij voorbeeld: ?ear (zal overeen komen met: near, tear, ..), p*r (zal overeen komen met: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Stel in op 1, als U de bezoeker wil blokkeren. Hij zal de verdere inhoud niet zien, alleen het bericht dat hij is geblokkeerd. Hij wordt dan niet door gestuurd en zijn IP wordt toegevoegd aan de 'geblokkeerde' statistieken. Voorbeeld: <b>1</b>");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Land Condities");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2-letter land code in hoofdletters (Bv: <b>NL</b>)");
DEFINE('_EW_STATS_INTERNAL', "Intern");
DEFINE('_EW_STATS_FROM', "Van");
DEFINE('_EW_STATS_TO', "Naar");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Toevoegen aan doelen");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Voeg doel toe voor dit land");
DEFINE('_EW_MENU_REPORT_BUG', "Melden fouten of kenmerken");
DEFINE('_EW_GOALS_COUNTRY', "Land");

/* Dutch translations 1.2.8b_12 */

DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Als U de namen van de landen in hoofdletters wilt in de frontend (Bv. NEDERLAND, DUITSLAND in plaats van Nederland, Duitsland)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Tijd in seconden die nodig is om de gebruikers in de frontend te cachen");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Oorspronkelijke waarde te zien in Totaal: in de frontend. Handig als U migreert van een andere statistiek programma. (Bv: 20000). Zet op 0 als U deze feature niet wil gebruiken.");
DEFINE('_EW_DESC_IGNORE_USER', "Negeer gebruikers uit de lijst in deze textbox. Een per regel. (Bv: mijzelf {line break} mark_*)");
DEFINE('_EW_FRONTEND_USERS_MOST', "Meest actieve gebruikers vandaag van het totaal van");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "De blokkeringen activeren gebaseerd op de woorden uit de spamwoordenlijst hieronder ?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Meest gebruikte spam woorden door spam bots gebruikt. U kan hier wildcards gebruiken, (Bv: ph?rmac*). Als de instelling hierboven is geactiveerd, zal ExtraWatch controleren of de aanvaller een formulier heeft verstuurd (de HTTP POST request) naar uw website met enkele van deze spam woorden. (Is van toepassing als het formulier alleen de Joomla-gebaseerde website laadt - forum, commentaar, maar is effectief in het blokkeren van spam bots die elk type formulier willen versturen)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Een link in de frontend gebruikers module - staat U toe een URL te specificeren, welke open is wanneer de gebruiker op de gebruikersnaam klikt. Moet wel de string {user} bevatten, deze wordt vervangen door de juiste gebruikersnaam. (Bv: index.php option=com_comprofiler&task=userProfile&user={user}) ");


/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Trefzinnen");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Maximale waarden in de geschiedenis tab (Voorbeeld: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "In het aantal bezoeken Toon alleen laatst bezochte pagina, niet alle");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "In het aantal bezoeken, verberg zich herhalende sitenamen in de bezochte pagina titel");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Maximaal aantal bezoekers te bewaren in de database voor Bezoekers Geschiedenis. Wees voorzichtig met deze instelling, als je veel verkeer genereerd, kan het echt snel groeien. Controleer altijd hoeveel gegevens de geschiedenis tabel bevat in Status.");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Behoud Databasetabellen bij deïnstallatie. Vink deze optie aan voor het deïnstalleren als u een upgrade doet en u wilt uw gegevens te bewaren.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "U ontvangt nachtelijke e-mails met rapporten van de voorgaande dag, die u in de ochtend kunt lezen.");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "E-mailadres waar u deze rapporten op wilt ontvangen.");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Voeg alleen rijen in e-mail rapporten toe waarin het percentage hoger is dan {waarde}. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Voeg alleen <b>positieve één dag</b> waarde wijzigingen in e-mail rapporten toe die hoger zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Voeg alleen <b>negatieve één dag</b> waarden toe in het e-mail rapport die lager zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Voeg alleen <b>positieve zeven dagen</b> waarden toe in het e-mail rapport die hoger zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Voeg alleen <b>negatieve zeven dagen</b> waarden toe in het e-mail rapport die lager zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Voeg alleen <b>positieve dertig dagen</b> waarden toe in het e-mail rapport die hoger zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Voeg alleen <b>negatieve dertig dagen</b> waarden toe in het e-mail rapport die lager zijn dan {waarde} procent. Stel in op 0 als u deze functie niet wilt gebruiken <i>(voorbeeld: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(functioneel in advertentie vrije versie)</b> Schakel deze instelling in als u de logo koppeling wilt maken met het attribuut rel='nofollow'");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Maximum aantal tekens van de e-mail naam regel. Verander dit als je e-mail programma bericht venster te klein is");

DEFINE('_EW_MENU_HISTORY', "Geschiedenis");
DEFINE('_EW_MENU_EMAILS', "E-mails");
DEFINE('_EW_MENU_STATUS', "Status");
DEFINE('_EW_DESC_BLOCKED', "Deze IP's werden geblokkeerd door anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Bezoekers Geschiedenis");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Toont slechts %d laatste records. Om deze waarde te veranderen, ga naar Instellingen -> Geschiedenis & Prestaties -> HISTORY_MAX_DB_RECORDS. Wees voorzichtig, deze instelling beïnvloedt laadtijden van de onderstaande gegevens.");
DEFINE('_EW_MENU_BUG', "Rapporteer Bug");
DEFINE('_EW_MENU_FEATURE', "Vraag om extra Functie");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Trefwoorden");

DEFINE('_EW_BLOCKING_UNBLOCK', "deblokkeren");
DEFINE('_EW_STATS_KEYPHRASE ', "Sleutelwoord");
DEFINE('_EW_STATUS_DATABASE', "Database status");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "tabel naam");
DEFINE('_EW_STATUS_DATABASE_ROWS', "regels");
DEFINE('_EW_STATUS_DATABASE_DATA', "data");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "totaal");

DEFINE('_EW_EMAIL_REPORTS', "E-mail Rapporten");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Gegenereerd en gefilterd e-mail verslag van gisteren");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "E-mail Waarde Filters");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "waarde");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "procent");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "na 1 dag");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "na 7 dagen");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "na 30 dagen");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch heeft vandaag %d spammer hits geblokkeerd, totaal: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Geblokkeerde IP Adressen");
DEFINE('_EW_ANTISPAM_SETTINGS', "Anti-Spam instellingen");
DEFINE('_EW_TRAFFIC_AJAX', "AJAX updates verkeer");


DEFINE('_EW_HISTORY_PREVIOUS', "vorige");
DEFINE('_EW_HISTORY_NEXT', "volgende");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Aantal kolommen voor landen");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Aantal regels voor landen");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Toon land namen of niet");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Toon vlaggen eerst, dan de percentages");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "GET inversed condition");
DEFINE('_EW_GOALS_POST_INVERSED', "POST inversed condition");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Title inversed condition");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Username inversed condition");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Came from inversed condition");

DEFINE('_EW_STATS_MAP', "Last Visit Map");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Please enter <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> key to display last visit map:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "store key");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Please enter valid ipinfodb key you obtained from: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "BAD REQUEST: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Submitted form fields:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URL parameters:");
DEFINE('_EW_VISIT_ADD_PAGE', " Add page as goal");
DEFINE('_EW_VISIT_BLOCK_IP', " Block this IP Address");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Add this submitted form variable as goal");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Add this URL parameter as goal");

DEFINE('_EW_TREND_EMPTY', "Empty");

DEFINE('_EW_NOT_NUMBER', " WARNING: The value you entered is not a number. ExtraWatch will not work properly!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; This is a 15-day Evaluation Version. Days Left: <b>%d</b>. Please purchase the lifetime <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch license for your domain</a> for this and upcoming versions.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Your trial version has expired. Please purchase ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "License activated successfully. Thank you");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Error: the license key and your domain don't match.</b><br/>Did you enter the same domain name into activation form as one you see below? Please contact: info@codegravity.com");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "If you are seeing the message above for too long, your live site may be wrong.
                    Open the components/com_extrawatch/config.php
                    uncomment, and set your actual live site. Eg.:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Warning: site in your browser and live site in configuration: %s and %s don't match.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Set live site to: %s and continue...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Remove Backlink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Knowledge Base");
DEFINE('_EW_ADMINHEADER_FLOW', "Flow");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Graphs");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Components");
DEFINE('_EW_ADMINHEADER_REVIEW', "Review");
DEFINE('_EW_ADMINHEADER_WRITE', "Write a ");

DEFINE('_EW_FLOW_TRAFFIC', "Traffic Flow");
DEFINE('_EW_FLOW_SELECT_PAGE', "Select page:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Root outgoing links count:");
DEFINE('_EW_FLOW_NESTING', "Nesting level:");
DEFINE('_EW_FLOW_SCALE', "Scale:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Ad-free version");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Thank you very much for your donation!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Registration key for your domain %s is: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Now you can remove backlink or hide ExtraWatch logo in frontend from Settings ");


DEFINE('_EW_SIZES_LAST_CHECK', "Last check was performed on:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Size of component/module in /administrator directory");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Component");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Total:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Size");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Refresh All");

DEFINE('_EW_SIZEDATABASE_TABLE', "Table");
DEFINE('_EW_SIZEDATABASE_SIZE', "Size");
DEFINE('_EW_SIZEDATABASE_1DAY', "1-Day Change");
DEFINE('_EW_SIZEDATABASE_7DAY', "7-Day Change");
DEFINE('_EW_SIZEDATABASE_28DAY', "28-Day Change");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "no data");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Total:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Refresh All");
DEFINE('_EW_SIZEMODULES_TOTAL', "Total:");
DEFINE('_EW_SIZEMODULES_MODULE', "Module");
DEFINE('_EW_SIZEMODULES_SIZE', "Size");

DEFINE('_EW_SIZES_FILES', "Files &amp; Directories");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Refresh");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");

DEFINE('_EW_DESC_IPINFODB_KEY', "Last visit map ipinfodb.com key from: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Force Timezone Offset");

/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Update");
DEFINE('_EW_MENU_UPDATE_TITLE', "Backup & Upgrade");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Not available in free version, please check the license tab");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Spam Words Ban Enable");
DEFINE('_EW_SPAMWORD_LIST', "Spam Words List");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Hide Repetitive Title");
DEFINE('_EW_TRUNCATE_VISITS', "Truncate Visits");
DEFINE('_EW_TRUNCATE_STATS', "Truncate Stats");
DEFINE('_EW_TRUNCATE_GOALS', "Truncate Goals");
DEFINE('_EW_LIMIT_BOTS', "Limit Bots");
DEFINE('_EW_LIMIT_VISITORS', "Limit Visitors");
DEFINE('_EW_TOOLTIP_WIDTH', "Tooltip Width");
DEFINE('_EW_TOOLTIP_HEIGHT', "Tooltip Height");
DEFINE('_EW_TOOLTIP_URL', "Tooltip URL");
DEFINE('_EW_TOOLTIP_ONCLICK', "Tooltip OnClick");
DEFINE('_EW_IP_STATS', "IP stats");
DEFINE('_EW_IPINFODB_KEY', "IP Info DB key ");
DEFINE('_EW_ONLY_LAST_URI', "Only Last URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Front End Hide Logo ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "Front End No Follow");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Front End no Back Link");
DEFINE('_EW_FRONTEND_USER_LINK', "Front User links");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Front End countries first");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Front End Countries Name");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Front End Countreis Upper case");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Front End Countries Flag First ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Front End Countries Num");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Front End Countries Max Colums");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Front End Countries Max Rows");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Front End Visitors Today ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Front End Visitors Yesterday ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Front End Visitors This week ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Front End Visitors Last week ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Front End Visitors This Month ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Front End Visitors Last Month");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Front End Hide Visitors Total");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Front End Total Initial");
DEFINE('_EW_HISTORY_MAX_VALUES', "History Max Values");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "History Max records");
DEFINE('_EW_UPDATE_TIME_VISITS', "Update Time Visits");
DEFINE('_EW_UPDATE_TIME_STATS', "Update Time stats");
DEFINE('_EW_STATS_MAX_ROWS', "Stats Max rows");
DEFINE('_EW_STATS_IP_HITS', "Stats IP hits");
DEFINE('_EW_MAXID_BOTS', "Max ID bots");
DEFINE('_EW_MAXID_VISITORS', "Maxid Visitors");
DEFINE('_EW_STATS_KEEP_DAYS', "Stats Keep days ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Cache Front End Countries ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Cache Front End Visitors ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Uninstall Keep Data ");
DEFINE('_EW_IGNORE_IP', "Ignore IP");
DEFINE('_EW_IGNORE_URI', "Ignore URI");
DEFINE('_EW_IGNORE_USER', "Ignore User");
DEFINE('_EW_BLOCKING_MESSAGE', "Blocking Message");
DEFINE('_EW_SERVER_URI_KEY', "Server URI key");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Front End Visitors Total Initial");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Records");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " To make the blocking effective, you need to publish ExtraWatch agent BEFORE any content or forms. Eg. on left side in your template.
                    <br/>
                    Go to Module Manager -> ExtraWatch agent -> select position as left");
DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO Reports");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO Nightly email reports enabled");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Watch installation demo");


/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
