<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('নির্দিষ্টদের এলাকা');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "সরাসরি অবস্থান");
DEFINE('_EW_MENU_GOALS', "লক্ষ্যগুলি");
DEFINE('_EW_MENU_SETTINGS', "ব্যবস্থাপনা");
DEFINE('_EW_MENU_CREDITS', "স্বীকৃতি সমূহ");
DEFINE('_EW_MENU_FAQ', "প্রশ্নোত্তর");
DEFINE('_EW_MENU_DOCUMENTATION', "নথিকরণ");
DEFINE('_EW_MENU_LICENSE', "অনুমতি পত্র");
DEFINE('_EW_MENU_DONATORS', "আমাদের অনুশারিরা");
DEFINE('_EW_MENU_SUPPORT', "পেছনের বিজ্ঞাপনগুলি সরানোর জন্য জুমলাওয়াচকে অনুশরন করুন");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "সর্বশেষ পরিদর্শক");
DEFINE('_EW_VISITS_BOTS', "বটসমূহ");
DEFINE('_EW_VISITS_CAME_FROM', "যেখান থেকে এসেছিলেন");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', " আপনার জুমলাওয়াচ মডিউলটি প্রকাশিত হয়নি/ কোন নতুন অবস্থান ধারণ করা হয়নি। প্রকাশ করতে হলে মডিউল বিভাগে প্রবেশ করুন এবং সকল পৃষ্ঠায় এটি প্রকাশ করুন");
DEFINE('_EW_VISITS_PANE_LOADING', "পরিদর্শনের জন্য লোড হচ্ছে। ");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "সপ্তাহের অবস্থানগুলি পরিদর্শন করুন");
DEFINE('_EW_STATS_WEEK', "সপ্তাহ");
DEFINE('_EW_STATS_THIS_WEEK', "বর্তমান সপ্তাহ");
DEFINE('_EW_STATS_UNIQUE', "অনন্য");
DEFINE('_EW_STATS_LOADS', "লোডগুলি");
DEFINE('_EW_STATS_HITS', "হিটগুলি");
DEFINE('_EW_STATS_TODAY', "আজ");
DEFINE('_EW_STATS_FOR', "জন্য");
DEFINE('_EW_STATS_ALL_TIME', "সর্বসময়");
DEFINE('_EW_STATS_EXPAND', "বিস্তৃত করুন");
DEFINE('_EW_STATS_COLLAPSE', "পাতিত করুন");
DEFINE('_EW_STATS_URI', "পৃষ্ঠাগুলি");
DEFINE('_EW_STATS_COUNTRY', "দেশগুলি");
DEFINE('_EW_STATS_USERS', "ব্যবহারকারীরা");
DEFINE('_EW_STATS_REFERERS', "পরিচয় করিয়েছে যারা");
DEFINE('_EW_STATS_IP', "আইপি গুলি");
DEFINE('_EW_STATS_BROWSER', "ব্রাউজারগুলি");
DEFINE('_EW_STATS_OS', "ওএস");
DEFINE('_EW_STATS_KEYWORDS', "মূলশব্দগুলি");
DEFINE('_EW_STATS_GOALS', "লক্ষগুলি");
DEFINE('_EW_STATS_TOTAL', "সর্বমোট");
DEFINE('_EW_STATS_DAILY', "প্রতিদিন");
DEFINE('_EW_STATS_DAILY_TITLE', "প্রতিদিনের অবস্থান");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "সর্বসময়ের অবস্থান");
DEFINE('_EW_STATS_LOADING', "লোড হচ্ছে...");
DEFINE('_EW_STATS_LOADING_WAIT', "লোড হচ্ছে... একটু অপেক্ষা করুন");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "অবরুদ্ধ আইপিগুলি");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "সরাসরি আইপি প্রবেশ করুন");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "অবরুদ্ধ করার জন্য একটি আইপি প্রবেশ করান ( যেমন, 217.242.11.54 or 217.* অথবা 217.242.* এই ওয়াইল্ডকার্ডের সাথে মিলে যায় এমন সকল আইপি বন্ধ করার জন্য)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "আসলেই বন্ধ করার জন্য পরিবর্তন");
DEFINE('_EW_STATS_PANE_LOADING', "অবস্থান গুলি লোড করা হচ্ছে");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "ব্যবস্থাপনা");
DEFINE('_EW_SETTINGS_DEFAULT', "পূর্বাবস্থান");
DEFINE('_EW_SETTINGS_SAVE', "সংরক্ষন করুন");
DEFINE('_EW_SETTINGS_APPEARANCE', "যেভাবে আবির্ভাব");
DEFINE('_EW_SETTINGS_FRONTEND', "সামনের দিক");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "ঘটনাবলি এবং কৃতিত্ব");
DEFINE('_EW_SETTINGS_ADVANCED', "আরো অগ্রগতি");
DEFINE('_EW_SETTINGS_IGNORE', "এড়িয়ে যান");
DEFINE('_EW_SETTINGS_BLOCKING', "অবরুদ্ধ করুন");
DEFINE('_EW_SETTINGS_EXPERT', "বিশেষজ্ঞ");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "আপনি কি আসলেই সকল পরিসংখ্যান এবং পদিদর্শক তথ্য পুনরাস্থাপন করতে চান?");
DEFINE('_EW_SETTINGS_RESET_ALL', "সবকিছু পুনরাস্থাপন করুন");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "সকল পরিসংখ্যান এবং পরিদর্শক তথ্য পুনরাস্থাপন করুন");
DEFINE('_EW_SETTINGS_LANGUAGE', "ভাষা");
DEFINE('_EW_SETTINGS_SAVED', "ব্যবস্থাপনাগুলি সংরক্ষন হলো");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "আপনার আইপি যোগ করুন");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "লিস্টে যান");

// Other / mostly general.
DEFINE('_EW_TITLE', "একটি চলমান-সময়ের এজাক্স জুমলা মনিটর");
DEFINE('_EW_BACK', "পেছনে");
DEFINE('_EW_ACCESS_DENIED', "এটি দেখার জন্য আপনার কোন অনুমতি নেই!");
DEFINE('_EW_LICENSE_AGREE', "উপরের নিয়মকানুন এবং শর্তাগুলি সাথে আমি একমত");
DEFINE('_EW_LICENSE_CONTINUE', "এগিয়ে যান");
DEFINE('_EW_SUCCESS', "সক্রিয়তা সফল হয়েছে");
DEFINE('_EW_RESET_SUCCESS', "সকল পরিসংখ্যান এবং পরিদর্শক তথ্য সফলতার সাথে মুছে গেছে");
DEFINE('_EW_RESET_ERROR', "তথ্য সাফল্যের সাথে মোছা সম্ভব হয়নি, সম্ভ্যবত: কোন কিছু ভুল হয়েছে");
DEFINE('_EW_CREDITS_TITLE', "স্বীকৃতি সমূহ");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "প্রতিদিনের এবং সাপ্তাহিক অবস্থানগুলি");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "এজাক্স আপনাকে অনুমতি দেয়নি; দয়া করে আপনার ডোমেইন এর এই পরিসংখ্যানগুলি ঠিক করে দিন। জুমলা তে configuration.php দেখুন-");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "আপনি হয়তো এইমুহূর্তে আপনার ডোমেইন এর সামনে www. দিতে ভুলে গেছেন। আপনার জাভাস্ক্রিপ্ট প্রবেশকরার চেস্টা করছে");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "থেকে");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "আপনি কিভাবে বুঝলেন যে এটি একটি অন্য ডোমেইন?");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "সর্বশেষ এক্সটেন্সন কোড পেতে হলে যান");
DEFINE('_EW_HEADER_CAST_YOUR', "দয়া করে আপনার");
DEFINE('_EW_HEADER_VOTE', "ভোট");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "টুলটিপ দেখানোর জন্য ক্লিক করুন");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "টুলটিপ দেখানোর জন্য মাউসটি উপরে নিয়ে যান");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "গতকালের অগ্রসরতা");
DEFINE('_EW_TOOLTIP_HELP', "বাইরের আরো অনলাইন সাহায্য পেতে");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "এই উইন্ডোটি বন্ধ করুন");
DEFINE('_EW_TOOLTIP_PRINT', "ছাপান/প্রিন্ট করুন");

// Goals.
DEFINE('_EW_GOALS_INSERT', "নতুন লক্ষ্য প্রবেশ করান");
DEFINE('_EW_GOALS_UPDATE', "লক্ষ্যের নাম্বার আপডেট করুন");
DEFINE('_EW_GOALS_ACTION', "কাজ");
DEFINE('_EW_GOALS_TITLE', "নতুন লক্ষ্যের নাম");
DEFINE('_EW_GOALS_NEW', "নতুন লক্ষ্য");
DEFINE('_EW_GOALS_RELOAD', "পুনরায় লোডকরুন ");
DEFINE('_EW_GOALS_ADVANCED', "আরো অগ্রগতি");
DEFINE('_EW_GOALS_NAME', "নাম");
DEFINE('_EW_GOALS_ID', "আইডি");
DEFINE('_EW_GOALS_URI_CONDITION', "ইউআরআই এর শর্ত");
DEFINE('_EW_GOALS_URI_INVERSED', "ইউআরআই এর উল্টো শর্ত");
DEFINE('_EW_GOALS_GET_VAR', "গেট এর ভ্যারিয়েবল");
DEFINE('_EW_GOALS_GET_CONDITION', "গেট এর শর্ত");
DEFINE('_EW_GOALS_POST_VAR', "পোস্ট ভ্যারিয়েবল");
DEFINE('_EW_GOALS_POST_CONDITION', "পোস্ট এর শর্ত");
DEFINE('_EW_GOALS_TITLE_CONDITION', "টাইটেল এর শর্ত");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "ইউজারনেইম এর শর্ত");
DEFINE('_EW_GOALS_IP_CONDITION', "আইপি এর শর্ত");
DEFINE('_EW_GOALS_IP_INVERSED', "আইপি এর উল্টো শর্ত");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "কেইম ফ্রম এর শর্ত");
DEFINE('_EW_GOALS_BLOCK', "বন্ধ করুন");
DEFINE('_EW_GOALS_REDIRECT', "ইউআরএল এ পুনারায় নিয়ে যান");
DEFINE('_EW_GOALS_HITS', "হিটসংখ্যা");
DEFINE('_EW_GOALS_ENABLED', "সক্রিয়করা হলো");
DEFINE('_EW_GOALS_EDIT', "সম্পাদনা করুন");
DEFINE('_EW_GOALS_DELETE', "মুছে দিন");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "আপনি এই লক্ষ্যের কারণে সাম্প্রতিক সকল পরিসংখ্যান তথ্য হারিয়ে ফেলতে পারেন। আপনি কি আসলেই এই লক্ষ্য সংখ্যাটি মুছতে চান?");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "দেশগুলি");
DEFINE('_EW_FRONTEND_VISITORS', "পরিদর্শকরা");
DEFINE('_EW_FRONTEND_TODAY', "আজ");
DEFINE('_EW_FRONTEND_YESTERDAY', "গতকাল");
DEFINE('_EW_FRONTEND_THIS_WEEK', "এই সপ্তাহ");
DEFINE('_EW_FRONTEND_LAST_WEEK', "গত সপ্তাহ");
DEFINE('_EW_FRONTEND_THIS_MONTH', "এই মাস");
DEFINE('_EW_FRONTEND_LAST_MONTH', "গত মাস");
DEFINE('_EW_FRONTEND_TOTAL', "সর্বমোট");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "জুমলাওয়াচ এখন ডিবাগ মুডে সক্রিয়। এরমাধ্যমে আপনি ভুলের কারণগুলি খুঁজে পেতে পারেন। এটি বন্ধ করতে হলে EXTRAWATCH_DEBUG এর /components/com_extrawatch/config.php  1 থেকে 0 তে পরিবর্তন করুন।");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "সবচেয়ে বড় সারি গুলি দেখা যাবে যখন সব অবস্থানগুলি বিস্তৃত করবেন");
DEFINE('_EW_DESC_STATS_IP_HITS', "গত কয়েকদিনের যেসব আইপি ঠিকানা গুলিতে কম যাওয়া হয়েছে সেগুলি আইপি ইতিহাস থেকে মুছে দেওয়া হবে।");
DEFINE('_EW_DESC_STATS_URL_HITS', "গত কয়েকদিনের যেসব ইউআরএল গুলিতে কম যাওয়া হয়েছে সেগুলি আইপি ইতিহাস থেকে মুছে দেওয়া হবে");
DEFINE('_EW_DESC_IGNORE_IP', " কিছু নির্দিষ্ট অবস্থানের আইপি থেকে। একটি আলাদা লাইন সহ, আপনি এখানকার ওয়াইল্ডকার্ড গুলি ব্যবহার করতে পারবেন.... <br/>যেমন. 192.* এড়িয়ে চলবে 192.168.51.31, 192.168.16.2, ইত্যাদি");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "প্রতি মিলিসেকেন্ড এর যেসকল পরিদর্শকরা পুন:রাবস্থান নিয়েছেন সেই সময়টি, নির্দিষ্ট করা আছে 2000, এই ব্যপারে সাবধাণ থাকুন। এরপর জুমলাওয়াচের পেছনের দিকগুলি পুন:রায় লোড করুন।");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "প্রতি মিলিসেকেন্ড এর যেসকল অবস্থানগুলি পুন:রাবস্থান নিয়েছে সেই সময়টি, নির্দিষ্ট করা আছে 2000, এই ব্যপারে সাবধাণ থাকুন। এরপর জুমলাওয়াচের পেছনের দিকগুলি পুন:রায় লোড করুন।");
DEFINE('_EW_DESC_MAXID_BOTS', "এই ডাটাবেসে কতগুলি বট পরিদর্শন করার অনুমতি রাখা হবে?");
DEFINE('_EW_DESC_MAXID_VISITORS', "এই ডাটাবেসে কতগুলি সত্যিকার পরিদর্শক পরিদর্শন করার অনুমতি রাখা হবে?");
DEFINE('_EW_DESC_LIMIT_BOTS', "আপনি পেছনের ভাগে কতগুলি বট দেখতে চান?");
DEFINE('_EW_DESC_LIMIT_VISITORS', "আপনি পেছনের ভাগে কতগুলি সত্যিকার পরিদর্শক দেখতে চান?");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "সবচেয়ে বেশী যতগুলি অক্ষর পদবী এবং ইউআরএলএ দেখানো হবে");
DEFINE('_EW_DESC_TRUNCATE_STATS', "সবচেয়ে বেশী যতগুলি অক্ষর ডানপাশের পরিসংখ্যান বিভাগে দেখানো হবে");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "পরিসংখ্যান ডাটাবেসে যে দিন গুলি রাখা হবে, 0 = অসীম");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "আপনি যদি আলাদা টাইমজোন থেকে হোন তাহলে আপনার হোস্টকৃত সার্ভারটি। (ঘন্টা হিসাবে যোগকৃত অথবা বিয়োগকৃত সংখ্যা)");
DEFINE('_EW_DESC_WEEK_OFFSET', "সপ্তাহের অফসেট হলো, সময়ছাপ/(৩৬০০*২৪*৭)। ১.১.১৯৭০,থেকে সাপ্তাহিক সংখ্যা দিয়ে, এই অফসেটি টি হলো একটি ভুলসংশোধণ যাতে সপ্তাহের দিন সোমবার থেকে শুরু হয়ে ");
DEFINE('_EW_DESC_DAY_OFFSET', "দিনের অফসেট হলো,  সময় ছাপ/(৩৬০০*২৪) ১.১.১৯৭০ থেকে দিনের সংখ্যা দিয়ে থাকে। এই অফসেটটি হলো একটি ভুল সংশোধণ যাতে এটি ০০:০০ থেকে শুরু হতে পারে");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(প্রো ভার্সনে কাজ করবে)</b> একটি খালি জায়গা রাখা হলো যা,  সামনের ভাগে একটি 1x1px আইকোন দিতে পারে");
DEFINE('_EW_DESC_IP_STATS', "এই আইপি ঠিকানার পরিসংখ্যান চালু করতে।  কিছু কিছু দেশে অনেক সময়ের জন্য আইপি ডাটাবেসে রাখা আইনত নিষিদ্ধ । আপনার নিজস্ব ঝুঁকি নিয়ে ব্যবহার করুন।");
DEFINE('_EW_DESC_HIDE_ADS', "এই ব্যবস্থাপনা পেছনের বিজ্ঞাপনগুলি লুকিয়ে রাখে, যদি এগুলি আপনাকে আসলেই বিরক্ত করে থাক। এগুলি রেখে আপনি আমাদের এই টুলের আরো উন্নয়নের জন্য সহায়তা করছেন। ধন্যবাদ");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "আপনি যদি মাউসক্লিক ছাড়াই মাউস-ওভারের সময় টুলটিপ দেখাতে চান তাহলে 'আনচেক' করুন।");
DEFINE('_EW_DESC_SERVER_URI_KEY', "সাধারণত: 'REDIRECT_URL'ব্যবহার করা হয়, যা কিনা ইউআরএল নতুন ভাবে লেখার জন্য একটি সাধারণ মান, একে 'SCRIPT_URL' দিয়েও সেট করা যায়, যদি এটি শুধুমাত্র index.php তে প্রবেশ করে। ");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "সংক্ষিপ্ত বার্তা, অবরুদ্ধ ব্যবহারকারী বা আরো তথ্যসমগ্র। যেগুলি প্রকাশ করে যে আপনি কেন তাদের কে অবরুদ্ধ করেছেন ");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "টুলটিপের প্রস্থ");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "টুলটিপের দৈর্ঘ্য");
DEFINE('_EW_DESC_TOOLTIP_URL', "আপনি এখানে ইউআরএল রাখতে পারেন, পরিদর্শকের আইপি প্রদর্শন করানোর জন্য। এই {ip} টি পরিদর্শকের আইপি দিয়ে প্রতিস্থাপন হবে. যেমন. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "আপনি এখানে যেকোন আইপি লিখতে পারেন, যেগুলি আপনি এড়িয়ে চলতে চান। আপনি এখানে ওয়াইল্ডকার্ড (* and ?) ব্যবহার করতে পারেন। যেমন,: /freel?n*");
DEFINE('_EW_DESC_GOALS_NAME', "এইস্থানে আপনার লক্ষের নাম ঠিককরুন। এই নামটি আপনার অবস্থায় যুক্ত হবে এবং দেখা যাবে।");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "আপনার ডোমেইন নাম সম্পর্কিত সবরকমের তথ্য।  http://www.codegravity.com/projects/ এর জন্য ইউআরআই হলো : /projects/(উদাহরন সরূপ: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "গেট ভেরিয়েবল হলো এমন একটি ভেরিয়েবল যা কিনা আপনার ইউআরআই সাধারণত একটি ? অথবা &amp; চিহ্নের জন্য ব্যবহার হয়। যেমন, http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. এছাড়াও আপনি <u>*</u> ব্যবহার করতে পারে এই ফিল্ডে যা আপনার সকল গেট মান স্ক্যান করতে ব্যবহার হয়।(উদাহরণসরূপ: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "এখানে আপনি এমন একটি মান ব্যবহার করবেন যা আনার আগের ফিল্ডের মানর মতই। (উদাহরণসরূপ: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "অনেকটাই মিলেছে, কিন্তু আমরা ঐসব মান চাচ্ছি যেগুলি ফর্ম থেকে জমা নেয়া হয়েছে।  তাই আপনার ওয়েবসাইটে যখন একটি ফর্ম থাকবে, যার একটি ফিল্ড আছে &lt;input type='text' name='<u>experiences</u>' /&gt;. (উদাহরণসরূপ: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "পোস্ট ফিল্ড থেকে এইরূপ একটি মান পাওয়া যাবে। যেমন: আমরা জানতে চাচ্ছি,  ব্যবহারকারীর জাভা সম্পর্কে অভিজ্ঞতা আছে। (উদাহরণসরূপ: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "পৃষ্ঠার এমন একটি পদবী থাকবে যা কিনা পূর্বের কোন পদবীর সাথেমিলে যাবে।(উদাহরণসরূপ: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "একজন প্রবেশকৃত ব্যবহারকারীর নাম(উদাহরণসরূপ: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "একজন প্রবেশকৃত ব্যবহারকারীর আইপি: (উদাহরণসরূপ: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "একজন প্রবেশকৃত ব্যবহারকারীর আইপি।(Example to use: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "আপনার ঠিক করা একটি আইপিতে ব্যবহারকারী প্রবেশের পূণনির্দেশ। 'অবরুদ্ধ'দের থেকে তাদের অগ্রাধিকার উচ্চতর: (উদাহরণসরূপ: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "লক্ষের ছক থেকে আপনি কতগুলি অক্ষর ছাঁটাই করবেন");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(প্রো ভার্সনে কাজ করবে)</b> codegravity.com এ একটি পৃষ্ঠসংযোগ, আপনি এটি অকেজো করে দিতে পারেন। তবে আপনি এটি সতেজ রাখার জন্য আমরা আপনার তারিফ করবো। ধন্যবাদ! ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "দেশের সকল অবস্থান সামনের দিকের মডিউলে দেখাবে। যদি পরিবর্তন করা হয়, এই ব্যবস্থাপনা  কাজে লাগবে আপনি যদি সময়েকে CACHE_FRONTEND_ এ সেট করেন।");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', ' আপনি যদি ব্যবহারকারি/দেশের অনুক্রম বিনিময় করতে চান, তাহলে "Uncheck" করুন, এবং এর ফলে প্রথমে পরিদর্শকদের দেখাবে। ');
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "দেশগুলির সংখ্যা সামনের দিকে দেখাবে");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "সামনের দিকের মডিউলে দেশের পরিদর্শকদের দেখাবে। যদি পরিবর্তন করাহয়, তাহলে এটি তখনই পাল্টাবে যখন CACHE_FRONTEND_ এর সময় নির্ধারন করা হবে।  ");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "সময় সেকেন্ড এককে ভান্ডার থেকে দেশের সর্বমোট সময় সামনে নিয়ে আসবে।");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "সময় সেকেন্ড এককে ভান্ডার থেকে পরির্দশকদের তালিকা সামনে নিয়ে আসবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "পরিদর্শকদের সামনে দেখানোর জন্য: আজ। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "পরিদর্শকদের সামনে দেখানোর জন্য: গতকাল। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "পরিদর্শকদের সামনে দেখানোর জন্য: এই সপ্তাহের। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "পরিদর্শকদের সামনে দেখানোর জন্য: গত সপ্তাহের। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "পরিদর্শকদের সামনে দেখানোর জন্য: এই মাসের। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "পরিদর্শকদের সামনে দেখানোর জন্য:গত মাসের। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে।");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "জুমলাওয়াচ ইন্সটলের সময় থেকে সর্বমোট পরিদর্শক সংখ্যা দেখানোর জন্য। যদি পরিবর্তন করা হয়, তাহলে এই ব্যবস্থাপনা সামনে দেখাবে যখন CACHE_FRONTEND_... এ সময় নির্ধারণ করা হবে। ");
DEFINE('_EW_DESC_LANGUAGE', "যে নথিটি ভাষার জন্য ব্যবহার করবেন, এগুলি রাখা আছে /components/com_extrawatch/lang/. আপনি যদি সম্পূর্ণ নতুন একটি ভাষার নথি বানাতে চান, তাহলে প্রথমেই প্রজেক্টের হোমপেইজ চেককরুন এবং যদি সেখানে ভাষার নথিটি না থাকে তাহলে, শুধুমাত্র english.php নথিটি নকল করুন। যেমন, english.php কে germen.php হিসাবে নাম দিন এবং এটিকে এই স্থানে রাখুন। এরপর ডানপাশের সকল প্রয়োজনীয় শব্দগুলির ভাষান্তর করুন।");
DEFINE('_EW_DESC_GOALS', "লক্ষ্য আপনাকে সকল বিশেষ পরামিতি সনাক্ত করতে অনুমতি দিবে। যদি এইসব পরামিতি মিলে যায়, তাহলে লক্ষের গনক বেড়ে যাবে। এই ভাবে আপনি লক্ষ রাখাতে পারবেন যে কোন ব্যবহারকারি কোন নির্দিস্ট ইউআরএল পরিদর্শন করেছেন, অথবা কোন বিশেষ মান পোস্টকরেছেন, যার একটি নির্দিষ্ট ব্যবহাহৃত নাম আছে অথবা কোন নির্দিষ্ট ঠিকানা থেকে এসেছেন। আপনি এছাড়াও নির্দিস্ট কোন ব্যবহারকারিকে অবরুদ্ধ বা অন্যকোন ইউআরএল এর দিকে পুন:র্নির্দেশ দিতে পারবেন। ");
DEFINE('_EW_DESC_GOALS_INSERT', "শুধু নামের ফিল্ড ছাড়া আর সকল ফিল্ডে আপনি * এবং ? ওয়াইল্ডকার্ড হিসাবে ব্যবহার করতে পারবেন।  উদাহরণসরূপ:  ?ear (মিলে যাবে: near, tear, ..)ইত্যাদির সাথে,  p*r (মিলে যাবে: pr, peer, pear ..)ইত্যাদির সাথে। ");
DEFINE('_EW_DESC_GOALS_BLOCK', "1 এ নির্ধারণ করুন, আপনি যদি কোন পরিদর্শককে অবরুদ্ধ করতে চান। তিনি আর বাকি বিষয়বস্তুগুলি দেখতে পাবেন্না, শুধু একটি বার্তা যাবে যে তিনি অবরুদ্ধ হয়েছেন এবং কোন ধরণের নির্দেশ ছাড়াই তাঁর আইপিটি অবরুদ্ধ অবস্থানে চলে যাবে।(উদাহরণসরূপ: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "দেশের শর্তাবলি");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "দেশের জন্য উল্টো শর্তাবলি");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "২-অক্ষরের দেশের কোড (যেমন: <b>BN</b>)");
DEFINE('_EW_STATS_INTERNAL', "ভেতরগত");
DEFINE('_EW_STATS_FROM', "থেকে");
DEFINE('_EW_STATS_TO', "তে");
DEFINE('_EW_STATS_ADD_TO_GOALS', "লক্ষ্যসমূহে যুক্ত করুন");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "এই দেশের জন্য লক্ষ্য যুক্ত করুন।");
DEFINE('_EW_MENU_REPORT_BUG', "ভুল বা বৈশিষ্ট্যের বিবরণ দিন ");
DEFINE('_EW_GOALS_COUNTRY', "দেশ");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "আপনি যদি সামনের দিকে বড়হাতের অক্ষরে দেশের নামগুলি পেতে চান।(যেমন: GERMANY, UNITED KINGDOM instead of Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "সময় সেকেন্ড এককে ভান্ডার থেকে সামনের দিকে ব্যবহারকারিদের নিয়ে আসবে");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "সর্বমোট এর প্রাথমিক মান: সামনের দিকেin frontend. আপনি যখন অন্যান অবস্থার টুল ব্যবহার করবেন তখন দরকার হতে পারে। (যেমন : 20000).  0 তে নির্ধারণ করুন,যদি আপনি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান। .");
DEFINE('_EW_DESC_IGNORE_USER', "এক লাইন করে এই টেক্স্টবক্সের ব্যবহারকারীদের এড়িয়ে চলুন।(যেমন: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "সর্বমোট ব্যবহারকারিদের মধ্যে আজকের সবচেয়ে কার্যকরী ব্যবহারকারী");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "এইসকল বাজেশব্দের উপর নিষেধাজ্ঞা জারি করুন।");
DEFINE('_EW_DESC_SPAMWORD_LIST', "বটদের দ্বার ব্যবহৃত সবচেয়ে বেশি মিলে এমন বাজে শব্দ গুলি। আপনি এখানে ওয়াইল্ডকার্ড ব্যবহার করতে পারবেন। (যেমন: ph?rmac*). যদি এই ব্যবস্থাপনা চালু করা হয়, জুমলাওয়াচ দেখবে যদি কোন আক্রমনকারী কোন HTTP পোস্ট থেকে এই ধরনের কিছু বাজে শব্দ আপনার ওয়েবসাইটে ব্যবহার করছে। (তখনই কাজ করবে যদি ফর্মটি কোন জুমলা দ্বারা তৈরী ওয়েব সাইট থেকে আসে- ফোরাম, কমেন্ট, এবং আরো সংস্ফূর্ত ভাবে কাজ করে যেকোন সম্ভাব্য ফর্ম এর জন্য।");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "বাজে শব্দ-বিরোধী");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "ব্যবহারকারীদের মডিউলের জন্য একটি লিংক- আপনাকে একটি ইউআরএল সনাক্ত করতে অনুমতি দেয়,  এটি খুলে যায় যখন কোন ব্যবহারকারি তার নাম এ ক্লিক করে। অবস্যই {user} স্ট্রিং টি থাকতে হবে, যা কিনা আসল ব্যবহারকারীর নামদ্বার প্রতিস্থাপন হবে। (যেমন index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "মূল বাক্যাংশ");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "ইতিহাস ট্যাবের সর্বোচ্চ মান(যেমন: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "পরিদর্শনগুলিতে শুধু মাত্র শেষ যেই পৃষ্ঠা পরিদর্শনকরা হয়েছে সেগুলি দেখায়, সবগুলি নয়");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "পরিদর্শনগুলিতে যে যে সাইট গুলি বারবার পরিদর্শন করা হয় সেগুলির পদবী পরিদর্শিত পদবীর ছক থেকে লুকিয়ে রাখা হয়।");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "পরিদর্শন ইতিহাসের ডাটাবেসে সবচেয়ে বেশি পরিদর্শকদের সংখ্যা সংরক্ষন করা হয়। এই ব্যবস্থাপনা সম্পর্কে সতর্ক থাকুন। আপনার সাইটে যদি উচ্চতর পরিদর্শক চলাচল থাকে, এটি খুব তাড়াতাড়ি বেড়ে যেতে পারে। সবসময় দেখে রাখুন, অবস্থানের জন্য ইতিহাস ছক কত বেশি তথ্য রাখছে।");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "ডাটাবেস ছকগুলি আনইন্সটলে রাখুন। আপনি যদি কোন আপগ্রেড করতে চান এবং আপনার তথ্য সংরক্ষন করতে চান তাহলে,এই বিকল্পটি দেখে রাখুন");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "আপনি রাতের ই-বার্তাগুলির সাথে গতকালের প্রতিবেদনগুলি পাবেন, যা আপনি সকালে পড়তে পারবেন।");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "সেই ই-বার্তা ঠিকানা যেটিতে আপনি এই প্রতিবেদনগুলি পাবেন।");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "শতাংশর মান যেখানে {value} থেকে উচ্চতর সেখান শুধুমাত্র সারি দেখাবে প্রতিবেদনে। আপনি যদি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান তাহলে ০ তে মান ঠিক করুন।<i>(যেমন: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "শুধু মাত্র<b>একদিন যুক্ত হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মানগুলি {value} এর শতাংশ মান থেকে উচ্চতর হয়।যদি আপনি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান, তাহলে 0 তে মান ঠিক করুন ।<i>(যেমন: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "শুধু মাত্র<b>একদিন বিয়োগ হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মানগুলি {value} এর শতাংশ মান থেকে নিম্নতর হয়। যদি আপনি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান, তাহলে 0 তে মান ঠিক করুন ।<i>(যেমন: -5)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "শুধু মাত্র<b>সাতদিন যুক্ত হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মানগুলি {value} এর শতাংশ মান থেকে উচ্চতর হয়।যদি আপনি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান, তাহলে 0 তে মান ঠিক করুন । <i>(যেমন: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "শুধু মাত্র <b>সাতদিন বিয়োগ হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মান গুলো {value}এর শতাংশ মান থেকে নিন্মতর হয়। এই বৈশিষ্ট্যটি ব্যবহার করতে না চাইলে মান ০ তে ঠিক করুন।<i>(যেমন: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "শুধু মাত্র<b>২০দিন যুক্ত হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মানগুলি {value} এর শতাংশ মান থেকে উচ্চতর হয়।যদি আপনি এই বৈশিষ্ট্যটি ব্যবহার করতে না চান, তাহলে 0 তে মান ঠিক করুন । <i>(যেমন: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "শুধু মাত্র <b>২০দিন বিয়োগ হবে</b> যদি ই-বার্তা প্রতিবেদনের পরিবর্তিত মান গুলো {value}এর শতাংশ মান থেকে নিন্মতর হয়। এই বৈশিষ্ট্যটি ব্যবহার করতে না চাইলে মান ০ তে ঠিক করুন<i>(যেমন: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(প্রো ভার্সনে কাজ করবে)</b> এই ব্যবস্থাপনাটি চালু করুন যদি আপনি লোগো এর লিংক টি attribute rel='nofollow' এর মাধ্যমে বের করতে চান।");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "ই-বার্তাগুলির সারি নামের জন্যে সবচেয়ে বেশি অক্ষর। আপনার ই-বার্তা সেবাপ্রদাণকারির বার্তা উইন্ডোটি যদি অনেক ছোট হয়ে থাকে তাহলে এই মান পরিবর্তন করে ফেলুন।");

DEFINE('_EW_MENU_HISTORY', "ইতিহাস");
DEFINE('_EW_MENU_EMAILS', "ই-বার্তাগুলি");
DEFINE('_EW_MENU_STATUS', "ডিবি অবস্থান");
DEFINE('_EW_DESC_BLOCKED', "স্প্যাম/বাজে শব্দ বিরোধীর মাধ্যমে এই আইপি গুলি অবরুদ্ধ করা হয়েছে।");


DEFINE('_EW_HISTORY_VISITORS', "পরিদর্শকের ইতিহাস");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "শুধুমাত্র  %dটি শেষ তথ্য দেখানো হচ্ছে।
                এর মান পরিবর্তন করতে হলে, Settingsএ যান -&gt; History &amp; Performance -&gt; HISTORY_MAX_DB_RECORDS . সাবধান, this setting affects load times of the data below.এই ব্যবস্থাপনা তৈরী হওয়ার সময়কে প্রভাবিত করতে পারে। ");
DEFINE('_EW_MENU_BUG', "সমস্যার প্রতিবেদন");
DEFINE('_EW_MENU_FEATURE', "বৈশিষ্ট্য অনুরোধ করুন");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "মূলশব্দ");

DEFINE('_EW_BLOCKING_UNBLOCK', "অনবরুদ্ধ");
DEFINE('_EW_STATS_KEYPHRASE ', "মূল বাক্যাংশগুলি");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "ছকের নাম");
DEFINE('_EW_STATUS_DATABASE_ROWS', "সারিগুলি");
DEFINE('_EW_STATUS_DATABASE_DATA', "তথ্য");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "সব্যমোট");

DEFINE('_EW_EMAIL_REPORTS', "ই-বার্তা প্রতিবেদন");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "গতকালের ই-বার্তা থেকে পরিস্রুত প্রতিবেদন");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "ই-বার্তার মান পরিস্রবণ");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "মান");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "শতাংশ");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "১দিনের পরিবর্তন");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "৭দিনের পরিবর্তন");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "২৮দিনের পরিবর্তন");
DEFINE('_EW_ANTISPAM_BLOCKED', "জুমলাওয়াচ %dটি স্প্যামার হিট অবরুদ্ধ করেছে , সর্বমোট: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "অবরুদ্ধ আইপি ঠিকানা");
DEFINE('_EW_ANTISPAM_SETTINGS', "স্প্যাম বিরোধী ব্যবস্থাপনা");
DEFINE('_EW_TRAFFIC_AJAX', "এজাক্স এর ট্রাফিক আপডেট (মানচিত্র ছাড়া)");


DEFINE('_EW_HISTORY_PREVIOUS', "পুরোনো");
DEFINE('_EW_HISTORY_NEXT', "পরে");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "দেশগুলির কলাম সংখ্যা");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "দেশগুলির সারি সংখ্যা");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "দেশের নাম দেখাবে অথবা দেখাবেনা");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "আগে পতাকা দেখাবে ,তারপর শতাংশ");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "গেট এর উল্টো শর্তগুলি");
DEFINE('_EW_GOALS_POST_INVERSED', "পোস্ট এর উল্টো শর্তগুলি");
DEFINE('_EW_GOALS_TITLE_INVERSED', "টাইটেল এর উল্টো শর্তগুলি");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "ইউজারনেইম উল্টো শর্তগুলি");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "কেইম ফ্রম এর উল্টো শর্তগুলি");

DEFINE('_EW_STATS_MAP', "সর্বশেষ পরিদর্শন মানচিত্র");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "দয়া করে প্রবেশ করান <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> শেষ মানচিত্র দেখানোর চাবি:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "চাবি সংরক্ষন করুন");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "দয়া করে বৈধ ipinfodb চাবি দেখান যেগুলো নেয়া হয়েছে : <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> থেকে");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "মন্দ অনুরোধ:  ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "যেই ফিল্ডগুলো থেকে নেয়া:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "ইউআরএল পরামিতি:");
DEFINE('_EW_VISIT_ADD_PAGE', " লক্ষ্যহিসাবে পৃষ্ঠা যোগ করুন");
DEFINE('_EW_VISIT_BLOCK_IP', " এই আইপি ঠিকানাটি অবরোধ করুন।");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', "এই ফর্ম ভেরিয়েবলটি লক্ষ্য হিসাবে যোগ করুন");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', "এই ইউআরএল পরামিতিটি লক্ষ্য হিসাবে যোগ করুন");

DEFINE('_EW_TREND_EMPTY', "খালি");

DEFINE('_EW_NOT_NUMBER', " সতর্কীকরণ: যে মানটি আপনি প্রবেশ করিয়েছেন তা কোন সংখ্যা নয়। জুমলাওয়াচ ঠিক মতো কাজ করবেনা!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; এটি ১৫ দিনের মূল্যায়ন সংস্করণ। আর বাকি রয়েছে: <b>%d</b>দিন। অনুগ্রহপূর্বক আজীবন সংস্করণ টি ক্রয় করুন <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch license for your domain</a> এই ভার্সনের জন্য এবং আগামী ভার্সনের জন্য");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " আপনার পরীক্ষা সংস্করণের মেয়াদপূর্তী হয়েছে। দয়া করে জুমলাওয়াচ ক্রয় করুন।");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "অনুমতিপত্র সাফল্যের সাথে চালু হয়েছে! ধন্যবাদ");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>ভুল!!: আপনার অনমতিপত্রের চাবি এবং ডোমেইন মিলছেনা</b><br/>আপনি ডোনেশন ফর্মে প্রদত্ত আপনার একই ডোমেইন টি দেখতে পাচ্ছেন?মূল চালুকরণ চাবির জন্য<b>' নিচে ক্লিক করুন '</b> <br/>অথবা যোগাযোগ করুন: info@codegravity.com<br/>এ");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "আপনি যদি উপরের বার্তাটি অনেক্ষন ধরে দেখতে থাকেন, তাহলে বুঝতে হবে আপনার লাইভ সাইটটি হয়তো সমস্যা করছে।
                    এটি খুলুন components/com_extrawatch/config.php
                    কমেন্ট উঠিয়ে দিন, এবং আপনার নিজস্ব সাইটটি প্রবেশ করান. যেমন:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "সতর্কীকরণ: আপনার ব্রাউজারের সাইটটি এবং আপনার লাইভ সাইট এর কনফিগারেশন: %s এবং %s মিলছেনা!! ");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "লাইভ সাইটটিকে সক্রিয় করুন: %s এবং চালিয়ে যান...");

DEFINE('_EW_ADMINHEADER_JW', "জুমলাওয়াচ ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "পেছনের লিংক গুলি মুছে ফেলুন");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "জ্ঞানকোষ");
DEFINE('_EW_ADMINHEADER_FLOW', "প্রবাহ");
DEFINE('_EW_ADMINHEADER_GRAPHS', "গ্রাফগুলি");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "উপাদানগুলি");
DEFINE('_EW_ADMINHEADER_REVIEW', "পর্যালোচনা");
DEFINE('_EW_ADMINHEADER_WRITE', "লিখুন ");

DEFINE('_EW_FLOW_TRAFFIC', "ট্রাফিক প্রবাহ");
DEFINE('_EW_FLOW_SELECT_PAGE', "পৃষ্ঠা নির্বাচন করুন:");
DEFINE('_EW_FLOW_OUTG_LINKS', "মূল বহির্গামী লিংক গণনা:");
DEFINE('_EW_FLOW_NESTING', "নীড়ের স্তর:");
DEFINE('_EW_FLOW_SCALE', "মাপদন্ড:");

DEFINE('_EW_COMERCIAL_AD_FREE', "বিজ্ঞাপণ মুক্ত ভার্সন");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "আপনার ডোনেশনের জন্য ধন্যবাদ!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "আপনার ডোমেইন এর নিবন্ধন চাবি হলো %s: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "এখন আপনি পেছনের লিংক মুছতে পারবেন অথবা ব্যবস্থাপনার সামনে থেকে জুমলাওয়াচের লোগোটি লুকিয়ে ফেলতে পারবেন");


DEFINE('_EW_SIZES_LAST_CHECK', "সর্বশেষ নিরীক্ষা চালানো হয়েছিলো.. :");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Size of component/module in /administrator directory");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "উপাদান");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "সর্বমোট:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "আকার");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "সবকিছু রিফ্রেশ করুন");

DEFINE('_EW_SIZEDATABASE_TABLE', "ছক");
DEFINE('_EW_SIZEDATABASE_SIZE', "আকার");
DEFINE('_EW_SIZEDATABASE_1DAY', "১দিনের পরিবর্তন");
DEFINE('_EW_SIZEDATABASE_7DAY', "৭দিনের পরিবর্তন");
DEFINE('_EW_SIZEDATABASE_28DAY', "২৮দিনের পরিবর্তন");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "কোন তথ্য নেই");
DEFINE('_EW_SIZEDATABASE_TOTAL', "সর্বমোট:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "সবকিছু রিফ্রেশ করুন");
DEFINE('_EW_SIZEMODULES_TOTAL', "সর্বমোট:");
DEFINE('_EW_SIZEMODULES_MODULE', "মডিউল");
DEFINE('_EW_SIZEMODULES_SIZE', "আকার");

DEFINE('_EW_SIZES_FILES', "নথি এবং নির্দেশিকাগুলি");
DEFINE('_EW_SIZES_BYTES', "বাইট গুলো");
DEFINE('_EW_SIZES_KB', "কেবি");
DEFINE('_EW_SIZES_MB', "এমবি");
DEFINE('_EW_SIZES_GB', "জিবি");
DEFINE('_EW_SIZES_REFRESH', "রিফ্রেশ");

DEFINE('_EW_STATS_FOOTER', "জুমলাওয়াচ &copy;2006-@YEAR@ মাতিজ কোভাল এর মাধ্যমে।");

DEFINE('_EW_STATUS_MB', "এমবি");
DEFINE('_EW_STATUS_DATABASE', "ডাটাবেসের ছকের আকার");


DEFINE('_EW_DESC_IPINFODB_KEY', "সর্বশেষ পরির্দশন মানচিত্র ipinfodb.com এর চাবি থেকে : <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "টাইমজোনের অফসেট ফোর্স করুন");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "আপডেট করুন");
DEFINE('_EW_MENU_UPDATE_TITLE', "ব্যাকআপ সংরক্ষন এবং আপগ্রেড করুন ");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "মুক্ত ভার্সনে পাওয়া যায়না, অনুগ্রহ করে অনুমতিপত্রের ট্যাবে দেখেনিন।");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "স্পাম-শব্দের নিষেধাজ্ঞা চালু");
DEFINE('_EW_SPAMWORD_LIST', "স্প্যাম-শব্দের তালিকা");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "বারবার আসা পদবীগুলি লুকিয়ে রাখুন");
DEFINE('_EW_TRUNCATE_VISITS', "পরিদর্শন ছাঁটাই করুন");
DEFINE('_EW_TRUNCATE_STATS', "অবস্থান ছাঁটাই করুন");
DEFINE('_EW_TRUNCATE_GOALS', "লক্ষ্য ছাঁটাই করুন");
DEFINE('_EW_LIMIT_BOTS', "বটগুলি সীমাবদ্ধ করুন");
DEFINE('_EW_LIMIT_VISITORS', "পরিদর্শক সীমাবদ্ধ করুন");
DEFINE('_EW_TOOLTIP_WIDTH', "টুলটিপের প্রস্থ");
DEFINE('_EW_TOOLTIP_HEIGHT', "টুলটিপের উচ্চতা");
DEFINE('_EW_TOOLTIP_URL', "টুলটিপের ইউআরএল");
DEFINE('_EW_TOOLTIP_ONCLICK', "ক্লিকের সময় টুলটিপ");
DEFINE('_EW_IP_STATS', "আইপ অবস্থান");
DEFINE('_EW_IPINFODB_KEY', "আইপি এর তথ্য এবং ডিবি চাবি ");
DEFINE('_EW_ONLY_LAST_URI', "মাত্র শেষ ইউআরআই ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "ফ্রন্ট এন্ড লোগো লুকান");
DEFINE('_EW_FRONTEND_NOFOLLOW', "ফ্রন্ট এন্ড কোন অনুশরন নয়");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "ফ্রন্ট এন্ড কোন ব্যাকলিংক থাকবেনা");
DEFINE('_EW_FRONTEND_USER_LINK', "ফ্রন্ট এন্ড সারির ব্যবহারকারীদের লিংক");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "ফ্রন্ট এন্ড দেশগুলি আগে");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "ফ্রন্ট এন্ড দেশগুলির নাম");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "ফ্রন্ট এন্ড দেশগুলির নাম বড় হাতে অক্ষরে");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "ফ্রন্ট এন্ড দেশগুলিরপতাকা আগে ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "ফ্রন্ট এন্ড দেশগুলির সংখ্যা");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "ফ্রন্ট এন্ড দেশগুলির সবচেয়ে বড় কলাম");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "ফ্রন্ট এন্ড এর দেশগুলি সবচেয়ে বড় সারি");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "ফ্রন্ট এন্ড এ পরিদর্শকদের ইতিহাস ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "ফ্রন্ট এন্ড এ গতকালে পরিদর্শকরা");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "ফ্রন্ট এন্ড এ এই সপ্তাহের পরিদর্শকরা");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "ফ্রন্ট এন্ড এ গত সপ্তাহের পরিদর্শকরা");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "ফ্রন্ট এন্ড এ এই মাসের পরিদর্শকরা");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "ফ্রন্ট এন্ড এ গত মাসের পরিদর্শকরা");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "ফ্রন্ট এন্ড এ সর্বমোট পরিদর্শক সংখ্যা লুকানো");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "ফ্রন্ট এন্ড এ সর্বমোট প্রাথমিক পরিদর্শক");
DEFINE('_EW_HISTORY_MAX_VALUES', "ইতিহাসের সবচেয়ে বেশি মান");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "ইতিহাসের সর্বোচ্চ সংরক্ষন ক্ষমতা");
DEFINE('_EW_UPDATE_TIME_VISITS', "পরিদর্শনের সময় আপডেট করুন");
DEFINE('_EW_UPDATE_TIME_STATS', "অবস্থানের সময় আপডেট করুন");
DEFINE('_EW_STATS_MAX_ROWS', "অবস্থানের সর্বোচ্চ সারি");
DEFINE('_EW_STATS_IP_HITS', "অবস্থানের সর্বোচ্চ হিট সংখ্যা");
DEFINE('_EW_MAXID_BOTS', "সর্বোচ্চ বটগুলির আইডি");
DEFINE('_EW_MAXID_VISITORS', "সর্বোচ্চ পরিদর্শকের আইডি");
DEFINE('_EW_STATS_KEEP_DAYS', "যতদিন ধরে অবস্থান টি রাখা");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "ভান্ডার ফ্রন্ট এন্ড এ দেশগুলি ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "ভান্ডার ফ্রন্ট এন্ড এ পরিদর্শকরা");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "আনইন্স্টলের পর রেখে দেয়া তথ্য গুলো ");
DEFINE('_EW_IGNORE_IP', "আইপি এড়িয়ে চলুন");
DEFINE('_EW_IGNORE_URI', "ইউআরআই এড়িয়ে চলুন");
DEFINE('_EW_IGNORE_USER', "ব্যবহারকারি এড়িয়ে চলুন");
DEFINE('_EW_BLOCKING_MESSAGE', "বার্তা অবরূদ্ধ করুন");
DEFINE('_EW_SERVER_URI_KEY', "সার্ভারের ইউআরআই চাবি");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "ফ্রন্ট এন্ড এ পরিদর্শকদের প্রাথমিক সকল নাম");
DEFINE('_EW_SIZEDATABASE_RECORDS', "ধারণকৃত তথ্যগুলি");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', "অবরোধকে কাজে লাগাতে হলে আপনাকে জুমলাওয়াচের এজেন্টে কে সকল তথ্য অথবা ফর্ম এর আগে প্রকাশ করতে হবে। যেমন: আপনার টেম্প্লেটের বাম পাশে
                    <br/>
                    আপনি এখন module manager এ যান -> ExtraWatch agent গিয়ে -> select position as left করুন");

DEFINE('_EW_EMAIL_SEO_REPORTS', "এস ই ও এর প্রতিবেদন");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "এস ই ও এর রাতের ই-বার্তা প্রতিবেদন চালু");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "ইন্সটলেশনের উদাহরণ দেখুন");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");

/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");


DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
