<?php

/*
 * @version		$Id: yendifvideoshare.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Access check: is this user allowed to access the backend of this component?
if( ! JFactory::getUser()->authorise( 'core.manage', 'com_yendifvideoshare' ) ) {
	return JError::raiseWarning( 404, JText::_('JERROR_ALERTNOAUTHOR' ) );
}

// Define constants for all pages
if( ! defined('DS') ) define('DS',DIRECTORY_SEPARATOR);
define('YENDIF_VIDEO_SHARE_UPLOAD_DIR', 'media'.DS.'yendifvideoshare'.DS);
define('YENDIF_VIDEO_SHARE_UPLOAD_BASE', JPATH_ROOT.DS.YENDIF_VIDEO_SHARE_UPLOAD_DIR);
define('YENDIF_VIDEO_SHARE_UPLOAD_BASEURL', JURI::root().str_replace(DS, '/', YENDIF_VIDEO_SHARE_UPLOAD_DIR));
define('YENDIF_VIDEO_SHARE_USERID', JFactory::getUser()->get('id'));

// Register Libraries
JLoader::register('YendifVideoShareController', JPATH_COMPONENT.'/controllers/controller.php');
JLoader::register('YendifVideoShareModel', JPATH_COMPONENT.'/models/model.php');
JLoader::register('YendifVideoShareView', JPATH_COMPONENT.'/views/view.php');
JLoader::register('YendifVideoShareFields', JPATH_COMPONENT.'/libraries/fields.php');
JLoader::register('YendifVideoShareUpload', JPATH_COMPONENT.'/libraries/upload.php');
JLoader::register('YendifVideoShareUtils', JPATH_COMPONENT.'/libraries/utils.php');

// CSS
$document = JFactory::getDocument();
$document->addStyleSheet( JURI::root().'/media/yendifvideoshare/assets/admin/css/yendifvideoshare.css?v=1.2.5' );

// Require the base controller
$view = JRequest::getCmd('view', 'dashboard');
?>

<?php if( $view !== 'upload' ) : ?>
  <div class="alert alert-danger">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
    <strong>NOTE!</strong> You're using the Yendif Video Share - FREE version. Upgrade to our <a href="http://yendifplayer.com/joomla-video-share-download.html" target="_blank">PRO Version</a> and get access to all our pro features, receive updates & get lifetime support.
  </div>
<?php endif; ?>

<?php
$controller = JString::strtolower( $view );
require_once JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';

// Initialize the controller
$obj = 'YendifVideoShareController'.$controller;
$controller = new $obj();

// Perform the Request task
$controller->execute( JRequest::getCmd('task', $view) );
$controller->redirect();