<?php

/*
 * @version		$Id: default.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access'); ?>

<fieldset class="form-horizontal">
    <div class="control-group">
    	<label class="control-label" for="jquery"><?php echo JText::_('YENDIF_VIDEO_SHARE_JQUERY_HANDLING'); ?></label>
    	<div class="controls">
        	<?php
            	echo YendifVideoShareFields::ListItems(
					'jquery',
					array(
						'none'   => JText::_('YENDIF_VIDEO_SHARE_NONE'),
						'local'  => JText::_('YENDIF_VIDEO_SHARE_LOCAL'),
						'remote' => JText::_('YENDIF_VIDEO_SHARE_REMOTE')
					),							
					$this->item->jquery
				);
			?>
        	<span class="help-inline text-danger"><?php echo JText::_('YENDIF_VIDEO_SHARE_JQUERY_HANDLING_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="ratio"><?php echo JText::_('YENDIF_VIDEO_SHARE_RATIO'); ?></label>
    	<div class="controls">
        	<input type="text" name="ratio" id="ratio" value="<?php echo $this->item->ratio; ?>" />
      		<p class="help-block"><?php echo JText::_('YENDIF_VIDEO_SHARE_RATIO_DESCRIPTION'); ?></p>
      		<ul>
        		<li><strong>0.5625</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_WIDE_SCREEN_TV'); ?></li>
        		<li><strong>0.625</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_MONITOR_SCREENS'); ?></li>
        		<li><strong>0.75</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_CLASSIC_TV'); ?></li>
        		<li><strong>0.67</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_PHOTO_CAMERA'); ?></li>
        		<li><strong>1</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_SQUARE'); ?></li>
        		<li><strong>0.417</strong> - <?php echo JText::_('YENDIF_VIDEO_SHARE_CINEMASCOPE'); ?></li>
      		</ul>
    	</div>
  	</div>
</fieldset>

<fieldset class="form-horizontal">
	<legend><?php echo JText::_('YENDIF_VIDEO_SHARE_SKIN_SETTINGS'); ?></legend>
    
    <div class="control-group">
    	<label class="control-label" for="theme"><?php echo JText::_('YENDIF_VIDEO_SHARE_THEME'); ?></label>
    	<div class="controls">
        	<?php
            	echo YendifVideoShareFields::ListItems(
					'theme',
					array(
						'black' => JText::_('YENDIF_VIDEO_SHARE_BLACK'),
						'white' => JText::_('YENDIF_VIDEO_SHARE_WHITE')
					),							
					$this->item->theme
				);
			?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_THEME_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="controlbar"><?php echo JText::_('YENDIF_VIDEO_SHARE_CONTROLBAR'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('controlbar', $this->item->controlbar); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_CONTROLBAR_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playbtn"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAY_BUTTON'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('playbtn', $this->item->playbtn); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAY_BUTTON_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playpause"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYPAUSE'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('playpause', $this->item->playpause); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYPAUSE_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="currenttime"><?php echo JText::_('YENDIF_VIDEO_SHARE_CURRENTTIME'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('currenttime', $this->item->currenttime); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_CURRENTTIME_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="progress"><?php echo JText::_('YENDIF_VIDEO_SHARE_PROGRESS'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('progress', $this->item->progress); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PROGRESS_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="duration"><?php echo JText::_('YENDIF_VIDEO_SHARE_DURATION'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('duration', $this->item->duration); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_CONTROLBAR_DURATION_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="volumebtn"><?php echo JText::_('YENDIF_VIDEO_SHARE_VOLUME_BUTTON'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('volumebtn', $this->item->volumebtn); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_VOLUME_BUTTON_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="fullscreen"><?php echo JText::_('YENDIF_VIDEO_SHARE_FULLSCREEN'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('fullscreen', $this->item->fullscreen); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_FULLSCREEN_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="embed"><?php echo JText::_('YENDIF_VIDEO_SHARE_EMBED'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('embed', $this->item->embed); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_EMBED_DESCRIPTION'); ?></span>
    	</div>
  	</div>
</fieldset>

<fieldset class="form-horizontal">
	<legend><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYBACK_SETTINGS'); ?></legend>
    
    <div class="control-group">
    	<label class="control-label" for="engine"><?php echo JText::_('YENDIF_VIDEO_SHARE_ENGINE'); ?></label>
    	<div class="controls">
        	<?php
            	echo YendifVideoShareFields::ListItems(
					'engine',
					array(
						'html5' => JText::_('YENDIF_VIDEO_SHARE_HTML5'),
						'flash' => JText::_('YENDIF_VIDEO_SHARE_FLASH')
					),							
					$this->item->engine
				);
			?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_ENGINE_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="volume"><?php echo JText::_('YENDIF_VIDEO_SHARE_VOLUME'); ?></label>
    	<div class="controls">
        	<input type="text" name="volume" id="volume" value="<?php echo $this->item->volume; ?>" />
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_VOLUME_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="autoplay"><?php echo JText::_('YENDIF_VIDEO_SHARE_AUTOPLAY'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('autoplay', $this->item->autoplay); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_AUTOPLAY_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="loop"><?php echo JText::_('YENDIF_VIDEO_SHARE_LOOP'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('loop', $this->item->loop); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_LOOP_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="keyboard"><?php echo JText::_('YENDIF_VIDEO_SHARE_KEYBOARD'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('keyboard', $this->item->keyboard); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_KEYBOARD_DESCRIPTION'); ?></span>
    	</div>
  	</div>
</fieldset>

<fieldset class="form-horizontal">
	<legend><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_SETTINGS'); ?></legend>
    
    <div class="control-group">
    	<label class="control-label" for="playlist_position"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_POSITION'); ?></label>
    	<div class="controls">
        	<?php
            	echo YendifVideoShareFields::ListItems(
					'playlist_position',
					array(
						'right'  => JText::_('YENDIF_VIDEO_SHARE_RIGHT'),
						'bottom' => JText::_('YENDIF_VIDEO_SHARE_BOTTOM')
					),							
					$this->item->playlist_position
				);
			?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_POSITION_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playlist_width"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_WIDTH'); ?></label>
    	<div class="controls">
        	<input type="text" name="playlist_width" id="playlist_width" value="<?php echo $this->item->playlist_width; ?>" />
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_WIDTH_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playlist_height"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_HEIGHT'); ?></label>
    	<div class="controls">
        	<input type="text" name="playlist_height" id="playlist_height" value="<?php echo $this->item->playlist_height; ?>" />
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_HEIGHT_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playlist_title_limit"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_TITLE_LIMIT'); ?></label>
    	<div class="controls">
        	<input type="text" name="playlist_title_limit" id="playlist_title_limit" value="<?php echo $this->item->playlist_title_limit; ?>" />
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_TITLE_LIMIT_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="playlist_desc_limit"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_DESCRIPTION_LIMIT'); ?></label>
    	<div class="controls">
        	<input type="text" name="playlist_desc_limit" id="playlist_desc_limit" value="<?php echo $this->item->playlist_desc_limit; ?>" />
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_PLAYLIST_DESCRIPTION_LIMIT_DESCRIPTION'); ?></span>
    	</div>
  	</div>
    
    <div class="control-group">
    	<label class="control-label" for="autoplaylist"><?php echo JText::_('YENDIF_VIDEO_SHARE_AUTOPLAYLIST'); ?></label>
    	<div class="controls">
        	<?php echo YendifVideoShareFields::ListBoolean('autoplaylist', $this->item->autoplaylist); ?>
        	<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_AUTOPLAYLIST_DESCRIPTION'); ?></span>
    	</div>
  	</div>
</fieldset>

<fieldset class="form-horizontal">
	<legend><?php echo JText::_('YENDIF_VIDEO_SHARE_GOOGLE_ANALYTICS'); ?></legend>
    
    <div class="control-group">
    	<label class="control-label" for="analytics"><?php echo JText::_('YENDIF_VIDEO_SHARE_ANALYTICS_CODE'); ?></label>
    	<div class="controls">
        	<input type="text" name="analytics" id="analytics" value="<?php echo $this->item->analytics; ?>" />
      		<span class="help-inline"><?php echo JText::_('YENDIF_VIDEO_SHARE_ANALYTICS_CODE_DESCRIPTION'); ?></span>
    	</div>
  	</div>
</fieldset>