<?php

/*
 * @version		$Id: config.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class YendifVideoShareModelConfig extends YendifVideoShareModel {
	
	function getItem() {
        $db  = JFactory::getDBO();
        $query = "SELECT * FROM #__yendifvideoshare_config WHERE id=1";
        $db->setQuery( $query );
        $item = $db->loadObject();
		 
        return $item;
	}
	
	function save() {
	  	$app = JFactory::getApplication();
	  	$row = JTable::getInstance('Config', 'YendifVideoShareTable');
	  	$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
      	$id = $cid[0];
      	$row->load($id);

      	if( ! $row->bind( JRequest::get('post') ) ) {
			JError::raiseError( 500, $row->getError() );
	  	}

		$row->responsive_css = JRequest::getVar('responsive_css', '', 'post', 'string', JREQUEST_ALLOWRAW);
	  	$row->share_script = JRequest::getVar('share_script', '', 'post', 'string', JREQUEST_ALLOWRAW);
		$row->license = JRequest::getVar('license', '', 'post', 'string', JREQUEST_ALLOWRAW);

		if( ! $row->sef_cat ) {
			$row->sef_cat = 'category';
		}
		
		if( ! $row->sef_video_prefix ) {
			$row->sef_video_prefix = 'video';
		}
		
		if( ! $row->feed_limit || $row->feed_limit == 0 ) {
			$row->feed_limit = 5;
		}
		
		$replacement = array('-','/',',','_','|','&',' ');
		$row->sef_cat = str_replace($replacement, "", $row->sef_cat);
		$row->sef_video_prefix = str_replace($replacement, "", $row->sef_video_prefix);
		
	  	if( ! $row->store() ) {
			JError::raiseError(500, $row->getError() );
	  	}

      	$msg = JText::_('YENDIF_VIDEO_SHARE_CHANGES_SAVED');
      	$link = 'index.php?option=com_yendifvideoshare&view=config';
  
	  	$app->redirect($link, $msg, 'message');
	}
	
}