<?php

/*
 * @version		$Id: player.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import libraries
require_once( JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_yendifvideoshare'.DS.'libraries'.DS.'utils.php' );

class YendifVideoSharePlayer {	
	
	private $config = null;
	
	private $players = 0;
	
	private $types = array(
		'custom'  => array( 'mp4', 'webm', 'ogg', 'youtube', 'rtmp', 'flash', 'captions' ),
		'video'   => array( 'mp4', 'webm', 'ogg', 'captions' ),
		'youtube' => array( 'youtube', 'captions' ),		
		'rtmp'    => array( 'mp4', 'rtmp', 'flash', 'captions' )
	);
	
	private $properties = array(
		'autoplay',
		'analytics',
		'autoplaylist',
		'can_skip_adverts',
		'controlbar',
		'currenttime',
		'download',
		'duration',
		'embed',
		'engine',
		'fullscreen',
		'keyboard',
		'license',
		'logo',
		'loop',
		'playbtn',
		'playlist_height',
		'playlist_position',
		'playlist_width',
		'playpause',
		'progress',		
		'ratio',
		'share',
		'show_adverts_timeframe',
		'show_skip_adverts_on',
		'theme',
		'volume',
		'volumebtn',
		'hd'		
	);   
	
	protected static $instance = null;
	
	public $width = -1;
	
	public $height = -1;

    function __construct( $config = null ) {
		$this->config = $config == null ? YendifVideoShareUtils::getConfig() : $config;
		$this->width = $this->height = '100%';
		$this->addScript();
    }
	
	public static function getInstance( $config = null ) {
		if( null == self::$instance ) {
			self::$instance = new self( $config );
		}

		return self::$instance;
	}
	
	function addScript() {		 
		$document = JFactory::getDocument();
		
		$document->addStyleSheet( JURI::root()."media/yendifvideoshare/assets/site/css/yendifvideoshare.css?v=1.2.5", 'text/css', "screen" );
		$document->addStyleSheet( JURI::root()."media/yendifvideoshare/player/yendifplayer.css?v=1.2.5", 'text/css', "screen" );
		if( ! empty( $this->config->responsive_css ) ) $document->addStyleDeclaration( $this->config->responsive_css );		

		JHtml::_('jquery.framework');
		$document->addScript( JURI::root()."media/yendifvideoshare/player/yendifplayer.js?v=1.2.5" );
			
		$config = array();
		
		foreach( $this->properties as $property ) {
			if( isset( $this->config->$property ) ) {
				$value = $this->config->$property;
				$config[ $property ] = is_numeric( $value ) && $property != 'ratio' ? (int) $value : $value;
			}
		}
		
		$config['responsive']       = 1;
		$config['playlistWidth']    = $config['playlist_width'];
		$config['playlistHeight']   = $config['playlist_height'];
		$config['playlistPosition'] = $config['playlist_position'];
		$config['volume']           = $config['volume'] / 100;
		$config['origin']           = JURI::root();
		$config['download']         = 0;
		$config['share']            = 0;
		
		unset( $config['playlist_width'], $config['playlist_height'],  $config['playlist_position'] );	
		
		$document->addScriptDeclaration('yendifplayer.config = ' . json_encode( $config ) . ';');
	}

	function embedPlayer( $params ) {
		$html  = '<!DOCTYPE html>';
		$html .= '<html>';
		$html .= '<head>';
		$html .= '<link rel="stylesheet" href="'.JURI::root().'media/yendifvideoshare/player/yendifplayer.css"/>';
		$html .= '<link rel="stylesheet" href="'.JURI::root().'media/yendifvideoshare/assets/site/css/yendifvideoshare.css"/>';
		if( $this->config->jquery == 'local' ) {
			$html .= '<script src="'.JURI::root().'media/yendifvideoshare/player/jquery.min.js" type="text/javascript"></script>';			
		} else {
			$html .= '<script src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js" type="text/javascript"></script>';
		};
		$html .= '<script src="'.JURI::root().'media/yendifvideoshare/player/yendifplayer.js" type="text/javascript"></script>';
		$html .= '<style type="text/css">body, iframe{ margin:0 !important; padding:0 !important; background:transparent !important; }</style>';
		
		$config = array();
		
		foreach( $this->properties as $property ) {
			if( isset( $this->config->$property ) ) {
				$value = $this->config->$property;
				$config[ $property ] = is_numeric( $value ) && $property != 'ratio' ? (int) $value : $value;
			}
		}
		
		$config['responsive']       = 1;
		$config['playlistWidth']    = $config['playlist_width'];
		$config['playlistHeight']   = $config['playlist_height'];
		$config['playlistPosition'] = $config['playlist_position'];
		$config['volume']           = $config['volume'] / 100;
		$config['origin']           = JURI::root();
		$config['download']         = 0;
		$config['share']            = 0;
		
		unset( $config['playlist_width'], $config['playlist_height'],  $config['playlist_position'] );	
		
		$playerObj = $this->singlePlayer( $params, '', true );
		
		$html .= '<script type="text/javascript">';
		$html .= 'yendifplayer.config = ' . json_encode( $config ) . ';';
		$html .= '$(document).ready(function(){
    				$(".yendifplayer").css({height:$(window).height(), width:$(window).width()});
					' . ( is_array( $playerObj ) ? $playerObj[0] : '' ) . '
				  });';
		$html .= '</script>';
		$html .= '</head>';
		$html .= '<body>';
		$html .= is_array( $playerObj ) ? $playerObj[1] : $playerObj;
		$html .= '</body>';
		$html .= '</html>';
		
		return $html;
	}
	
	function singlePlayer( $params, $item = null, $is_embed = false ) {
		++$this->players;
		
		if( ! isset( $params['videoid' ] ) && $item == null ) return;
		
		$db = JFactory::getDBO();
		
		$vid_attrs  = ' controls';
		$data_attrs = '';

		foreach( $params as $key => $value ) {
			if( $value == '' || $value == 'global' ) unset( $params[ $key ] );
		}

		if( isset( $params['videoid'] ) && $params['videoid'] > 0 ) {
			$db = JFactory::getDBO();
        	$query = "SELECT * FROM #__yendifvideoshare_videos WHERE id=".(int) $params['videoid'];
        	$db->setQuery( $query );
        	$item = $db->loadObject();
		}
		
		$poster = '';
		if( isset( $item->image ) && ! empty( $item->image ) ) {
			$poster = YendifVideoShareUtils::getImage( $item->image, '_poster', false );
			$vid_attrs .= ' poster='.$poster;
		}
		
		$ratio = isset( $params['ratio'] ) ? $params['ratio'] : $this->config->ratio;
		
		if( isset( $item->access ) && ! YendifVideoShareUtils::hasPermission( $item->access ) ) {
			$noPObj = '<div class="yendif-responsive-media" style="padding-bottom:'.( $ratio * 100 ).'%;">';
			if( $poster ) $noPObj .= '<img src="'.$poster.'" />';
			$noPObj .= '<div class="yendif-overlay"></div>';
			$noPObj .= '<div class="yendif-no-permission-content">'.JText::_('YENDIF_VIDEO_SHARE_NO_PERMISSION_VIDEO').'</div>';
			$noPObj .= '</div>';
			
			return $noPObj;
		}
		
		if( isset( $item->id ) ) {
			$this->addOGMetaTags( $item );
			$this->updateViews( $item->id );
			
			$data_attrs .= ' data-vid="'.$item->id.'"';
		} else {			
			$params['embed']    = 0;
			$params['download'] = 0;
			
			$data_attrs .= ' data-embed=0 data-download=0';
		}
		
		if( $item->type == 'thirdparty' ) {
			return '<div class="yendif-responsive-media" style="padding-bottom:'.( $ratio * 100 ).'%;">' . $item->thirdparty . '</div>';
		}
		
		// detect mobile device
		$is_mobile = true;
		if( preg_match( '/iPhone|iPod|iPad|BlackBerry|Android/', $_SERVER['HTTP_USER_AGENT'] ) ) {
			$is_mobile = true;
		};
		
		// check if adverts available
		$index = $is_advert = 0;
		$obj = '';
		if( $is_mobile == false && $this->config->enable_adverts != 'none' ) {
			// add preroll video
			if( ( $this->config->enable_adverts == 'preroll_only' || $this->config->enable_adverts == 'both' ) && $item->preroll != 0 ) {
       			$query = "SELECT * FROM #__yendifvideoshare_adverts WHERE published=1 AND (type=" . $db->quote('preroll') . " OR type=" . $db->quote('both') . ")";
				if( $item->preroll == -1 ) {
					$query .= " ORDER BY RAND() LIMIT 1";
				} else {
					$query .= " AND id=" . $item->preroll;
				}
       			$db->setQuery( $query );
       			$preroll = $db->loadObject();

				if( $preroll ) {
					$is_advert = 1;
					$obj['videos'][$index]['is_advert'] = 1;
					$obj['videos'][$index]['vid'] = $preroll->id;
					if( $poster ) {
						$obj['videos'][$index]['poster'] = $poster;
					}
					$obj['videos'][$index]['mp4'] = $preroll->mp4;	
					if($preroll->link) {
						$obj['videos'][$index]['ad_target'] = $preroll->link;
					}
					++$index;
				}
			}
			
			// get postroll video
			$postroll = 0;
			if( ( $this->config->enable_adverts == 'postroll_only' || $this->config->enable_adverts == 'both' ) && $item->postroll != 0 ) {
       			$query = "SELECT * FROM #__yendifvideoshare_adverts WHERE published=1 AND (type=" . $db->quote('postroll') . " OR type=" . $db->quote('both') . ")";
				if( $item->postroll == -1 ) {
					$query .= " ORDER BY RAND() LIMIT 1";
				} else {
					$query .= " AND id=" . $item->postroll;
				}
       			$db->setQuery( $query );
       			$postroll = $db->loadObject();

				if( $postroll ) {
					$is_advert = 1;		
				}
			}	
		}		
		
		// add main video
		$types = $this->types[ $item->type ];
		if( $is_advert == 1 ) {	
			
			array_push( $types, 'id', 'image' );
			$count = count( $types );			
			for( $i = 0; $i < $count; $i++ ) {					
				$type = $types[$i];
				if ( isset( $item->$type ) && ! empty( $item->$type ) ) {
					$src = $item->$type;
					switch( $type ) {	
				    	case 'id' :
							$type = 'vid';
							break;					
						case 'image' :
							if( $poster ) {
								$type = 'poster';
								$src = $poster;
							}							
							break;
						case 'mp4' :
							$filetype = strtolower( JFile::getExt($src) );
							$type = ( $filetype == 'm3u8' ) ? 'mpegurl' : ( $filetype == 'flv' ? 'flash' : 'mp4' );
							break;
						case 'mp4_hd' :
							$type = 'hd';
							break;
					}
					$obj['videos'][$index][$type] = $src;
				};			
			};
			++$index;
			
			// add postroll video
			if( $postroll ) {
				$obj['videos'][$index]['is_advert'] = 1;
				$obj['videos'][$index]['vid'] = $postroll->id;
				$obj['videos'][$index]['mp4'] = $postroll->mp4;
				if($postroll->link) {
					$obj['videos'][$index]['ad_target'] = $postroll->link;
				}
			}
			
			$count = count( $this->properties );
			for( $i = 0; $i < $count; $i++ ) {
				$key = $this->properties[$i];
				if ( isset( $params[$key] ) ) {
					switch ( $key ) {
						case 'volume' :
							$obj[$key] = $params[$key] / 100;
							break;
						case 'autoplay' :
						case 'show_skip_adverts_on' :
							$obj[$key] = (int) $params[$key];
							break;
						default :
							$obj[$key] = $params[$key];
					};				
				};				
			};
			$obj['autoplaylist'] = 1;
			$obj['is_advert'] = 1;
			$obj['playlist_hidden'] = 1;
		
			$uid = uniqid('yendif' . $this->players);
			
			if( $is_embed == true ) {
				$_returns = array();
				$_returns[0] = '$("#' . $uid . '").yendifplayer(' . json_encode( $obj ) . ');';
				$_returns[1] = '<div id="' . $uid . '"></div>';
				
				return $_returns;
			} else {
				$document = JFactory::getDocument();
				$document->addScriptDeclaration('
					(function ( $ ) {	
	    				"use strict";

	    				$(function () {
							$("#' . $uid . '").yendifplayer(' . json_encode( $obj ) . ');
						});

	  				}(jQuery));
				');
			
				return '<div id="' . $uid . '"></div>';
			}
		
		} else {
			
			$count = count( $types );
			$sources = '';
			for( $i = 0; $i < $count; $i++ ) {
				$type = $types[$i];
				if( isset( $item->$type ) && ! empty( $item->$type ) ) {
					$src = $item->$type;
					switch( $type ) {
						case 'mp4' :
							$filetype = strtolower( JFile::getExt($src) );
							$mimetype = ( $filetype == 'm3u8' ) ? 'application/x-mpegurl' : ( $filetype == 'flv' ? 'video/flash' : 'video/mp4' );
							if( ! empty( $item->mp4_hd ) ) $params['hd'] = $item->mp4_hd;
							$sources .= sprintf( '<source type="%s" src="%s">', $mimetype, $src );
							break;					
						case 'rtmp' :
							$sources .= '<source type="video/flash" src=' . $item->flash . ' data-rtmp="' . $src . '">';
							unset( $item->flash );
							break;
						case 'flash' :
							if( $item->type != 'rtmp' ) $sources .= '<source type="video/' . $type . '" src="' . $src . '">';
							break;
						case 'captions' :
							$sources .= '<track src="' . $src . '">';
							break;
						default :
							$sources .= '<source type="video/' . $type . '" src="' . $src . '">';
					};
				};
			};
		
			$properties = $this->properties;
			$count = count( $properties );
			for( $i = 0; $i < $count; $i++ ) {
				$key = $properties[$i];
				if( isset($params[$key]) ) {
					if( $key == 'volume' )	$params[$key] = $params[$key] / 100;
					$data_attrs .= " data-" . $key . '="' . $params[$key] . '"';
				};				
			};
		
			return '<div class="yendifplayer"' . $data_attrs . '><video' . $vid_attrs . '>' . $sources . '</video></div>';
				
		}	
	}
	
	function playlistPlayer( $params, $check_publishing_options ) {		
		++$this->players;

		foreach( $params as $key => $value ) {
			if( $value == '' || $value == 'global' ) unset( $params[ $key ] );
		}
		
		$db = JFactory::getDBO();
        $query = "SELECT * FROM #__yendifvideoshare_videos";
		
		$where = array();
		$where[] = "published=1";
		
		if( $check_publishing_options ) {
			$date = JFactory::getDate();
			
			$nullDate = $db->quote( $db->getNullDate() );
	    	$nowDate  = $db->quote( $date->toSql() );
		
			$where[] = " ( published_up = " . $nullDate . " OR published_up <= " . $nowDate .' )' ;
			$where[] = " ( published_down = " . $nullDate . " OR published_down >= " . $nowDate.' )';	
		}	
			
		$where[] = "type!=".$db->Quote('thirdparty');
		
		if( isset( $params['catid'] ) && $params['catid'] > 0 ) {
			$where[] = "catid=".$params['catid'];
		}
		
		if( isset( $params['featured']) && $params['featured'] == 'featured' ) {
		 	$where[] = "featured=1";
		}
		
		$user = JFactory::getUser();
		$viewLevels = $user->getAuthorisedViewLevels();
		$where[] = "access IN (''," . implode(',', $viewLevels) . ")";
		
		$where = ( count($where) ? ' WHERE '. implode(' AND ', $where) : '' );		 
		$query .= $where;	
		
		$orderby = isset( $params['orderby'] ) ? $params['orderby'] : '';
		switch( $orderby ) {	
			case 'latest' :
				$query .= ' ORDER BY created_date DESC';
				break;		
			case 'most_viewed' :
				$query .= ' ORDER BY views DESC';
				break;
			case 'most_rated' :
				$query .= ' ORDER BY rating DESC';
				break;
			case 'date_added' :
				$query .= ' ORDER BY created_date ASC';
				break;
			case 'a_z' :
				$query .= ' ORDER BY title ASC';
				break;
			case 'z_a' :
				$query .= ' ORDER BY title DESC';
				break;
			case 'random' :
				$query .= ' ORDER BY RAND()';
				break;
			case 'ordering' :
				$query .= ' ORDER BY ordering';
				break;
			default :
				$query .= ' ORDER BY id DESC';				
		}
		
		if( isset($params['limit']) && !empty($params['limit']) ) {
			$query .= " LIMIT ". (int) $params['limit'];
		}
		
        $db->setQuery( $query );
        $items = $db->loadObjectList();
		if( count( $items ) == 0 ) return null;
		
		$playlist_title_limit = isset( $params['playlist_title_limit'] ) ? $params['playlist_title_limit'] : $this->config->playlist_title_limit;
		$playlist_desc_limit = isset( $params['playlist_desc_limit'] )   ? $params['playlist_desc_limit'] : $this->config->playlist_desc_limit;
	
		$obj = ''; $index = 0;
		foreach( $items as $item ) {
			$types = $this->types[$item->type];
			array_push( $types, 'id', 'image', 'title', 'description', 'duration' );
			$count = count( $types );			
			for( $i = 0; $i < $count; $i++ ) {					
				$type = $types[$i];
				if( isset( $item->$type ) && ! empty( $item->$type ) ) {
					$src = $item->$type;
					switch($type) {	
					    case 'id' :
							$type = 'vid';
							break;					
						case 'image' :
							$type = 'poster';
							$src = YendifVideoShareUtils::getImage($item->image, '_poster', false);							
							break;
						case 'title' :
							$src = YendifVideoShareUtils::Truncate($src, $playlist_title_limit);
							break;
						case 'description' :
							$src = YendifVideoShareUtils::Truncate($src, $playlist_desc_limit);
							break;
						case 'mp4' :
							$filetype = strtolower( JFile::getExt( $src ) );
							$type = ( $filetype == 'm3u8' ) ? 'mpegurl' : ( $filetype == 'flv' ? 'flash' : 'mp4' );
							break;
						case 'mp4_hd' :
							$type = 'hd';
							break;
					}
					$obj['videos'][$index][$type] = $src;
				};			
			};			
			++$index;
		};
		
		$count = count( $this->properties );
		for( $i = 0; $i < $count; $i++ ) {
			$key = $this->properties[$i];
			if( isset( $params[ $key ] ) ) {
				switch( $key ) {
					case 'playlist_width' :
						$obj['playlistWidth'] = $params[$key];
						break;
					case 'playlist_height' :
						$obj['playlistHeight'] = $params[$key];
						break;
					case 'playlist_position' :
						$obj['playlistPosition'] = $params[$key];
						break;
					case 'volume' :
						$obj[$key] = $params[$key] / 100;
						break;
					case 'autoplay' :
					case 'autoplaylist' :
						$obj[$key] = (int) $params[$key];
						break;
					default :
						$obj[$key] = $params[$key];
				};				
			};				
		};
		
		$uid = uniqid('yendif' . $this->players);
		$document = JFactory::getDocument();
		$document->addScriptDeclaration('
			(function ( $ ) {	
	    		"use strict";

	    		$(function () {
					$("#' . $uid . '").yendifplayer(' . json_encode( $obj ) . ');
				});

	  		}(jQuery));
		');

		return '<div id="' . $uid . '"></div>';		
	}
	
	function addOGMetaTags( $item ) {
		if( JRequest::getCmd('option') == 'com_yendifvideoshare' && JRequest::getCmd('view') == 'video' &&  JRequest::getInt('id') == $item->id ) {
			$document = JFactory::getDocument();
			$document->addCustomTag('<meta property="og:title" content="'.$item->title.'" />');
        	$document->addCustomTag('<meta property="og:image" content="'.$item->image.'" />');	
		}
	}
	
	function updateViews( $videoid ) {	
		$session = JFactory::getSession();	
		$ses_videos = $session->get('yendif_videos', array());

		if( ! in_array( $videoid, $ses_videos ) ) {
		    $ses_videos[] = $videoid;
				
		 	$db = JFactory::getDBO();     	    
		 	$query = "SELECT views FROM #__yendifvideoshare_videos WHERE id=" . (int) $videoid;
    	 	$db->setQuery ( $query );
    	 	$result = $db->loadObject();
		 
		 	$count = $result ? $result->views + 1 : 1;	 
		 	$query = "UPDATE #__yendifvideoshare_videos SET views=".$count." WHERE id=" . (int) $videoid;
    	 	$db->setQuery ( $query );
		 	$db->query();
		 
		 	$session->set('yendif_videos', $ses_videos);
		}
	}
		
}