<?php

/*
 * @version		$Id: import.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class YendifVideoShareControllerImport extends YendifVideoShareController {

	function import() {
		$model = $this->getModel( 'import' );
		
	    $view = $this->getView( 'import', 'html' );       		
        $view->setModel( $model, true );		
		$view->setLayout( 'default' );
		$view->display();
	}
	
	function saveApiKey() {
		if( JRequest::checkToken( 'get' ) ) {
			JRequest::checkToken( 'get' ) or die( 'Invalid Token' );
		} else {
			JRequest::checkToken() or die( 'Invalid Token' );
		}
		
		$model = $this->getModel('import');
	  	$model->saveApiKey();
	}
	
	function insertVideos() {
		$videos = JRequest::getVar( 'ids', array(), '', 'array' );
		$ids    = array();
		$titles = array();
		
		if( count( $videos ) > 0 ) {
		
			foreach( $videos as $video ) {
				$infos    = explode( "@", $video );
				$ids[]    = $infos[0];
				$titles[] = $infos[1];
			}
			
			$model = $this->getModel( 'import' );		
			$model->insertVideos( $ids, $titles );
			
		} else {
		
			echo "Please select atleast one video.";
			
		}
		exit();
	}
		
}