/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.SizeRenderer;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.FileUploadThreadFTP;
import wjhk.jupload2.upload.FileUploadThreadHTTP;
import wjhk.jupload2.upload.UploadFileData;

public class FileUploadManagerThread
extends Thread
implements ActionListener {
    public static final int UPLOAD_STATUS_NOT_STARTED = 1;
    public static final int UPLOAD_STATUS_UPLOADING = 2;
    public static final int UPLOAD_STATUS_CHUNK_UPLOADED_WAITING_FOR_RESPONSE = 3;
    public static final int UPLOAD_STATUS_FILE_UPLOADED_WAITING_FOR_RESPONSE = 4;
    public static final int UPLOAD_STATUS_UPLOADED = 5;
    long currentRequestStartTime = 0L;
    FilePanel filePanel = null;
    FileUploadThread fileUploadThread = null;
    long globalStartTime = 0L;
    long maxChunkSize = -1L;
    long nbBytesReadyForUpload = 0L;
    int nbFilesBeingUploaded = 0;
    int nbFilesPerRequest = -1;
    int nbPreparedFiles = 0;
    int nbSentFiles = 0;
    int nbSuccessfullyUploadedFiles = 0;
    long nbBytesUploadedForCurrentFile = 0L;
    long nbTotalNumberOfPreparedBytes = 0L;
    int numOfFileInCurrentRequest = 0;
    int uploadStatus = 1;
    UploadFileData[] nextPacket = null;
    JProgressBar preparationProgressBar = null;
    JProgressBar uploadProgressBar = null;
    boolean uploadFinished = false;
    long uploadStartTime = 0L;
    boolean stop = false;
    JUploadException uploadException = null;
    long uploadDuration = 0L;
    long nbUploadedBytes = 0L;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;
    UploadFileData[] uploadFileDataArray = null;
    Timer timerStatusBar = new Timer(1000, this);
    Timer timerProgressBar = new Timer(50, this);

    public FileUploadManagerThread(UploadPolicy uploadPolicy) throws JUploadException {
        super("FileUploadManagerThread thread");
        this.constructor(uploadPolicy, null);
    }

    public FileUploadManagerThread(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        super("FileUploadManagerThread test thread");
        this.constructor(uploadPolicy, fileUploadThreadParam);
    }

    private synchronized void constructor(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        this.uploadProgressBar = this.uploadPanel.getUploadProgressBar();
        this.preparationProgressBar = this.uploadPanel.getPreparationProgressBar();
        this.createUploadThread(fileUploadThreadParam);
        this.nbFilesPerRequest = this.uploadPolicy.getNbFilesPerRequest();
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        FileData[] fileDataArray = this.uploadPanel.getFilePanel().getFiles();
        this.uploadFileDataArray = new UploadFileData[fileDataArray.length];
        for (int i = 0; i < this.uploadFileDataArray.length; ++i) {
            this.uploadFileDataArray[i] = new UploadFileData(fileDataArray[i], this, this.uploadPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.uploadPolicy.displayDebug("Start of the FileUploadManagerThread", 5);
            this.uploadPolicy.beforeUpload();
            this.uploadPanel.updateButtonState();
            this.initProgressBar();
            this.timerProgressBar.start();
            this.timerStatusBar.start();
            this.uploadPolicy.displayDebug("Timer started", 50);
            this.prepareFiles();
            while (this.fileUploadThread.isAlive() && this.nbSuccessfullyUploadedFiles < this.uploadFileDataArray.length && !this.isUploadStopped() && this.getUploadException() == null) {
                try {
                    this.uploadPolicy.displayDebug("Waiting for fileUploadThread to die", 10);
                    this.fileUploadThread.join();
                }
                catch (InterruptedException e) {
                    this.uploadPolicy.displayWarn("An InterruptedException occured in FileUploadManagerThread.run()");
                }
            }
            for (int i = 0; i < this.uploadFileDataArray.length; ++i) {
                if (!this.uploadFileDataArray[i].isPreparedForUpload()) continue;
                this.uploadFileDataArray[i].afterUpload();
            }
            this.uploadPanel.updateButtonState();
            this.uploadPolicy.getContext().showStatus("");
            this.uploadPolicy.getContext().getUploadPanel().getStatusLabel().setText("");
            if (this.getUploadException() != null) {
                this.uploadPolicy.sendDebugInformation("Error in Upload", this.getUploadException());
            } else if (this.isUploadStopped()) {
                this.uploadPolicy.displayInfo("Upload stopped by the user. " + this.nbSuccessfullyUploadedFiles + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.globalStartTime) / 1000L) + " seconds. Average upload speed: " + (this.uploadDuration > 0L ? (int)(this.nbUploadedBytes / this.uploadDuration) : 0) + " (kbytes/s)");
            } else {
                this.uploadPolicy.displayInfo("Upload finished normally. " + this.uploadFileDataArray.length + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.globalStartTime) / 1000L) + " seconds. Average upload speed: " + (this.uploadDuration > 0L ? (int)(this.nbUploadedBytes / this.uploadDuration) : 0) + " (kbytes/s)");
                try {
                    this.uploadPolicy.afterUpload(this.getUploadException(), this.fileUploadThread.getResponseMsg());
                }
                catch (JUploadException e1) {
                    this.uploadPolicy.displayErr("error in uploadPolicy.afterUpload (JUploadPanel)", e1);
                }
            }
            this.timerProgressBar.stop();
            this.timerStatusBar.stop();
            if (!this.isUploadStopped() && this.getUploadException() != null) {
                try {
                    FileUploadManagerThread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.preparationProgressBar.setValue(0);
            this.preparationProgressBar.setString("");
            this.uploadProgressBar.setValue(0);
            this.uploadProgressBar.setString("");
            this.uploadPolicy.displayDebug("End of the FileUploadManagerThread", 5);
        }
        catch (JUploadException jue) {
            this.setUploadException(jue);
            this.uploadPolicy.displayErr("Uncaught exception in FileUploadManagerThread/run()", jue);
            this.stopUpload();
        }
        finally {
            this.uploadPanel.updateButtonState();
        }
    }

    public int getNbUploadedFiles() {
        return this.nbSentFiles;
    }

    public final long getUploadStartTime() {
        return this.uploadStartTime;
    }

    public synchronized void setUploadException(JUploadException uploadException) {
        if (this.uploadException != null) {
            this.uploadPolicy.displayWarn("An exception has already been set in FileUploadManagerThread. The next one is just logged.");
        } else {
            this.uploadException = uploadException;
        }
        this.uploadPolicy.displayErr(uploadException);
        this.preparationProgressBar.setString(uploadException.getMessage());
        this.uploadFinished = true;
    }

    public JUploadException getUploadException() {
        return this.uploadException;
    }

    public boolean isUploadFinished() {
        return this.uploadFinished;
    }

    private boolean isUploadStopped() {
        return this.stop;
    }

    public synchronized void nbBytesUploaded(long nbBytes) throws JUploadException {
        this.nbUploadedBytes += nbBytes;
        this.nbBytesUploadedForCurrentFile += nbBytes;
    }

    public synchronized void setUploadStatus(int numOfFileInCurrentRequest, int uploadStatus) throws JUploadException {
        if (this.globalStartTime == 0L) {
            this.globalStartTime = System.currentTimeMillis();
        }
        switch (uploadStatus) {
            case 3: 
            case 4: {
                this.uploadDuration += System.currentTimeMillis() - this.currentRequestStartTime;
                this.currentRequestStartTime = 0L;
                break;
            }
            case 2: {
                if (this.currentRequestStartTime != 0L) break;
                this.currentRequestStartTime = System.currentTimeMillis();
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown value for uploadStatus: " + uploadStatus);
            }
        }
        this.numOfFileInCurrentRequest = numOfFileInCurrentRequest;
        this.uploadStatus = uploadStatus;
        this.updateUploadProgressBar();
    }

    public synchronized void stopUpload() {
        this.stop = true;
        this.uploadFinished = true;
        if (this.fileUploadThread != null) {
            this.fileUploadThread.interrupt();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            if (this.isUploadFinished()) {
                this.timerProgressBar.stop();
            }
            if (e.getSource() == this.timerProgressBar) {
                this.updateUploadProgressBar();
            }
            if (e.getSource() == this.timerStatusBar) {
                this.updateUploadStatusBar();
            }
        }
    }

    private void updateUploadStatusBar() {
        if (null != this.uploadPanel.getStatusLabel() && this.getUploadStartTime() != 0L && this.nbUploadedBytes > 0L) {
            String eta;
            double globalCPS;
            double uploadSpeed;
            double percent;
            long actualUploadDuration = this.currentRequestStartTime == 0L ? this.uploadDuration : this.uploadDuration + System.currentTimeMillis() - this.currentRequestStartTime;
            actualUploadDuration /= 1000L;
            double totalFileBytesToSend = this.nbPreparedFiles == this.uploadFileDataArray.length ? (double)this.nbTotalNumberOfPreparedBytes : (double)(this.nbTotalNumberOfPreparedBytes + (long)(this.uploadFileDataArray.length - this.nbPreparedFiles) * this.nbTotalNumberOfPreparedBytes / (long)this.nbPreparedFiles);
            try {
                percent = 100.0 * (double)this.nbUploadedBytes / totalFileBytesToSend;
            }
            catch (ArithmeticException e1) {
                percent = 100.0;
            }
            try {
                uploadSpeed = (double)this.nbUploadedBytes / (double)actualUploadDuration;
            }
            catch (ArithmeticException e1) {
                uploadSpeed = this.nbUploadedBytes;
            }
            try {
                globalCPS = (double)this.nbUploadedBytes / (double)(System.currentTimeMillis() - this.globalStartTime) * 1000.0;
            }
            catch (ArithmeticException e1) {
                globalCPS = this.nbUploadedBytes;
            }
            try {
                long remaining = (long)((totalFileBytesToSend - (double)this.nbUploadedBytes) / globalCPS);
                eta = remaining > 3600L ? String.format(this.uploadPolicy.getString("timefmt_hms"), remaining / 3600L, remaining / 60L % 60L, remaining % 60L) : (remaining > 60L ? String.format(this.uploadPolicy.getString("timefmt_ms"), remaining / 60L, remaining % 60L) : String.format(this.uploadPolicy.getString("timefmt_s"), remaining));
            }
            catch (ArithmeticException e1) {
                eta = this.uploadPolicy.getString("timefmt_unknown");
            }
            String format = this.uploadPolicy.getString("status_msg");
            String status = String.format(format, (int)percent, SizeRenderer.formatFileUploadSpeed(uploadSpeed, this.uploadPolicy), eta);
            this.uploadPanel.getStatusLabel().setText(status);
            this.uploadPolicy.getContext().showStatus(status);
        }
    }

    private synchronized boolean checkIfNextPacketIsReady() throws JUploadException {
        if (this.nextPacket == null && this.nbSentFiles + this.nbFilesBeingUploaded != this.nbPreparedFiles) {
            int maxPacketSize = Math.min(this.nbPreparedFiles - this.nbSentFiles - this.nbFilesBeingUploaded, this.nbFilesPerRequest);
            FileData[] tempFileData = new FileData[maxPacketSize];
            int nbFilesInPacket = 0;
            long packetLength = 0L;
            boolean isPacketFinished = false;
            while (!isPacketFinished && nbFilesInPacket < maxPacketSize && packetLength < this.maxChunkSize) {
                UploadFileData currentFileData = this.uploadFileDataArray[this.nbSentFiles + this.nbFilesBeingUploaded + nbFilesInPacket];
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".checkIfNextPacketIsReady(): before call(1) to currentFileData.getUploadLength()", 100);
                if (nbFilesInPacket > 0 && packetLength + currentFileData.getUploadLength() > this.maxChunkSize) {
                    isPacketFinished = true;
                    continue;
                }
                tempFileData[nbFilesInPacket] = currentFileData;
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".checkIfNextPacketIsReady(): before call(2) to currentFileData.getUploadLength()", 100);
                packetLength += currentFileData.getUploadLength();
                ++nbFilesInPacket;
            }
            if (!isPacketFinished) {
                if (packetLength > this.maxChunkSize) {
                    if (nbFilesInPacket > 1) {
                        throw new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should not be more than 1 (checkIfNextPacketIsReady)");
                    }
                    isPacketFinished = true;
                } else if (nbFilesInPacket == this.nbFilesPerRequest) {
                    isPacketFinished = true;
                } else if (this.nbSentFiles + this.nbFilesBeingUploaded + nbFilesInPacket == this.uploadFileDataArray.length) {
                    isPacketFinished = true;
                }
            }
            if (isPacketFinished) {
                this.nextPacket = new UploadFileData[nbFilesInPacket];
                System.arraycopy(tempFileData, 0, this.nextPacket, 0, nbFilesInPacket);
            }
        }
        return this.nextPacket != null;
    }

    private synchronized void anotherFileIsReady(FileData newlyPreparedFileData) throws JUploadException {
        ++this.nbPreparedFiles;
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".anotherFileIsReady(): before call(1) to newlyPreparedFileData.getUploadLength()", 100);
        this.nbBytesReadyForUpload += newlyPreparedFileData.getUploadLength();
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".checkIfNextPacketIsReady(): before call(2) to currentFileData.getUploadLength()", 100);
        this.nbTotalNumberOfPreparedBytes += newlyPreparedFileData.getUploadLength();
    }

    public synchronized void anotherFileHasBeenSent(FileData newlyUploadedFileData) throws JUploadException {
        ++this.nbSentFiles;
        --this.nbFilesBeingUploaded;
        this.nbBytesUploadedForCurrentFile = 0L;
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".anotherFileHasBeenSent(): before call to newlyUploadedFileData.getUploadLength()", 100);
        this.nbBytesReadyForUpload -= newlyUploadedFileData.getUploadLength();
        this.uploadStatus = 5;
        this.updateUploadProgressBar();
    }

    public synchronized void currentRequestIsFinished(UploadFileData[] currentPacket) throws JUploadException {
        if (this.getUploadException() == null) {
            for (int i = 0; i < currentPacket.length; ++i) {
                this.filePanel.remove(currentPacket[i]);
                ++this.nbSuccessfullyUploadedFiles;
            }
            if (!this.uploadFinished) {
                this.uploadFinished = this.nbSuccessfullyUploadedFiles == this.uploadFileDataArray.length;
            }
        } else {
            this.uploadFinished = true;
        }
    }

    public synchronized UploadFileData[] getNextPacket() throws JUploadException {
        if (this.isUploadFinished()) {
            return null;
        }
        if (this.nextPacket == null) {
            this.checkIfNextPacketIsReady();
        }
        if (this.nextPacket == null || this.isUploadFinished()) {
            return null;
        }
        if (this.nbSentFiles == 0 && this.uploadStartTime == 0L) {
            this.uploadStartTime = System.currentTimeMillis();
        }
        UploadFileData[] fileDataTmp = this.nextPacket;
        this.nextPacket = null;
        this.nbFilesBeingUploaded += fileDataTmp.length;
        return fileDataTmp;
    }

    private void updateUploadProgressBar() {
        String msgInfoUploaded = this.uploadPolicy.getString("infoUploaded");
        String msgInfoUploading = this.uploadPolicy.getString("infoUploading");
        String msgNbUploadedFiles = this.uploadPolicy.getString("nbUploadedFiles");
        int percent = 0;
        if (this.nbBytesUploadedForCurrentFile == 0L || this.nbSentFiles == this.uploadFileDataArray.length) {
            percent = 0;
        } else {
            try {
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".updateUploadProgressBar(): before call to this.uploadFileDataArray[this.nbSentFiles].getUploadLength()", 100);
                percent = (int)(this.nbBytesUploadedForCurrentFile * 100L / this.uploadFileDataArray[this.nbSentFiles].getUploadLength());
            }
            catch (JUploadException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + " in updateUploadProgressBar (" + e.getMessage() + "). percent forced to 0.");
                percent = 0;
            }
            if (percent > 100) {
                this.uploadPolicy.displayWarn("percent is more than 100 (" + percent + ") in FileUploadManagerThread.update.UploadProgressBar");
                percent = 100;
            }
        }
        this.uploadProgressBar.setValue(100 * this.nbSentFiles + percent);
        String msg = null;
        switch (this.uploadStatus) {
            case 1: {
                msg = "";
                break;
            }
            case 2: 
            case 3: {
                msg = String.format(msgInfoUploading, this.nbSentFiles + 1);
                break;
            }
            case 4: {
                msg = this.numOfFileInCurrentRequest == 1 ? this.nbSentFiles + "/" + this.uploadFileDataArray.length : this.nbSentFiles - this.numOfFileInCurrentRequest + 1 + "-" + this.nbSentFiles + "/" + this.uploadFileDataArray.length;
                msg = String.format(msgInfoUploaded, msg);
                break;
            }
            case 5: {
                msg = String.format(msgNbUploadedFiles, this.nbSentFiles);
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown upload status in FileUploadManagerThread.updateProgressBar(): " + this.uploadStatus);
            }
        }
        this.uploadProgressBar.setString(msg);
        this.uploadProgressBar.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFiles() {
        this.preparationProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        try {
            for (int i = 0; i < this.uploadFileDataArray.length && !this.isUploadFinished(); ++i) {
                this.uploadPolicy.displayDebug("============== Start of file preparation (" + this.uploadFileDataArray[i].getFileName() + ")", 30);
                this.preparationProgressBar.setString(String.format(this.uploadPolicy.getString("preparingFile"), i + 1, this.uploadFileDataArray.length));
                this.preparationProgressBar.repaint();
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".prepareFiles(): before call to beforeUpload()", 100);
                this.uploadFileDataArray[i].beforeUpload();
                this.uploadPolicy.displayDebug("============== End of file preparation (" + this.uploadFileDataArray[i].getFileName() + ")", 30);
                this.anotherFileIsReady(this.uploadFileDataArray[i]);
                FileUploadManagerThread fileUploadManagerThread = this;
                synchronized (fileUploadManagerThread) {
                    this.preparationProgressBar.setValue(this.nbPreparedFiles * 100);
                }
                this.preparationProgressBar.repaint();
            }
        }
        catch (JUploadException e) {
            this.setUploadException(e);
            this.stopUpload();
        }
    }

    private synchronized void createUploadThread(FileUploadThread fileUploadThreadParam) throws JUploadException {
        if (fileUploadThreadParam != null) {
            this.fileUploadThread = fileUploadThreadParam;
            fileUploadThreadParam.setFileUploadThreadManager(this);
        } else {
            try {
                this.fileUploadThread = this.uploadPolicy.getPostURL().substring(0, 4).equals("ftp:") ? new FileUploadThreadFTP(this.uploadPolicy, this) : new FileUploadThreadHTTP(this.uploadPolicy, this);
            }
            catch (JUploadException e1) {
                this.uploadPolicy.displayErr(e1);
            }
        }
        this.fileUploadThread.start();
    }

    private void initProgressBar() throws JUploadException {
        this.preparationProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        this.preparationProgressBar.setString("");
        this.uploadProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        this.uploadProgressBar.setString("");
        this.updateUploadProgressBar();
    }
}

