/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.DateRenderer;
import wjhk.jupload2.gui.filepanel.FilePanelDataModel2;
import wjhk.jupload2.gui.filepanel.NameRenderer;
import wjhk.jupload2.gui.filepanel.SizeRenderer;
import wjhk.jupload2.gui.filepanel.SortHeaderRenderer;
import wjhk.jupload2.policies.UploadPolicy;

public class FilePanelJTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 5422667664740339798L;
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;
    UploadPolicy uploadPolicy;
    FilePanelDataModel2 filePanelDataModel;

    public FilePanelJTable(JUploadPanel jup, UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(Long.class, new SizeRenderer(uploadPolicy));
        this.setDefaultRenderer(Date.class, new DateRenderer(uploadPolicy));
        this.setDefaultRenderer(String.class, new NameRenderer());
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortHeaderRenderer());
        header.addMouseListener(this);
        this.addMouseListener(jup);
    }

    public void setModel(FilePanelDataModel2 filePanelDataModel) {
        super.setModel(filePanelDataModel);
        this.filePanelDataModel = filePanelDataModel;
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseReleased(MouseEvent event) {
        this.uploadPolicy.getContext().getUploadPanel().maybeOpenPopupMenu(event);
    }

    public void mousePressed(MouseEvent event) {
        this.uploadPolicy.getContext().getUploadPanel().maybeOpenPopupMenu(event);
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            int selectedRow = this.getSelectedRow();
            if (selectedRow >= 0) {
                this.uploadPolicy.onFileSelected(this.filePanelDataModel.getFileDataAt(selectedRow));
            }
        } else if (!this.uploadPolicy.getContext().getUploadPanel().maybeOpenPopupMenu(event)) {
            TableColumnModel colModel = this.getColumnModel();
            int index = colModel.getColumnIndexAtX(event.getX());
            int modelIndex = colModel.getColumn(index).getModelIndex();
            FilePanelDataModel2 model = (FilePanelDataModel2)this.getModel();
            if (model.isSortable(modelIndex)) {
                if (this.sortedColumnIndex == index) {
                    this.sortedColumnAscending = !this.sortedColumnAscending;
                }
                this.sortedColumnIndex = index;
                model.sortColumn(modelIndex, this.sortedColumnAscending);
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting() || this.uploadPolicy == null) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.uploadPolicy.onFileSelected(null);
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            if (selectedRow == lsm.getMaxSelectionIndex()) {
                Cursor previousCursor = this.uploadPolicy.setWaitCursor();
                this.uploadPolicy.onFileSelected(this.filePanelDataModel.getFileDataAt(selectedRow));
                this.uploadPolicy.setCursor(previousCursor);
            }
        }
    }
}

